/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ToIntFunctor;

public class CharToIntegerCast<T extends Any>
implements ToIntFunctor<T> {
    private final WritableIntChunk<T> result;

    CharToIntegerCast(int size) {
        this.result = WritableIntChunk.makeWritableChunk(size);
    }

    @Override
    public IntChunk<? extends T> apply(Chunk<? extends T> input) {
        return this.cast(input.asCharChunk());
    }

    private IntChunk<T> cast(CharChunk<? extends T> input) {
        CharToIntegerCast.castInto(input, this.result);
        return this.result;
    }

    public static <T2 extends Any> void castInto(CharChunk<? extends T2> input, WritableIntChunk<T2> result) {
        for (int ii = 0; ii < input.size(); ++ii) {
            result.set(ii, input.get(ii));
        }
        result.setSize(input.size());
    }

    @Override
    public void close() {
        this.result.close();
    }
}

