/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ToLongFunctor;

public class CharToLongCast<T extends Any>
implements ToLongFunctor<T> {
    private final WritableLongChunk<T> result;

    CharToLongCast(int size) {
        this.result = WritableLongChunk.makeWritableChunk(size);
    }

    @Override
    public LongChunk<T> apply(Chunk<T> input) {
        return this.cast(input.asCharChunk());
    }

    private LongChunk<T> cast(CharChunk<T> input) {
        CharToLongCast.castInto(input, this.result);
        return this.result;
    }

    public static <T2 extends Any> void castInto(CharChunk<? extends T2> input, WritableLongChunk<? super T2> result) {
        for (int ii = 0; ii < input.size(); ++ii) {
            result.set(ii, input.get(ii));
        }
        result.setSize(input.size());
    }

    @Override
    public void close() {
        this.result.close();
    }
}

