/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.util.hashing.BooleanChunkEquals;
import io.deephaven.chunk.util.hashing.ByteChunkEquals;
import io.deephaven.chunk.util.hashing.CharChunkEquals;
import io.deephaven.chunk.util.hashing.DoubleChunkEquals;
import io.deephaven.chunk.util.hashing.FloatChunkEquals;
import io.deephaven.chunk.util.hashing.IntChunkEquals;
import io.deephaven.chunk.util.hashing.LongChunkEquals;
import io.deephaven.chunk.util.hashing.ObjectChunkEquals;
import io.deephaven.chunk.util.hashing.ShortChunkEquals;

public interface ChunkEquals {
    public boolean equalReduce(Chunk<? extends Any> var1, Chunk<? extends Any> var2);

    public void equal(Chunk<? extends Any> var1, Chunk<? extends Any> var2, WritableBooleanChunk var3);

    public void equalNext(Chunk<? extends Any> var1, WritableBooleanChunk var2);

    public void equalPermuted(IntChunk<ChunkPositions> var1, IntChunk<ChunkPositions> var2, Chunk<? extends Any> var3, Chunk<? extends Any> var4, WritableBooleanChunk var5);

    public void equalLhsPermuted(IntChunk<ChunkPositions> var1, Chunk<? extends Any> var2, Chunk<? extends Any> var3, WritableBooleanChunk var4);

    public void andEqual(Chunk<? extends Any> var1, Chunk<? extends Any> var2, WritableBooleanChunk var3);

    public void andEqualNext(Chunk<? extends Any> var1, WritableBooleanChunk var2);

    public void andEqualPermuted(IntChunk<ChunkPositions> var1, IntChunk<ChunkPositions> var2, Chunk<? extends Any> var3, Chunk<? extends Any> var4, WritableBooleanChunk var5);

    public void andEqualLhsPermuted(IntChunk<ChunkPositions> var1, Chunk<? extends Any> var2, Chunk<? extends Any> var3, WritableBooleanChunk var4);

    public void notEqual(Chunk<? extends Any> var1, Chunk<? extends Any> var2, WritableBooleanChunk var3);

    public void andNotEqual(Chunk<? extends Any> var1, Chunk<? extends Any> var2, WritableBooleanChunk var3);

    public void equalPairs(IntChunk<ChunkPositions> var1, Chunk<? extends Any> var2, WritableBooleanChunk var3);

    public void andEqualPairs(IntChunk<ChunkPositions> var1, Chunk<? extends Any> var2, WritableBooleanChunk var3);

    public static ChunkEquals makeEqual(ChunkType chunkType) {
        switch (chunkType) {
            case Boolean: {
                return BooleanChunkEquals.INSTANCE;
            }
            case Byte: {
                return ByteChunkEquals.INSTANCE;
            }
            case Char: {
                return CharChunkEquals.INSTANCE;
            }
            case Int: {
                return IntChunkEquals.INSTANCE;
            }
            case Short: {
                return ShortChunkEquals.INSTANCE;
            }
            case Long: {
                return LongChunkEquals.INSTANCE;
            }
            case Float: {
                return FloatChunkEquals.INSTANCE;
            }
            case Double: {
                return DoubleChunkEquals.INSTANCE;
            }
            case Object: {
                return ObjectChunkEquals.INSTANCE;
            }
        }
        throw new IllegalStateException();
    }
}

