/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.BooleanChunkHasher;
import io.deephaven.chunk.util.hashing.ByteChunkHasher;
import io.deephaven.chunk.util.hashing.CharChunkHasher;
import io.deephaven.chunk.util.hashing.DoubleChunkHasher;
import io.deephaven.chunk.util.hashing.FloatChunkHasher;
import io.deephaven.chunk.util.hashing.IntChunkHasher;
import io.deephaven.chunk.util.hashing.LongChunkHasher;
import io.deephaven.chunk.util.hashing.ObjectChunkHasher;
import io.deephaven.chunk.util.hashing.ShortChunkHasher;

public interface ChunkHasher {
    public void hashInitial(Chunk<Values> var1, WritableIntChunk<HashCodes> var2);

    public void hashUpdate(Chunk<Values> var1, WritableIntChunk<HashCodes> var2);

    public int hashInitial(Object var1);

    public int hashUpdate(int var1, Object var2);

    public static ChunkHasher makeHasher(ChunkType chunkType) {
        switch (chunkType) {
            case Boolean: {
                return BooleanChunkHasher.INSTANCE;
            }
            case Byte: {
                return ByteChunkHasher.INSTANCE;
            }
            case Char: {
                return CharChunkHasher.INSTANCE;
            }
            case Int: {
                return IntChunkHasher.INSTANCE;
            }
            case Short: {
                return ShortChunkHasher.INSTANCE;
            }
            case Long: {
                return LongChunkHasher.INSTANCE;
            }
            case Float: {
                return FloatChunkHasher.INSTANCE;
            }
            case Double: {
                return DoubleChunkHasher.INSTANCE;
            }
            case Object: {
                return ObjectChunkHasher.INSTANCE;
            }
        }
        throw new IllegalStateException();
    }

    public static int scrambleHash(int x) {
        x = (x >> 16 ^ x) * 73244475;
        x = (x >> 16 ^ x) * 73244475;
        x = x >> 16 ^ x;
        return x & Integer.MAX_VALUE;
    }
}

