/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.util.hashing.ChunkEquals;

public class DoubleChunkEquals
implements ChunkEquals {
    public static DoubleChunkEquals INSTANCE = new DoubleChunkEquals();

    public static boolean equalReduce(DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int ii = 0; ii < lhs.size(); ++ii) {
            if (DoubleChunkEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return false;
        }
        return true;
    }

    public static int firstDifference(DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs) {
        int ii = 0;
        for (ii = 0; ii < lhs.size() && ii < rhs.size(); ++ii) {
            if (DoubleChunkEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return ii;
        }
        return ii;
    }

    private static void equal(DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, DoubleChunkEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void equalNext(DoubleChunk<? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, DoubleChunkEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equal(DoubleChunk<? extends Any> lhs, double rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, DoubleChunkEquals.eq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, DoubleChunkEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(DoubleChunk<? extends Any> lhs, double rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, DoubleChunkEquals.neq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqual(DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && DoubleChunkEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andNotEqual(DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && DoubleChunkEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqualNext(DoubleChunk<? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, destination.get(ii) && DoubleChunkEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, DoubleChunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = DoubleChunkEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(pairCount);
    }

    private static void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, DoubleChunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            if (!destinations.get(ii)) continue;
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = DoubleChunkEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
    }

    private static void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = DoubleChunkEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = DoubleChunkEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = DoubleChunkEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, DoubleChunk<? extends Any> lhs, DoubleChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = DoubleChunkEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    @Override
    public boolean equalReduce(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs) {
        return DoubleChunkEquals.equalReduce(lhs.asDoubleChunk(), rhs.asDoubleChunk());
    }

    @Override
    public void equal(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.equal(lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    public static void equal(Chunk<? extends Any> lhs, double rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.equal(lhs.asDoubleChunk(), rhs, destination);
    }

    @Override
    public void equalNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        DoubleChunkEquals.equalNext(chunk.asDoubleChunk(), destination);
    }

    @Override
    public void andEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.andEqual(lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    @Override
    public void andEqualNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        DoubleChunkEquals.andEqualNext(chunk.asDoubleChunk(), destination);
    }

    @Override
    public void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.equalPermuted(lhsPositions, rhsPositions, lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    @Override
    public void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.equalLhsPermuted(lhsPositions, lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    @Override
    public void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.andEqualPermuted(lhsPositions, rhsPositions, lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    @Override
    public void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.andEqualLhsPermuted(lhsPositions, lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    @Override
    public void notEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.notEqual(lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    public static void notEqual(Chunk<? extends Any> lhs, double rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.notEqual(lhs.asDoubleChunk(), rhs, destination);
    }

    @Override
    public void andNotEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        DoubleChunkEquals.andNotEqual(lhs.asDoubleChunk(), rhs.asDoubleChunk(), destination);
    }

    @Override
    public void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        DoubleChunkEquals.equalPairs(chunkPositionsToCheckForEquality, valuesChunk.asDoubleChunk(), destinations);
    }

    @Override
    public void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        DoubleChunkEquals.andEqualPairs(chunkPositionsToCheckForEquality, valuesChunk.asDoubleChunk(), destinations);
    }

    private static boolean eq(double lhs, double rhs) {
        return Double.isNaN(lhs) && Double.isNaN(rhs) || lhs == rhs;
    }

    private static boolean neq(double lhs, double rhs) {
        return !DoubleChunkEquals.eq(lhs, rhs);
    }
}

