/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class DoubleChunkHasher
implements ChunkHasher {
    public static DoubleChunkHasher INSTANCE = new DoubleChunkHasher();

    private static void hashInitial(DoubleChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            double value = values.get(ii);
            destination.set(ii, DoubleChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(DoubleChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, DoubleChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(double value) {
        return ChunkHasher.scrambleHash(Double.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, double newValue) {
        return existing * 31 + DoubleChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return DoubleChunkHasher.hashInitialSingle(TypeUtils.unbox((Double)((Double)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return DoubleChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Double)((Double)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        DoubleChunkHasher.hashInitial(values.asDoubleChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        DoubleChunkHasher.hashSecondary(values.asDoubleChunk(), destination);
    }
}

