/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.util.hashing.ChunkEquals;

public class FloatChunkEquals
implements ChunkEquals {
    public static FloatChunkEquals INSTANCE = new FloatChunkEquals();

    public static boolean equalReduce(FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int ii = 0; ii < lhs.size(); ++ii) {
            if (FloatChunkEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return false;
        }
        return true;
    }

    public static int firstDifference(FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs) {
        int ii = 0;
        for (ii = 0; ii < lhs.size() && ii < rhs.size(); ++ii) {
            if (FloatChunkEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return ii;
        }
        return ii;
    }

    private static void equal(FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, FloatChunkEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void equalNext(FloatChunk<? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, FloatChunkEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equal(FloatChunk<? extends Any> lhs, float rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, FloatChunkEquals.eq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, FloatChunkEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(FloatChunk<? extends Any> lhs, float rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, FloatChunkEquals.neq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqual(FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && FloatChunkEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andNotEqual(FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && FloatChunkEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqualNext(FloatChunk<? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, destination.get(ii) && FloatChunkEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, FloatChunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = FloatChunkEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(pairCount);
    }

    private static void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, FloatChunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            if (!destinations.get(ii)) continue;
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = FloatChunkEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
    }

    private static void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = FloatChunkEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = FloatChunkEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = FloatChunkEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, FloatChunk<? extends Any> lhs, FloatChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = FloatChunkEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    @Override
    public boolean equalReduce(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs) {
        return FloatChunkEquals.equalReduce(lhs.asFloatChunk(), rhs.asFloatChunk());
    }

    @Override
    public void equal(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.equal(lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    public static void equal(Chunk<? extends Any> lhs, float rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.equal(lhs.asFloatChunk(), rhs, destination);
    }

    @Override
    public void equalNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        FloatChunkEquals.equalNext(chunk.asFloatChunk(), destination);
    }

    @Override
    public void andEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.andEqual(lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    @Override
    public void andEqualNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        FloatChunkEquals.andEqualNext(chunk.asFloatChunk(), destination);
    }

    @Override
    public void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.equalPermuted(lhsPositions, rhsPositions, lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    @Override
    public void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.equalLhsPermuted(lhsPositions, lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    @Override
    public void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.andEqualPermuted(lhsPositions, rhsPositions, lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    @Override
    public void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.andEqualLhsPermuted(lhsPositions, lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    @Override
    public void notEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.notEqual(lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    public static void notEqual(Chunk<? extends Any> lhs, float rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.notEqual(lhs.asFloatChunk(), rhs, destination);
    }

    @Override
    public void andNotEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        FloatChunkEquals.andNotEqual(lhs.asFloatChunk(), rhs.asFloatChunk(), destination);
    }

    @Override
    public void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        FloatChunkEquals.equalPairs(chunkPositionsToCheckForEquality, valuesChunk.asFloatChunk(), destinations);
    }

    @Override
    public void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        FloatChunkEquals.andEqualPairs(chunkPositionsToCheckForEquality, valuesChunk.asFloatChunk(), destinations);
    }

    private static boolean eq(float lhs, float rhs) {
        return Float.isNaN(lhs) && Float.isNaN(rhs) || lhs == rhs;
    }

    private static boolean neq(float lhs, float rhs) {
        return !FloatChunkEquals.eq(lhs, rhs);
    }
}

