/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class FloatChunkHasher
implements ChunkHasher {
    public static FloatChunkHasher INSTANCE = new FloatChunkHasher();

    private static void hashInitial(FloatChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            float value = values.get(ii);
            destination.set(ii, FloatChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(FloatChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, FloatChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(float value) {
        return ChunkHasher.scrambleHash(Float.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, float newValue) {
        return existing * 31 + FloatChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return FloatChunkHasher.hashInitialSingle(TypeUtils.unbox((Float)((Float)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return FloatChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Float)((Float)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        FloatChunkHasher.hashInitial(values.asFloatChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        FloatChunkHasher.hashSecondary(values.asFloatChunk(), destination);
    }
}

