/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class IntChunkHasher
implements ChunkHasher {
    public static IntChunkHasher INSTANCE = new IntChunkHasher();

    private static void hashInitial(IntChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            int value = values.get(ii);
            destination.set(ii, IntChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(IntChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, IntChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(int value) {
        return ChunkHasher.scrambleHash(Integer.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, int newValue) {
        return existing * 31 + IntChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return IntChunkHasher.hashInitialSingle(TypeUtils.unbox((Integer)((Integer)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return IntChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Integer)((Integer)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        IntChunkHasher.hashInitial(values.asIntChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        IntChunkHasher.hashSecondary(values.asIntChunk(), destination);
    }
}

