/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ToLongFunctor;

public class IntToLongCast<T extends Any>
implements ToLongFunctor<T> {
    private final WritableLongChunk<T> result;

    IntToLongCast(int size) {
        this.result = WritableLongChunk.makeWritableChunk(size);
    }

    @Override
    public LongChunk<T> apply(Chunk<T> input) {
        return this.cast(input.asIntChunk());
    }

    private LongChunk<T> cast(IntChunk<T> input) {
        IntToLongCast.castInto(input, this.result);
        return this.result;
    }

    public static <T2 extends Any> void castInto(IntChunk<? extends T2> input, WritableLongChunk<? super T2> result) {
        for (int ii = 0; ii < input.size(); ++ii) {
            result.set(ii, input.get(ii));
        }
        result.setSize(input.size());
    }

    @Override
    public void close() {
        this.result.close();
    }
}

