/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ToLongFunctor;

public class IntToLongCastWithOffset<T extends Any>
implements ToLongFunctor<T> {
    private final WritableLongChunk<T> result;
    private final long offset;

    IntToLongCastWithOffset(int size, long offset) {
        this.result = WritableLongChunk.makeWritableChunk(size);
        this.offset = offset;
    }

    @Override
    public LongChunk<T> apply(Chunk<T> input) {
        return this.castWithOffset(input.asIntChunk());
    }

    private LongChunk<T> castWithOffset(IntChunk<T> input) {
        IntToLongCastWithOffset.castInto(input, this.result, this.offset);
        return this.result;
    }

    public static <T2 extends Any> void castInto(IntChunk<T2> input, WritableLongChunk<T2> result, long offset) {
        for (int ii = 0; ii < input.size(); ++ii) {
            result.set(ii, (long)input.get(ii) + offset);
        }
        result.setSize(input.size());
    }

    @Override
    public void close() {
        this.result.close();
    }
}

