/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class LongChunkHasher
implements ChunkHasher {
    public static LongChunkHasher INSTANCE = new LongChunkHasher();

    private static void hashInitial(LongChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            long value = values.get(ii);
            destination.set(ii, LongChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(LongChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, LongChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(long value) {
        return ChunkHasher.scrambleHash(Long.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, long newValue) {
        return existing * 31 + LongChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return LongChunkHasher.hashInitialSingle(TypeUtils.unbox((Long)((Long)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return LongChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Long)((Long)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        LongChunkHasher.hashInitial(values.asLongChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        LongChunkHasher.hashSecondary(values.asLongChunk(), destination);
    }
}

