/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import java.util.Objects;

public class ObjectChunkHasher
implements ChunkHasher {
    public static ObjectChunkHasher INSTANCE = new ObjectChunkHasher();

    private static void hashInitial(ObjectChunk<Object, Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            Object value = values.get(ii);
            destination.set(ii, ObjectChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(ObjectChunk<Object, Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, ObjectChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(Object value) {
        return ChunkHasher.scrambleHash(Objects.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, Object newValue) {
        return existing * 31 + ObjectChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return ObjectChunkHasher.hashInitialSingle(value);
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return ObjectChunkHasher.hashUpdateSingle(existing, value);
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        ObjectChunkHasher.hashInitial(values.asObjectChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        ObjectChunkHasher.hashSecondary(values.asObjectChunk(), destination);
    }
}

