/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.util.hashing.ChunkEquals;

public class ObjectChunkIdentityEquals
implements ChunkEquals {
    public static ObjectChunkIdentityEquals INSTANCE = new ObjectChunkIdentityEquals();

    public static boolean equalReduce(ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int ii = 0; ii < lhs.size(); ++ii) {
            if (ObjectChunkIdentityEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return false;
        }
        return true;
    }

    public static int firstDifference(ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs) {
        int ii = 0;
        for (ii = 0; ii < lhs.size() && ii < rhs.size(); ++ii) {
            if (ObjectChunkIdentityEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return ii;
        }
        return ii;
    }

    private static void equal(ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ObjectChunkIdentityEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void equalNext(ObjectChunk<Object, ? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, ObjectChunkIdentityEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equal(ObjectChunk<Object, ? extends Any> lhs, Object rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ObjectChunkIdentityEquals.eq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ObjectChunkIdentityEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(ObjectChunk<Object, ? extends Any> lhs, Object rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ObjectChunkIdentityEquals.neq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqual(ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && ObjectChunkIdentityEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andNotEqual(ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && ObjectChunkIdentityEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqualNext(ObjectChunk<Object, ? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, destination.get(ii) && ObjectChunkIdentityEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, ObjectChunk<Object, ? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = ObjectChunkIdentityEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(pairCount);
    }

    private static void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, ObjectChunk<Object, ? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            if (!destinations.get(ii)) continue;
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = ObjectChunkIdentityEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
    }

    private static void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = ObjectChunkIdentityEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = ObjectChunkIdentityEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = ObjectChunkIdentityEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, ObjectChunk<Object, ? extends Any> lhs, ObjectChunk<Object, ? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = ObjectChunkIdentityEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    @Override
    public boolean equalReduce(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs) {
        return ObjectChunkIdentityEquals.equalReduce(lhs.asObjectChunk(), rhs.asObjectChunk());
    }

    @Override
    public void equal(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.equal(lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    public static void equal(Chunk<? extends Any> lhs, Object rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.equal(lhs.asObjectChunk(), rhs, destination);
    }

    @Override
    public void equalNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.equalNext(chunk.asObjectChunk(), destination);
    }

    @Override
    public void andEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.andEqual(lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    @Override
    public void andEqualNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.andEqualNext(chunk.asObjectChunk(), destination);
    }

    @Override
    public void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.equalPermuted(lhsPositions, rhsPositions, lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    @Override
    public void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.equalLhsPermuted(lhsPositions, lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    @Override
    public void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.andEqualPermuted(lhsPositions, rhsPositions, lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    @Override
    public void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.andEqualLhsPermuted(lhsPositions, lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    @Override
    public void notEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.notEqual(lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    public static void notEqual(Chunk<? extends Any> lhs, Object rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.notEqual(lhs.asObjectChunk(), rhs, destination);
    }

    @Override
    public void andNotEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ObjectChunkIdentityEquals.andNotEqual(lhs.asObjectChunk(), rhs.asObjectChunk(), destination);
    }

    @Override
    public void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        ObjectChunkIdentityEquals.equalPairs(chunkPositionsToCheckForEquality, valuesChunk.asObjectChunk(), destinations);
    }

    @Override
    public void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        ObjectChunkIdentityEquals.andEqualPairs(chunkPositionsToCheckForEquality, valuesChunk.asObjectChunk(), destinations);
    }

    private static boolean eq(Object lhs, Object rhs) {
        return lhs == rhs;
    }

    private static boolean neq(Object lhs, Object rhs) {
        return !ObjectChunkIdentityEquals.eq(lhs, rhs);
    }
}

