/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.ChunkPositions;
import io.deephaven.chunk.util.hashing.ChunkEquals;

public class ShortChunkEquals
implements ChunkEquals {
    public static ShortChunkEquals INSTANCE = new ShortChunkEquals();

    public static boolean equalReduce(ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int ii = 0; ii < lhs.size(); ++ii) {
            if (ShortChunkEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return false;
        }
        return true;
    }

    public static int firstDifference(ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs) {
        int ii = 0;
        for (ii = 0; ii < lhs.size() && ii < rhs.size(); ++ii) {
            if (ShortChunkEquals.eq(lhs.get(ii), rhs.get(ii))) continue;
            return ii;
        }
        return ii;
    }

    private static void equal(ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ShortChunkEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void equalNext(ShortChunk<? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, ShortChunkEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equal(ShortChunk<? extends Any> lhs, short rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ShortChunkEquals.eq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ShortChunkEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    public static void notEqual(ShortChunk<? extends Any> lhs, short rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, ShortChunkEquals.neq(lhs.get(ii), rhs));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqual(ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && ShortChunkEquals.eq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andNotEqual(ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destination) {
        for (int ii = 0; ii < lhs.size(); ++ii) {
            destination.set(ii, destination.get(ii) && ShortChunkEquals.neq(lhs.get(ii), rhs.get(ii)));
        }
        destination.setSize(lhs.size());
    }

    private static void andEqualNext(ShortChunk<? extends Any> chunk, WritableBooleanChunk destination) {
        for (int ii = 0; ii < chunk.size() - 1; ++ii) {
            destination.set(ii, destination.get(ii) && ShortChunkEquals.eq(chunk.get(ii), chunk.get(ii + 1)));
        }
        destination.setSize(chunk.size() - 1);
    }

    private static void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, ShortChunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = ShortChunkEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(pairCount);
    }

    private static void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, ShortChunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        int pairCount = chunkPositionsToCheckForEquality.size() / 2;
        for (int ii = 0; ii < pairCount; ++ii) {
            if (!destinations.get(ii)) continue;
            int firstPosition = chunkPositionsToCheckForEquality.get(ii * 2);
            int secondPosition = chunkPositionsToCheckForEquality.get(ii * 2 + 1);
            boolean equals = ShortChunkEquals.eq(valuesChunk.get(firstPosition), valuesChunk.get(secondPosition));
            destinations.set(ii, equals);
        }
    }

    private static void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = ShortChunkEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            int rhsPosition = rhsPositions.get(ii);
            boolean equals = ShortChunkEquals.eq(lhs.get(lhsPosition), rhs.get(rhsPosition));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = ShortChunkEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    private static void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, ShortChunk<? extends Any> lhs, ShortChunk<? extends Any> rhs, WritableBooleanChunk destinations) {
        for (int ii = 0; ii < lhsPositions.size(); ++ii) {
            if (!destinations.get(ii)) continue;
            int lhsPosition = lhsPositions.get(ii);
            boolean equals = ShortChunkEquals.eq(lhs.get(lhsPosition), rhs.get(ii));
            destinations.set(ii, equals);
        }
        destinations.setSize(lhsPositions.size());
    }

    @Override
    public boolean equalReduce(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs) {
        return ShortChunkEquals.equalReduce(lhs.asShortChunk(), rhs.asShortChunk());
    }

    @Override
    public void equal(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.equal(lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    public static void equal(Chunk<? extends Any> lhs, short rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.equal(lhs.asShortChunk(), rhs, destination);
    }

    @Override
    public void equalNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        ShortChunkEquals.equalNext(chunk.asShortChunk(), destination);
    }

    @Override
    public void andEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.andEqual(lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    @Override
    public void andEqualNext(Chunk<? extends Any> chunk, WritableBooleanChunk destination) {
        ShortChunkEquals.andEqualNext(chunk.asShortChunk(), destination);
    }

    @Override
    public void equalPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.equalPermuted(lhsPositions, rhsPositions, lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    @Override
    public void equalLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.equalLhsPermuted(lhsPositions, lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    @Override
    public void andEqualPermuted(IntChunk<ChunkPositions> lhsPositions, IntChunk<ChunkPositions> rhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.andEqualPermuted(lhsPositions, rhsPositions, lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    @Override
    public void andEqualLhsPermuted(IntChunk<ChunkPositions> lhsPositions, Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.andEqualLhsPermuted(lhsPositions, lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    @Override
    public void notEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.notEqual(lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    public static void notEqual(Chunk<? extends Any> lhs, short rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.notEqual(lhs.asShortChunk(), rhs, destination);
    }

    @Override
    public void andNotEqual(Chunk<? extends Any> lhs, Chunk<? extends Any> rhs, WritableBooleanChunk destination) {
        ShortChunkEquals.andNotEqual(lhs.asShortChunk(), rhs.asShortChunk(), destination);
    }

    @Override
    public void equalPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        ShortChunkEquals.equalPairs(chunkPositionsToCheckForEquality, valuesChunk.asShortChunk(), destinations);
    }

    @Override
    public void andEqualPairs(IntChunk<ChunkPositions> chunkPositionsToCheckForEquality, Chunk<? extends Any> valuesChunk, WritableBooleanChunk destinations) {
        ShortChunkEquals.andEqualPairs(chunkPositionsToCheckForEquality, valuesChunk.asShortChunk(), destinations);
    }

    private static boolean eq(short lhs, short rhs) {
        return lhs == rhs;
    }

    private static boolean neq(short lhs, short rhs) {
        return !ShortChunkEquals.eq(lhs, rhs);
    }
}

