/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.HashCodes;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.chunk.util.hashing.ChunkHasher;
import io.deephaven.util.type.TypeUtils;

public class ShortChunkHasher
implements ChunkHasher {
    public static ShortChunkHasher INSTANCE = new ShortChunkHasher();

    private static void hashInitial(ShortChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            short value = values.get(ii);
            destination.set(ii, ShortChunkHasher.hashInitialSingle(value));
        }
        destination.setSize(values.size());
    }

    private static void hashSecondary(ShortChunk<Values> values, WritableIntChunk<HashCodes> destination) {
        for (int ii = 0; ii < values.size(); ++ii) {
            destination.set(ii, ShortChunkHasher.hashUpdateSingle(destination.get(ii), values.get(ii)));
        }
        destination.setSize(values.size());
    }

    public static int hashInitialSingle(short value) {
        return ChunkHasher.scrambleHash(Short.hashCode(value));
    }

    public static int hashUpdateSingle(int existing, short newValue) {
        return existing * 31 + ShortChunkHasher.hashInitialSingle(newValue);
    }

    @Override
    public int hashInitial(Object value) {
        return ShortChunkHasher.hashInitialSingle(TypeUtils.unbox((Short)((Short)value)));
    }

    @Override
    public int hashUpdate(int existing, Object value) {
        return ShortChunkHasher.hashUpdateSingle(existing, TypeUtils.unbox((Short)((Short)value)));
    }

    @Override
    public void hashInitial(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        ShortChunkHasher.hashInitial(values.asShortChunk(), destination);
    }

    @Override
    public void hashUpdate(Chunk<Values> values, WritableIntChunk<HashCodes> destination) {
        ShortChunkHasher.hashSecondary(values.asShortChunk(), destination);
    }
}

