/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ByteToIntegerCast;
import io.deephaven.chunk.util.hashing.ByteToIntegerCastWithOffset;
import io.deephaven.chunk.util.hashing.CharToIntegerCast;
import io.deephaven.chunk.util.hashing.CharToIntegerCastWithOffset;
import io.deephaven.chunk.util.hashing.IntToIntegerCastWithOffset;
import io.deephaven.chunk.util.hashing.LongToIntegerCast;
import io.deephaven.chunk.util.hashing.LongToIntegerCastWithOffset;
import io.deephaven.chunk.util.hashing.ShortToIntegerCast;
import io.deephaven.chunk.util.hashing.ShortToIntegerCastWithOffset;
import io.deephaven.chunk.util.hashing.ToIntFunctor;

public interface ToIntegerCast<T extends Any>
extends ToIntFunctor<T> {
    @Override
    public IntChunk<? extends T> apply(Chunk<? extends T> var1);

    public static <T extends Any> ToIntFunctor<T> makeToIntegerCast(ChunkType type, int size, int offset) {
        switch (type) {
            case Byte: {
                if (offset == 0) {
                    return new ByteToIntegerCast(size);
                }
                return new ByteToIntegerCastWithOffset(size, offset);
            }
            case Char: {
                if (offset == 0) {
                    return new CharToIntegerCast(size);
                }
                return new CharToIntegerCastWithOffset(size, offset);
            }
            case Short: {
                if (offset == 0) {
                    return new ShortToIntegerCast(size);
                }
                return new ShortToIntegerCastWithOffset(size, offset);
            }
            case Int: {
                if (offset == 0) {
                    return ToIntFunctor.makeIdentity();
                }
                return new IntToIntegerCastWithOffset(size, offset);
            }
            case Long: {
                if (offset == 0) {
                    return new LongToIntegerCast(size);
                }
                return new LongToIntegerCastWithOffset(size, offset);
            }
        }
        throw new UnsupportedOperationException();
    }
}

