/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.hashing;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.hashing.ByteToLongCast;
import io.deephaven.chunk.util.hashing.ByteToLongCastWithOffset;
import io.deephaven.chunk.util.hashing.CharToLongCast;
import io.deephaven.chunk.util.hashing.CharToLongCastWithOffset;
import io.deephaven.chunk.util.hashing.IntToLongCast;
import io.deephaven.chunk.util.hashing.IntToLongCastWithOffset;
import io.deephaven.chunk.util.hashing.LongToLongCastWithOffset;
import io.deephaven.chunk.util.hashing.ShortToLongCast;
import io.deephaven.chunk.util.hashing.ShortToLongCastWithOffset;
import io.deephaven.chunk.util.hashing.ToLongFunctor;

public interface ToLongCast<T extends Any>
extends ToLongFunctor<T> {
    @Override
    public LongChunk<T> apply(Chunk<T> var1);

    public static <T extends Any> ToLongFunctor<T> makeToLongCast(ChunkType type, int size, long offset) {
        switch (type) {
            case Byte: {
                if (offset == 0L) {
                    return new ByteToLongCast(size);
                }
                return new ByteToLongCastWithOffset(size, offset);
            }
            case Char: {
                if (offset == 0L) {
                    return new CharToLongCast(size);
                }
                return new CharToLongCastWithOffset(size, offset);
            }
            case Short: {
                if (offset == 0L) {
                    return new ShortToLongCast(size);
                }
                return new ShortToLongCastWithOffset(size, offset);
            }
            case Int: {
                if (offset == 0L) {
                    return new IntToLongCast(size);
                }
                return new IntToLongCastWithOffset(size, offset);
            }
            case Long: {
                if (offset == 0L) {
                    return ToLongFunctor.makeIdentity();
                }
                return new LongToLongCastWithOffset(size, offset);
            }
        }
        throw new UnsupportedOperationException();
    }
}

