/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableBooleanChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableBooleanChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.BooleanChunkPool;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class BooleanChunkSoftPool
implements BooleanChunkPool {
    private final WritableBooleanChunk<Any> EMPTY = WritableBooleanChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_BOOLEAN_ARRAY);
    private final SegmentedSoftPool<WritableBooleanChunk>[] writableBooleanChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableBooleanChunk> resettableBooleanChunks;
    private final SegmentedSoftPool<ResettableWritableBooleanChunk> resettableWritableBooleanChunks;

    BooleanChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableBooleanChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableBooleanChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableBooleanChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableBooleanChunk::makeResettableChunkForPool), ResettableBooleanChunk::clear);
        this.resettableWritableBooleanChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableBooleanChunk::makeResettableChunkForPool), ResettableWritableBooleanChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return BooleanChunkSoftPool.this.takeWritableBooleanChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                BooleanChunkSoftPool.this.giveWritableBooleanChunk(writableChunk.asWritableBooleanChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return BooleanChunkSoftPool.this.takeResettableBooleanChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                BooleanChunkSoftPool.this.giveResettableBooleanChunk((ResettableBooleanChunk)resettableChunk.asResettableBooleanChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return BooleanChunkSoftPool.this.takeResettableWritableBooleanChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                BooleanChunkSoftPool.this.giveResettableWritableBooleanChunk((ResettableWritableBooleanChunk)resettableWritableChunk.asResettableWritableBooleanChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableBooleanChunk<ATTR> takeWritableBooleanChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableBooleanChunk result = (WritableBooleanChunk)this.writableBooleanChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableBooleanChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableBooleanChunk(@NotNull WritableBooleanChunk<?> writableBooleanChunk) {
        if (writableBooleanChunk == this.EMPTY || writableBooleanChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableBooleanChunk);
        int capacity = writableBooleanChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableBooleanChunks[poolIndexForGive].give(writableBooleanChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableBooleanChunk<ATTR> takeResettableBooleanChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableBooleanChunk)this.resettableBooleanChunks.take());
    }

    public void giveResettableBooleanChunk(@NotNull ResettableBooleanChunk resettableBooleanChunk) {
        this.resettableBooleanChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableBooleanChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableBooleanChunk<ATTR> takeResettableWritableBooleanChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableBooleanChunk)this.resettableWritableBooleanChunks.take());
    }

    public void giveResettableWritableBooleanChunk(@NotNull ResettableWritableBooleanChunk resettableWritableBooleanChunk) {
        this.resettableWritableBooleanChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableBooleanChunk));
    }
}

