/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableByteChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableByteChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ByteChunkPool;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class ByteChunkSoftPool
implements ByteChunkPool {
    private final WritableByteChunk<Any> EMPTY = WritableByteChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_BYTE_ARRAY);
    private final SegmentedSoftPool<WritableByteChunk>[] writableByteChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableByteChunk> resettableByteChunks;
    private final SegmentedSoftPool<ResettableWritableByteChunk> resettableWritableByteChunks;

    ByteChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableByteChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableByteChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableByteChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableByteChunk::makeResettableChunkForPool), ResettableByteChunk::clear);
        this.resettableWritableByteChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableByteChunk::makeResettableChunkForPool), ResettableWritableByteChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return ByteChunkSoftPool.this.takeWritableByteChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                ByteChunkSoftPool.this.giveWritableByteChunk(writableChunk.asWritableByteChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return ByteChunkSoftPool.this.takeResettableByteChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                ByteChunkSoftPool.this.giveResettableByteChunk((ResettableByteChunk)resettableChunk.asResettableByteChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return ByteChunkSoftPool.this.takeResettableWritableByteChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                ByteChunkSoftPool.this.giveResettableWritableByteChunk((ResettableWritableByteChunk)resettableWritableChunk.asResettableWritableByteChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableByteChunk<ATTR> takeWritableByteChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableByteChunk result = (WritableByteChunk)this.writableByteChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableByteChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableByteChunk(@NotNull WritableByteChunk<?> writableByteChunk) {
        if (writableByteChunk == this.EMPTY || writableByteChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableByteChunk);
        int capacity = writableByteChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableByteChunks[poolIndexForGive].give(writableByteChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableByteChunk<ATTR> takeResettableByteChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableByteChunk)this.resettableByteChunks.take());
    }

    public void giveResettableByteChunk(@NotNull ResettableByteChunk resettableByteChunk) {
        this.resettableByteChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableByteChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableByteChunk<ATTR> takeResettableWritableByteChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableByteChunk)this.resettableWritableByteChunks.take());
    }

    public void giveResettableWritableByteChunk(@NotNull ResettableWritableByteChunk resettableWritableByteChunk) {
        this.resettableWritableByteChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableByteChunk));
    }
}

