/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableCharChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableCharChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.CharChunkPool;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class CharChunkSoftPool
implements CharChunkPool {
    private final WritableCharChunk<Any> EMPTY = WritableCharChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_CHAR_ARRAY);
    private final SegmentedSoftPool<WritableCharChunk>[] writableCharChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableCharChunk> resettableCharChunks;
    private final SegmentedSoftPool<ResettableWritableCharChunk> resettableWritableCharChunks;

    CharChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableCharChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableCharChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableCharChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableCharChunk::makeResettableChunkForPool), ResettableCharChunk::clear);
        this.resettableWritableCharChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableCharChunk::makeResettableChunkForPool), ResettableWritableCharChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return CharChunkSoftPool.this.takeWritableCharChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                CharChunkSoftPool.this.giveWritableCharChunk(writableChunk.asWritableCharChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return CharChunkSoftPool.this.takeResettableCharChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                CharChunkSoftPool.this.giveResettableCharChunk((ResettableCharChunk)resettableChunk.asResettableCharChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return CharChunkSoftPool.this.takeResettableWritableCharChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                CharChunkSoftPool.this.giveResettableWritableCharChunk((ResettableWritableCharChunk)resettableWritableChunk.asResettableWritableCharChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableCharChunk<ATTR> takeWritableCharChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableCharChunk result = (WritableCharChunk)this.writableCharChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableCharChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableCharChunk(@NotNull WritableCharChunk<?> writableCharChunk) {
        if (writableCharChunk == this.EMPTY || writableCharChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableCharChunk);
        int capacity = writableCharChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableCharChunks[poolIndexForGive].give(writableCharChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableCharChunk<ATTR> takeResettableCharChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableCharChunk)this.resettableCharChunks.take());
    }

    public void giveResettableCharChunk(@NotNull ResettableCharChunk resettableCharChunk) {
        this.resettableCharChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableCharChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableCharChunk<ATTR> takeResettableWritableCharChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableCharChunk)this.resettableWritableCharChunks.take());
    }

    public void giveResettableWritableCharChunk(@NotNull ResettableWritableCharChunk resettableWritableCharChunk) {
        this.resettableWritableCharChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableCharChunk));
    }
}

