/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.base.MathUtil;
import io.deephaven.base.verify.Require;
import io.deephaven.util.annotations.VisibleForTesting;

public final class ChunkPoolConstants {
    static final int SMALLEST_POOLED_CHUNK_LOG2_CAPACITY = 5;
    public static final int SMALLEST_POOLED_CHUNK_CAPACITY = 32;
    @VisibleForTesting
    static final int LARGEST_POOLED_CHUNK_LOG2_CAPACITY = 16;
    public static final int LARGEST_POOLED_CHUNK_CAPACITY = 65536;
    static final int NUM_POOLED_CHUNK_CAPACITIES = 12;
    public static final boolean POOL_RESETTABLE_CHUNKS = false;
    public static final boolean POOL_WRITABLE_CHUNKS = true;
    static final int SUB_POOL_SEGMENT_CAPACITY = 10;

    static int checkCapacityBounds(int chunkCapacity) {
        return Require.geqZero((int)chunkCapacity, (String)"chunkCapacity");
    }

    static int getPoolIndexForTake(int minimumChunkCapacity) {
        if (minimumChunkCapacity == 0) {
            return 0;
        }
        int roundedChunkLog2Capacity = Math.max(MathUtil.ceilLog2((int)minimumChunkCapacity), 5);
        if (roundedChunkLog2Capacity > 16) {
            return -1;
        }
        return ChunkPoolConstants.getChunkLog2CapacityOffset(roundedChunkLog2Capacity);
    }

    static int getPoolIndexForGive(int actualChunkCapacity) {
        if (Integer.bitCount(actualChunkCapacity) != 1) {
            return -1;
        }
        int chunkLog2Capacity = MathUtil.ceilLog2((int)actualChunkCapacity);
        if (chunkLog2Capacity < 5 || chunkLog2Capacity > 16) {
            return -1;
        }
        return ChunkPoolConstants.getChunkLog2CapacityOffset(chunkLog2Capacity);
    }

    private static int getChunkLog2CapacityOffset(int chunkLog2Capacity) {
        return chunkLog2Capacity - 5;
    }

    private ChunkPoolConstants() {
    }
}

