/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.util.pools.PoolableChunk;
import io.deephaven.util.datastructures.ReleaseTracker;
import org.jetbrains.annotations.NotNull;

public final class ChunkPoolReleaseTracking {
    private static volatile ReleaseTracker<PoolableChunk> releaseTracker;

    public static void enableStrict() {
        ChunkPoolReleaseTracking.enable(ReleaseTracker.strictReleaseTrackerFactory, true);
    }

    public static void enable() {
        ChunkPoolReleaseTracking.enable(ReleaseTracker.weakReleaseTrackerFactory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enable(ReleaseTracker.Factory factory, boolean preCheck) {
        if (releaseTracker == null) {
            Class<ChunkPoolReleaseTracking> clazz = ChunkPoolReleaseTracking.class;
            synchronized (ChunkPoolReleaseTracking.class) {
                if (releaseTracker == null) {
                    releaseTracker = factory.makeReleaseTracker();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        if (!factory.isMyType(releaseTracker.getClass())) {
            throw new IllegalStateException("Can't enable to a different tracking type (strict versus not)");
        }
        if (preCheck) {
            try {
                releaseTracker.check();
            }
            catch (ReleaseTracker.LeakedException | ReleaseTracker.MissedReleaseException checkException) {
                throw new IllegalStateException("Release tracker had errors on enable", checkException);
            }
        }
    }

    public static void disable() {
        releaseTracker = null;
    }

    static <CHUNK_TYPE extends PoolableChunk> CHUNK_TYPE onTake(@NotNull CHUNK_TYPE chunk) {
        ReleaseTracker<PoolableChunk> localReleaseTracker = releaseTracker;
        if (localReleaseTracker != null) {
            localReleaseTracker.reportAcquire(chunk);
        }
        return chunk;
    }

    static <CHUNK_TYPE extends PoolableChunk> CHUNK_TYPE onGive(@NotNull CHUNK_TYPE chunk) {
        ReleaseTracker<PoolableChunk> localReleaseTracker = releaseTracker;
        if (localReleaseTracker != null) {
            localReleaseTracker.reportRelease(chunk);
        }
        return chunk;
    }

    public static void check() {
        ReleaseTracker<PoolableChunk> localReleaseTracker = releaseTracker;
        if (localReleaseTracker != null) {
            localReleaseTracker.check();
        }
    }

    public static void checkAndDisable() {
        try {
            ChunkPoolReleaseTracking.check();
        }
        finally {
            ChunkPoolReleaseTracking.disable();
        }
    }

    private ChunkPoolReleaseTracking() {
    }
}

