/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableDoubleChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableDoubleChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.chunk.util.pools.DoubleChunkPool;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class DoubleChunkSoftPool
implements DoubleChunkPool {
    private final WritableDoubleChunk<Any> EMPTY = WritableDoubleChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_DOUBLE_ARRAY);
    private final SegmentedSoftPool<WritableDoubleChunk>[] writableDoubleChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableDoubleChunk> resettableDoubleChunks;
    private final SegmentedSoftPool<ResettableWritableDoubleChunk> resettableWritableDoubleChunks;

    DoubleChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableDoubleChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableDoubleChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableDoubleChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableDoubleChunk::makeResettableChunkForPool), ResettableDoubleChunk::clear);
        this.resettableWritableDoubleChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableDoubleChunk::makeResettableChunkForPool), ResettableWritableDoubleChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return DoubleChunkSoftPool.this.takeWritableDoubleChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                DoubleChunkSoftPool.this.giveWritableDoubleChunk(writableChunk.asWritableDoubleChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return DoubleChunkSoftPool.this.takeResettableDoubleChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                DoubleChunkSoftPool.this.giveResettableDoubleChunk((ResettableDoubleChunk)resettableChunk.asResettableDoubleChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return DoubleChunkSoftPool.this.takeResettableWritableDoubleChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                DoubleChunkSoftPool.this.giveResettableWritableDoubleChunk((ResettableWritableDoubleChunk)resettableWritableChunk.asResettableWritableDoubleChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableDoubleChunk<ATTR> takeWritableDoubleChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableDoubleChunk result = (WritableDoubleChunk)this.writableDoubleChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableDoubleChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableDoubleChunk(@NotNull WritableDoubleChunk<?> writableDoubleChunk) {
        if (writableDoubleChunk == this.EMPTY || writableDoubleChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableDoubleChunk);
        int capacity = writableDoubleChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableDoubleChunks[poolIndexForGive].give(writableDoubleChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableDoubleChunk<ATTR> takeResettableDoubleChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableDoubleChunk)this.resettableDoubleChunks.take());
    }

    public void giveResettableDoubleChunk(@NotNull ResettableDoubleChunk resettableDoubleChunk) {
        this.resettableDoubleChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableDoubleChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableDoubleChunk<ATTR> takeResettableWritableDoubleChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableDoubleChunk)this.resettableWritableDoubleChunks.take());
    }

    public void giveResettableWritableDoubleChunk(@NotNull ResettableWritableDoubleChunk resettableWritableDoubleChunk) {
        this.resettableWritableDoubleChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableDoubleChunk));
    }
}

