/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableFloatChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableFloatChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.chunk.util.pools.FloatChunkPool;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class FloatChunkSoftPool
implements FloatChunkPool {
    private final WritableFloatChunk<Any> EMPTY = WritableFloatChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_FLOAT_ARRAY);
    private final SegmentedSoftPool<WritableFloatChunk>[] writableFloatChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableFloatChunk> resettableFloatChunks;
    private final SegmentedSoftPool<ResettableWritableFloatChunk> resettableWritableFloatChunks;

    FloatChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableFloatChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableFloatChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableFloatChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableFloatChunk::makeResettableChunkForPool), ResettableFloatChunk::clear);
        this.resettableWritableFloatChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableFloatChunk::makeResettableChunkForPool), ResettableWritableFloatChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return FloatChunkSoftPool.this.takeWritableFloatChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                FloatChunkSoftPool.this.giveWritableFloatChunk(writableChunk.asWritableFloatChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return FloatChunkSoftPool.this.takeResettableFloatChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                FloatChunkSoftPool.this.giveResettableFloatChunk((ResettableFloatChunk)resettableChunk.asResettableFloatChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return FloatChunkSoftPool.this.takeResettableWritableFloatChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                FloatChunkSoftPool.this.giveResettableWritableFloatChunk((ResettableWritableFloatChunk)resettableWritableChunk.asResettableWritableFloatChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableFloatChunk<ATTR> takeWritableFloatChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableFloatChunk result = (WritableFloatChunk)this.writableFloatChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableFloatChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableFloatChunk(@NotNull WritableFloatChunk<?> writableFloatChunk) {
        if (writableFloatChunk == this.EMPTY || writableFloatChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableFloatChunk);
        int capacity = writableFloatChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableFloatChunks[poolIndexForGive].give(writableFloatChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableFloatChunk<ATTR> takeResettableFloatChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableFloatChunk)this.resettableFloatChunks.take());
    }

    public void giveResettableFloatChunk(@NotNull ResettableFloatChunk resettableFloatChunk) {
        this.resettableFloatChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableFloatChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableFloatChunk<ATTR> takeResettableWritableFloatChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableFloatChunk)this.resettableWritableFloatChunks.take());
    }

    public void giveResettableWritableFloatChunk(@NotNull ResettableWritableFloatChunk resettableWritableFloatChunk) {
        this.resettableWritableFloatChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableFloatChunk));
    }
}

