/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableIntChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableIntChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.chunk.util.pools.IntChunkPool;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class IntChunkSoftPool
implements IntChunkPool {
    private final WritableIntChunk<Any> EMPTY = WritableIntChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_INT_ARRAY);
    private final SegmentedSoftPool<WritableIntChunk>[] writableIntChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableIntChunk> resettableIntChunks;
    private final SegmentedSoftPool<ResettableWritableIntChunk> resettableWritableIntChunks;

    IntChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableIntChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableIntChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableIntChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableIntChunk::makeResettableChunkForPool), ResettableIntChunk::clear);
        this.resettableWritableIntChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableIntChunk::makeResettableChunkForPool), ResettableWritableIntChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return IntChunkSoftPool.this.takeWritableIntChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                IntChunkSoftPool.this.giveWritableIntChunk(writableChunk.asWritableIntChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return IntChunkSoftPool.this.takeResettableIntChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                IntChunkSoftPool.this.giveResettableIntChunk((ResettableIntChunk)resettableChunk.asResettableIntChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return IntChunkSoftPool.this.takeResettableWritableIntChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                IntChunkSoftPool.this.giveResettableWritableIntChunk((ResettableWritableIntChunk)resettableWritableChunk.asResettableWritableIntChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableIntChunk<ATTR> takeWritableIntChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableIntChunk result = (WritableIntChunk)this.writableIntChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableIntChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableIntChunk(@NotNull WritableIntChunk<?> writableIntChunk) {
        if (writableIntChunk == this.EMPTY || writableIntChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableIntChunk);
        int capacity = writableIntChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableIntChunks[poolIndexForGive].give(writableIntChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableIntChunk<ATTR> takeResettableIntChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableIntChunk)this.resettableIntChunks.take());
    }

    public void giveResettableIntChunk(@NotNull ResettableIntChunk resettableIntChunk) {
        this.resettableIntChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableIntChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableIntChunk<ATTR> takeResettableWritableIntChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableIntChunk)this.resettableWritableIntChunks.take());
    }

    public void giveResettableWritableIntChunk(@NotNull ResettableWritableIntChunk resettableWritableIntChunk) {
        this.resettableWritableIntChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableIntChunk));
    }
}

