/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableLongChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableLongChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.chunk.util.pools.LongChunkPool;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class LongChunkSoftPool
implements LongChunkPool {
    private final WritableLongChunk<Any> EMPTY = WritableLongChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_LONG_ARRAY);
    private final SegmentedSoftPool<WritableLongChunk>[] writableLongChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableLongChunk> resettableLongChunks;
    private final SegmentedSoftPool<ResettableWritableLongChunk> resettableWritableLongChunks;

    LongChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableLongChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableLongChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableLongChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableLongChunk::makeResettableChunkForPool), ResettableLongChunk::clear);
        this.resettableWritableLongChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableLongChunk::makeResettableChunkForPool), ResettableWritableLongChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return LongChunkSoftPool.this.takeWritableLongChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                LongChunkSoftPool.this.giveWritableLongChunk(writableChunk.asWritableLongChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return LongChunkSoftPool.this.takeResettableLongChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                LongChunkSoftPool.this.giveResettableLongChunk((ResettableLongChunk)resettableChunk.asResettableLongChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return LongChunkSoftPool.this.takeResettableWritableLongChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                LongChunkSoftPool.this.giveResettableWritableLongChunk((ResettableWritableLongChunk)resettableWritableChunk.asResettableWritableLongChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableLongChunk<ATTR> takeWritableLongChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableLongChunk result = (WritableLongChunk)this.writableLongChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableLongChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableLongChunk(@NotNull WritableLongChunk<?> writableLongChunk) {
        if (writableLongChunk == this.EMPTY || writableLongChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableLongChunk);
        int capacity = writableLongChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableLongChunks[poolIndexForGive].give(writableLongChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableLongChunk<ATTR> takeResettableLongChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableLongChunk)this.resettableLongChunks.take());
    }

    public void giveResettableLongChunk(@NotNull ResettableLongChunk resettableLongChunk) {
        this.resettableLongChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableLongChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableLongChunk<ATTR> takeResettableWritableLongChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableLongChunk)this.resettableWritableLongChunks.take());
    }

    public void giveResettableWritableLongChunk(@NotNull ResettableWritableLongChunk resettableWritableLongChunk) {
        this.resettableWritableLongChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableLongChunk));
    }
}

