/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ResettableBooleanChunk;
import io.deephaven.chunk.ResettableByteChunk;
import io.deephaven.chunk.ResettableCharChunk;
import io.deephaven.chunk.ResettableDoubleChunk;
import io.deephaven.chunk.ResettableFloatChunk;
import io.deephaven.chunk.ResettableIntChunk;
import io.deephaven.chunk.ResettableLongChunk;
import io.deephaven.chunk.ResettableObjectChunk;
import io.deephaven.chunk.ResettableShortChunk;
import io.deephaven.chunk.ResettableWritableBooleanChunk;
import io.deephaven.chunk.ResettableWritableByteChunk;
import io.deephaven.chunk.ResettableWritableCharChunk;
import io.deephaven.chunk.ResettableWritableDoubleChunk;
import io.deephaven.chunk.ResettableWritableFloatChunk;
import io.deephaven.chunk.ResettableWritableIntChunk;
import io.deephaven.chunk.ResettableWritableLongChunk;
import io.deephaven.chunk.ResettableWritableObjectChunk;
import io.deephaven.chunk.ResettableWritableShortChunk;
import io.deephaven.chunk.WritableBooleanChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.BooleanChunkPool;
import io.deephaven.chunk.util.pools.BooleanChunkSoftPool;
import io.deephaven.chunk.util.pools.ByteChunkPool;
import io.deephaven.chunk.util.pools.ByteChunkSoftPool;
import io.deephaven.chunk.util.pools.CharChunkPool;
import io.deephaven.chunk.util.pools.CharChunkSoftPool;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.DoubleChunkPool;
import io.deephaven.chunk.util.pools.DoubleChunkSoftPool;
import io.deephaven.chunk.util.pools.FloatChunkPool;
import io.deephaven.chunk.util.pools.FloatChunkSoftPool;
import io.deephaven.chunk.util.pools.IntChunkPool;
import io.deephaven.chunk.util.pools.IntChunkSoftPool;
import io.deephaven.chunk.util.pools.LongChunkPool;
import io.deephaven.chunk.util.pools.LongChunkSoftPool;
import io.deephaven.chunk.util.pools.ObjectChunkPool;
import io.deephaven.chunk.util.pools.ObjectChunkSoftPool;
import io.deephaven.chunk.util.pools.ShortChunkPool;
import io.deephaven.chunk.util.pools.ShortChunkSoftPool;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MultiChunkPool
implements BooleanChunkPool,
ByteChunkPool,
CharChunkPool,
ShortChunkPool,
IntChunkPool,
LongChunkPool,
FloatChunkPool,
DoubleChunkPool,
ObjectChunkPool {
    private static final MultiChunkPool SHARED_POOL = new MultiChunkPool();
    private static final ThreadLocal<MultiChunkPool> POOL_THREAD_LOCAL = ThreadLocal.withInitial(() -> SHARED_POOL);
    private final BooleanChunkPool booleanChunkPool = new BooleanChunkSoftPool();
    private final CharChunkPool charChunkPool = new CharChunkSoftPool();
    private final ByteChunkPool byteChunkPool = new ByteChunkSoftPool();
    private final ShortChunkPool shortChunkPool = new ShortChunkSoftPool();
    private final IntChunkPool intChunkPool = new IntChunkSoftPool();
    private final LongChunkPool longChunkPool = new LongChunkSoftPool();
    private final FloatChunkPool floatChunkPool = new FloatChunkSoftPool();
    private final DoubleChunkPool doubleChunkPool = new DoubleChunkSoftPool();
    private final ObjectChunkPool objectChunkPool = new ObjectChunkSoftPool();
    private final Map<ChunkType, ChunkPool> pools;

    public static void enableDedicatedPoolForThisThread() {
        if (POOL_THREAD_LOCAL.get() == SHARED_POOL) {
            POOL_THREAD_LOCAL.set(new MultiChunkPool());
        }
    }

    public static MultiChunkPool forThisThread() {
        return POOL_THREAD_LOCAL.get();
    }

    private MultiChunkPool() {
        EnumMap<ChunkType, ChunkPool> tempPools = new EnumMap<ChunkType, ChunkPool>(ChunkType.class);
        tempPools.put(ChunkType.Boolean, this.booleanChunkPool.asChunkPool());
        tempPools.put(ChunkType.Char, this.charChunkPool.asChunkPool());
        tempPools.put(ChunkType.Byte, this.byteChunkPool.asChunkPool());
        tempPools.put(ChunkType.Short, this.shortChunkPool.asChunkPool());
        tempPools.put(ChunkType.Int, this.intChunkPool.asChunkPool());
        tempPools.put(ChunkType.Long, this.longChunkPool.asChunkPool());
        tempPools.put(ChunkType.Float, this.floatChunkPool.asChunkPool());
        tempPools.put(ChunkType.Double, this.doubleChunkPool.asChunkPool());
        tempPools.put(ChunkType.Object, this.objectChunkPool.asChunkPool());
        this.pools = Collections.unmodifiableMap(tempPools);
    }

    public ChunkPool getChunkPool(@NotNull ChunkType chunkType) {
        return this.pools.get(chunkType);
    }

    public BooleanChunkPool getBooleanChunkPool() {
        return this.booleanChunkPool;
    }

    public CharChunkPool getCharChunkPool() {
        return this.charChunkPool;
    }

    public ByteChunkPool getByteChunkPool() {
        return this.byteChunkPool;
    }

    public ShortChunkPool getShortChunkPool() {
        return this.shortChunkPool;
    }

    public IntChunkPool getIntChunkPool() {
        return this.intChunkPool;
    }

    public LongChunkPool getLongChunkPool() {
        return this.longChunkPool;
    }

    public FloatChunkPool getFloatChunkPool() {
        return this.floatChunkPool;
    }

    public DoubleChunkPool getDoubleChunkPool() {
        return this.doubleChunkPool;
    }

    public ObjectChunkPool getObjectChunkPool() {
        return this.objectChunkPool;
    }

    @Override
    public ChunkPool asChunkPool() {
        throw new UnsupportedOperationException("MultiChunkPool can't create a ChunkPool, call this on the specific type required");
    }

    @Override
    public <ATTR extends Any> WritableBooleanChunk<ATTR> takeWritableBooleanChunk(int capacity) {
        return this.booleanChunkPool.takeWritableBooleanChunk(capacity);
    }

    @Override
    public void giveWritableBooleanChunk(@NotNull WritableBooleanChunk<?> writableBooleanChunk) {
        this.booleanChunkPool.giveWritableBooleanChunk(writableBooleanChunk);
    }

    @Override
    public <ATTR extends Any> ResettableBooleanChunk<ATTR> takeResettableBooleanChunk() {
        return this.booleanChunkPool.takeResettableBooleanChunk();
    }

    @Override
    public void giveResettableBooleanChunk(@NotNull ResettableBooleanChunk<?> resettableBooleanChunk) {
        this.booleanChunkPool.giveResettableBooleanChunk(resettableBooleanChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableBooleanChunk<ATTR> takeResettableWritableBooleanChunk() {
        return this.booleanChunkPool.takeResettableWritableBooleanChunk();
    }

    @Override
    public void giveResettableWritableBooleanChunk(@NotNull ResettableWritableBooleanChunk<?> resettableWritableBooleanChunk) {
        this.booleanChunkPool.giveResettableWritableBooleanChunk(resettableWritableBooleanChunk);
    }

    @Override
    public <ATTR extends Any> WritableCharChunk<ATTR> takeWritableCharChunk(int capacity) {
        return this.charChunkPool.takeWritableCharChunk(capacity);
    }

    @Override
    public void giveWritableCharChunk(@NotNull WritableCharChunk<?> writableCharChunk) {
        this.charChunkPool.giveWritableCharChunk(writableCharChunk);
    }

    @Override
    public <ATTR extends Any> ResettableCharChunk<ATTR> takeResettableCharChunk() {
        return this.charChunkPool.takeResettableCharChunk();
    }

    @Override
    public void giveResettableCharChunk(@NotNull ResettableCharChunk<?> resettableCharChunk) {
        this.charChunkPool.giveResettableCharChunk(resettableCharChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableCharChunk<ATTR> takeResettableWritableCharChunk() {
        return this.charChunkPool.takeResettableWritableCharChunk();
    }

    @Override
    public void giveResettableWritableCharChunk(@NotNull ResettableWritableCharChunk<?> resettableWritableCharChunk) {
        this.charChunkPool.giveResettableWritableCharChunk(resettableWritableCharChunk);
    }

    @Override
    public <ATTR extends Any> WritableByteChunk<ATTR> takeWritableByteChunk(int capacity) {
        return this.byteChunkPool.takeWritableByteChunk(capacity);
    }

    @Override
    public void giveWritableByteChunk(@NotNull WritableByteChunk<?> writableByteChunk) {
        this.byteChunkPool.giveWritableByteChunk(writableByteChunk);
    }

    @Override
    public <ATTR extends Any> ResettableByteChunk<ATTR> takeResettableByteChunk() {
        return this.byteChunkPool.takeResettableByteChunk();
    }

    @Override
    public void giveResettableByteChunk(@NotNull ResettableByteChunk<?> resettableByteChunk) {
        this.byteChunkPool.giveResettableByteChunk(resettableByteChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableByteChunk<ATTR> takeResettableWritableByteChunk() {
        return this.byteChunkPool.takeResettableWritableByteChunk();
    }

    @Override
    public void giveResettableWritableByteChunk(@NotNull ResettableWritableByteChunk<?> resettableWritableByteChunk) {
        this.byteChunkPool.giveResettableWritableByteChunk(resettableWritableByteChunk);
    }

    @Override
    public <ATTR extends Any> WritableShortChunk<ATTR> takeWritableShortChunk(int capacity) {
        return this.shortChunkPool.takeWritableShortChunk(capacity);
    }

    @Override
    public void giveWritableShortChunk(@NotNull WritableShortChunk<?> writableShortChunk) {
        this.shortChunkPool.giveWritableShortChunk(writableShortChunk);
    }

    @Override
    public <ATTR extends Any> ResettableShortChunk<ATTR> takeResettableShortChunk() {
        return this.shortChunkPool.takeResettableShortChunk();
    }

    @Override
    public void giveResettableShortChunk(@NotNull ResettableShortChunk<?> resettableShortChunk) {
        this.shortChunkPool.giveResettableShortChunk(resettableShortChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableShortChunk<ATTR> takeResettableWritableShortChunk() {
        return this.shortChunkPool.takeResettableWritableShortChunk();
    }

    @Override
    public void giveResettableWritableShortChunk(@NotNull ResettableWritableShortChunk<?> resettableWritableShortChunk) {
        this.shortChunkPool.giveResettableWritableShortChunk(resettableWritableShortChunk);
    }

    @Override
    public <ATTR extends Any> WritableIntChunk<ATTR> takeWritableIntChunk(int capacity) {
        return this.intChunkPool.takeWritableIntChunk(capacity);
    }

    @Override
    public void giveWritableIntChunk(@NotNull WritableIntChunk<?> writableIntChunk) {
        this.intChunkPool.giveWritableIntChunk(writableIntChunk);
    }

    @Override
    public <ATTR extends Any> ResettableIntChunk<ATTR> takeResettableIntChunk() {
        return this.intChunkPool.takeResettableIntChunk();
    }

    @Override
    public void giveResettableIntChunk(@NotNull ResettableIntChunk<?> resettableIntChunk) {
        this.intChunkPool.giveResettableIntChunk(resettableIntChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableIntChunk<ATTR> takeResettableWritableIntChunk() {
        return this.intChunkPool.takeResettableWritableIntChunk();
    }

    @Override
    public void giveResettableWritableIntChunk(@NotNull ResettableWritableIntChunk<?> resettableWritableIntChunk) {
        this.intChunkPool.giveResettableWritableIntChunk(resettableWritableIntChunk);
    }

    @Override
    public <ATTR extends Any> WritableLongChunk<ATTR> takeWritableLongChunk(int capacity) {
        return this.longChunkPool.takeWritableLongChunk(capacity);
    }

    @Override
    public void giveWritableLongChunk(@NotNull WritableLongChunk<?> writableLongChunk) {
        this.longChunkPool.giveWritableLongChunk(writableLongChunk);
    }

    @Override
    public <ATTR extends Any> ResettableLongChunk<ATTR> takeResettableLongChunk() {
        return this.longChunkPool.takeResettableLongChunk();
    }

    @Override
    public void giveResettableLongChunk(@NotNull ResettableLongChunk<?> resettableLongChunk) {
        this.longChunkPool.giveResettableLongChunk(resettableLongChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableLongChunk<ATTR> takeResettableWritableLongChunk() {
        return this.longChunkPool.takeResettableWritableLongChunk();
    }

    @Override
    public void giveResettableWritableLongChunk(@NotNull ResettableWritableLongChunk<?> resettableWritableLongChunk) {
        this.longChunkPool.giveResettableWritableLongChunk(resettableWritableLongChunk);
    }

    @Override
    public <ATTR extends Any> WritableFloatChunk<ATTR> takeWritableFloatChunk(int capacity) {
        return this.floatChunkPool.takeWritableFloatChunk(capacity);
    }

    @Override
    public void giveWritableFloatChunk(@NotNull WritableFloatChunk<?> writableFloatChunk) {
        this.floatChunkPool.giveWritableFloatChunk(writableFloatChunk);
    }

    @Override
    public <ATTR extends Any> ResettableFloatChunk<ATTR> takeResettableFloatChunk() {
        return this.floatChunkPool.takeResettableFloatChunk();
    }

    @Override
    public void giveResettableFloatChunk(@NotNull ResettableFloatChunk<?> resettableFloatChunk) {
        this.floatChunkPool.giveResettableFloatChunk(resettableFloatChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableFloatChunk<ATTR> takeResettableWritableFloatChunk() {
        return this.floatChunkPool.takeResettableWritableFloatChunk();
    }

    @Override
    public void giveResettableWritableFloatChunk(@NotNull ResettableWritableFloatChunk<?> resettableWritableFloatChunk) {
        this.floatChunkPool.giveResettableWritableFloatChunk(resettableWritableFloatChunk);
    }

    @Override
    public <ATTR extends Any> WritableDoubleChunk<ATTR> takeWritableDoubleChunk(int capacity) {
        return this.doubleChunkPool.takeWritableDoubleChunk(capacity);
    }

    @Override
    public void giveWritableDoubleChunk(@NotNull WritableDoubleChunk<?> writableDoubleChunk) {
        this.doubleChunkPool.giveWritableDoubleChunk(writableDoubleChunk);
    }

    @Override
    public <ATTR extends Any> ResettableDoubleChunk<ATTR> takeResettableDoubleChunk() {
        return this.doubleChunkPool.takeResettableDoubleChunk();
    }

    @Override
    public void giveResettableDoubleChunk(@NotNull ResettableDoubleChunk<?> resettableDoubleChunk) {
        this.doubleChunkPool.giveResettableDoubleChunk(resettableDoubleChunk);
    }

    @Override
    public <ATTR extends Any> ResettableWritableDoubleChunk<ATTR> takeResettableWritableDoubleChunk() {
        return this.doubleChunkPool.takeResettableWritableDoubleChunk();
    }

    @Override
    public void giveResettableWritableDoubleChunk(@NotNull ResettableWritableDoubleChunk<?> resettableWritableDoubleChunk) {
        this.doubleChunkPool.giveResettableWritableDoubleChunk(resettableWritableDoubleChunk);
    }

    @Override
    public <TYPE, ATTR extends Any> WritableObjectChunk<TYPE, ATTR> takeWritableObjectChunk(int capacity) {
        return this.objectChunkPool.takeWritableObjectChunk(capacity);
    }

    @Override
    public void giveWritableObjectChunk(@NotNull WritableObjectChunk<?, ?> writableObjectChunk) {
        this.objectChunkPool.giveWritableObjectChunk(writableObjectChunk);
    }

    @Override
    public <TYPE, ATTR extends Any> ResettableObjectChunk<TYPE, ATTR> takeResettableObjectChunk() {
        return this.objectChunkPool.takeResettableObjectChunk();
    }

    @Override
    public void giveResettableObjectChunk(@NotNull ResettableObjectChunk<?, ?> resettableObjectChunk) {
        this.objectChunkPool.giveResettableObjectChunk(resettableObjectChunk);
    }

    @Override
    public <TYPE, ATTR extends Any> ResettableWritableObjectChunk<TYPE, ATTR> takeResettableWritableObjectChunk() {
        return this.objectChunkPool.takeResettableWritableObjectChunk();
    }

    @Override
    public void giveResettableWritableObjectChunk(@NotNull ResettableWritableObjectChunk<?, ?> resettableWritableObjectChunk) {
        this.objectChunkPool.giveResettableWritableObjectChunk(resettableWritableObjectChunk);
    }
}

