/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableObjectChunk;
import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.chunk.util.pools.ObjectChunkPool;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class ObjectChunkSoftPool
implements ChunkPool,
ObjectChunkPool {
    private final WritableObjectChunk<?, Any> EMPTY = WritableObjectChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
    private final SegmentedSoftPool<WritableObjectChunk>[] writableObjectChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableObjectChunk> resettableObjectChunks;
    private final SegmentedSoftPool<ResettableWritableObjectChunk> resettableWritableObjectChunks;

    ObjectChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableObjectChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableObjectChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> {
                chunk.fillWithNullValue(0, chunkCapacity);
                chunk.setSize(chunkCapacity);
            });
        }
        this.resettableObjectChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableObjectChunk::makeResettableChunkForPool), ResettableObjectChunk::clear);
        this.resettableWritableObjectChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableObjectChunk::makeResettableChunkForPool), ResettableWritableObjectChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return ObjectChunkSoftPool.this.takeWritableObjectChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                ObjectChunkSoftPool.this.giveWritableObjectChunk(writableChunk.asWritableObjectChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return ObjectChunkSoftPool.this.takeResettableObjectChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                ObjectChunkSoftPool.this.giveResettableObjectChunk(resettableChunk.asResettableObjectChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return ObjectChunkSoftPool.this.takeResettableWritableObjectChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                ObjectChunkSoftPool.this.giveResettableWritableObjectChunk(resettableWritableChunk.asResettableWritableObjectChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
        return this.takeWritableObjectChunk(capacity);
    }

    @Override
    public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
        this.giveWritableObjectChunk(writableChunk.asWritableObjectChunk());
    }

    @Override
    public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
        return this.takeResettableObjectChunk();
    }

    @Override
    public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
        this.giveResettableObjectChunk(resettableChunk.asResettableObjectChunk());
    }

    @Override
    public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
        return this.takeResettableWritableObjectChunk();
    }

    @Override
    public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
        this.giveResettableWritableObjectChunk(resettableWritableChunk.asResettableWritableObjectChunk());
    }

    @Override
    public <TYPE, ATTR extends Any> WritableObjectChunk<TYPE, ATTR> takeWritableObjectChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableObjectChunk result = (WritableObjectChunk)this.writableObjectChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableObjectChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableObjectChunk(@NotNull WritableObjectChunk<?, ?> writableObjectChunk) {
        if (writableObjectChunk == this.EMPTY || writableObjectChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableObjectChunk);
        int capacity = writableObjectChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableObjectChunks[poolIndexForGive].give(writableObjectChunk);
        }
    }

    @Override
    public <TYPE, ATTR extends Any> ResettableObjectChunk<TYPE, ATTR> takeResettableObjectChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableObjectChunk)this.resettableObjectChunks.take());
    }

    public void giveResettableObjectChunk(@NotNull ResettableObjectChunk resettableObjectChunk) {
        this.resettableObjectChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableObjectChunk));
    }

    @Override
    public <TYPE, ATTR extends Any> ResettableWritableObjectChunk<TYPE, ATTR> takeResettableWritableObjectChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableObjectChunk)this.resettableWritableObjectChunks.take());
    }

    public void giveResettableWritableObjectChunk(@NotNull ResettableWritableObjectChunk resettableWritableObjectChunk) {
        this.resettableWritableObjectChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableObjectChunk));
    }
}

