/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.chunk.util.pools;

import io.deephaven.chunk.ResettableReadOnlyChunk;
import io.deephaven.chunk.ResettableShortChunk;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.ResettableWritableShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.util.pools.ChunkPool;
import io.deephaven.chunk.util.pools.ChunkPoolConstants;
import io.deephaven.chunk.util.pools.ChunkPoolInstrumentation;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.chunk.util.pools.ShortChunkPool;
import io.deephaven.util.datastructures.SegmentedSoftPool;
import io.deephaven.util.type.ArrayTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class ShortChunkSoftPool
implements ShortChunkPool {
    private final WritableShortChunk<Any> EMPTY = WritableShortChunk.writableChunkWrap(ArrayTypeUtils.EMPTY_SHORT_ARRAY);
    private final SegmentedSoftPool<WritableShortChunk>[] writableShortChunks = new SegmentedSoftPool[12];
    private final SegmentedSoftPool<ResettableShortChunk> resettableShortChunks;
    private final SegmentedSoftPool<ResettableWritableShortChunk> resettableWritableShortChunks;

    ShortChunkSoftPool() {
        for (int pcci = 0; pcci < 12; ++pcci) {
            int chunkLog2Capacity = pcci + 5;
            int chunkCapacity = 1 << chunkLog2Capacity;
            this.writableShortChunks[pcci] = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(() -> WritableShortChunk.makeWritableChunkForPool(chunkCapacity)), chunk -> chunk.setSize(chunkCapacity));
        }
        this.resettableShortChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableShortChunk::makeResettableChunkForPool), ResettableShortChunk::clear);
        this.resettableWritableShortChunks = new SegmentedSoftPool(10, () -> ChunkPoolInstrumentation.getAndRecord(ResettableWritableShortChunk::makeResettableChunkForPool), ResettableWritableShortChunk::clear);
    }

    @Override
    public ChunkPool asChunkPool() {
        return new ChunkPool(){

            @Override
            public <ATTR extends Any> WritableChunk<ATTR> takeWritableChunk(int capacity) {
                return ShortChunkSoftPool.this.takeWritableShortChunk(capacity);
            }

            @Override
            public <ATTR extends Any> void giveWritableChunk(@NotNull WritableChunk<ATTR> writableChunk) {
                ShortChunkSoftPool.this.giveWritableShortChunk(writableChunk.asWritableShortChunk());
            }

            @Override
            public <ATTR extends Any> ResettableReadOnlyChunk<ATTR> takeResettableChunk() {
                return ShortChunkSoftPool.this.takeResettableShortChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableChunk(@NotNull ResettableReadOnlyChunk<ATTR> resettableChunk) {
                ShortChunkSoftPool.this.giveResettableShortChunk((ResettableShortChunk)resettableChunk.asResettableShortChunk());
            }

            @Override
            public <ATTR extends Any> ResettableWritableChunk<ATTR> takeResettableWritableChunk() {
                return ShortChunkSoftPool.this.takeResettableWritableShortChunk();
            }

            @Override
            public <ATTR extends Any> void giveResettableWritableChunk(@NotNull ResettableWritableChunk<ATTR> resettableWritableChunk) {
                ShortChunkSoftPool.this.giveResettableWritableShortChunk((ResettableWritableShortChunk)resettableWritableChunk.asResettableWritableShortChunk());
            }
        };
    }

    @Override
    public <ATTR extends Any> WritableShortChunk<ATTR> takeWritableShortChunk(int capacity) {
        if (capacity == 0) {
            return this.EMPTY;
        }
        int poolIndexForTake = ChunkPoolConstants.getPoolIndexForTake(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForTake >= 0) {
            WritableShortChunk result = (WritableShortChunk)this.writableShortChunks[poolIndexForTake].take();
            result.setSize(capacity);
            return ChunkPoolReleaseTracking.onTake(result);
        }
        return ChunkPoolReleaseTracking.onTake(WritableShortChunk.makeWritableChunkForPool(capacity));
    }

    @Override
    public void giveWritableShortChunk(@NotNull WritableShortChunk<?> writableShortChunk) {
        if (writableShortChunk == this.EMPTY || writableShortChunk.isAlias(this.EMPTY)) {
            return;
        }
        ChunkPoolReleaseTracking.onGive(writableShortChunk);
        int capacity = writableShortChunk.capacity();
        int poolIndexForGive = ChunkPoolConstants.getPoolIndexForGive(ChunkPoolConstants.checkCapacityBounds(capacity));
        if (poolIndexForGive >= 0) {
            this.writableShortChunks[poolIndexForGive].give(writableShortChunk);
        }
    }

    @Override
    public <ATTR extends Any> ResettableShortChunk<ATTR> takeResettableShortChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableShortChunk)this.resettableShortChunks.take());
    }

    public void giveResettableShortChunk(@NotNull ResettableShortChunk resettableShortChunk) {
        this.resettableShortChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableShortChunk));
    }

    @Override
    public <ATTR extends Any> ResettableWritableShortChunk<ATTR> takeResettableWritableShortChunk() {
        return ChunkPoolReleaseTracking.onTake((ResettableWritableShortChunk)this.resettableWritableShortChunks.take());
    }

    public void giveResettableWritableShortChunk(@NotNull ResettableWritableShortChunk resettableWritableShortChunk) {
        this.resettableWritableShortChunks.give((Object)ChunkPoolReleaseTracking.onGive(resettableWritableShortChunk));
    }
}

