/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.context;

import io.deephaven.auth.AuthContext;
import io.deephaven.engine.context.EmptyQueryScope;
import io.deephaven.engine.context.PoisonedOperationInitializer;
import io.deephaven.engine.context.PoisonedQueryCompiler;
import io.deephaven.engine.context.PoisonedQueryLibrary;
import io.deephaven.engine.context.PoisonedQueryScope;
import io.deephaven.engine.context.PoisonedUpdateGraph;
import io.deephaven.engine.context.QueryCompiler;
import io.deephaven.engine.context.QueryLibrary;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.context.QueryScopeParam;
import io.deephaven.engine.context.StandaloneQueryScope;
import io.deephaven.engine.updategraph.OperationInitializer;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.ScriptApi;
import io.deephaven.util.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class ExecutionContext {
    private static volatile ExecutionContext defaultContext = null;
    private static final ThreadLocal<ExecutionContext> currentContext = ThreadLocal.withInitial(ExecutionContext::getDefaultContext);
    private final boolean isSystemic;
    private final AuthContext authContext;
    private final QueryLibrary queryLibrary;
    private final QueryScope queryScope;
    private final QueryCompiler queryCompiler;
    private final UpdateGraph updateGraph;
    private final OperationInitializer operationInitializer;

    public static Builder newBuilder() {
        ExecutionContext existing = ExecutionContext.getContext();
        return new Builder().setUpdateGraph(existing.getUpdateGraph()).setOperationInitializer(existing.getOperationInitializer());
    }

    public static ExecutionContext makeExecutionContext(boolean isSystemic) {
        return ExecutionContext.getContext().withSystemic(isSystemic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutionContext getDefaultContext() {
        ExecutionContext localContext = defaultContext;
        if (localContext != null) return localContext;
        Class<ExecutionContext> clazz = ExecutionContext.class;
        synchronized (ExecutionContext.class) {
            localContext = defaultContext;
            if (localContext != null) return localContext;
            defaultContext = new Builder(null).markSystemic().build();
            return defaultContext;
        }
    }

    public static ExecutionContext getContextToRecord() {
        ExecutionContext ctxt = currentContext.get();
        if (ctxt.isSystemic) {
            return null;
        }
        return ctxt;
    }

    public static ExecutionContext getContext() {
        return currentContext.get();
    }

    private static void setContext(ExecutionContext context) {
        currentContext.set(context);
    }

    private ExecutionContext(boolean isSystemic, AuthContext authContext, QueryLibrary queryLibrary, QueryScope queryScope, QueryCompiler queryCompiler, UpdateGraph updateGraph, OperationInitializer operationInitializer) {
        this.isSystemic = isSystemic;
        this.authContext = authContext;
        this.queryLibrary = Objects.requireNonNull(queryLibrary);
        this.queryScope = Objects.requireNonNull(queryScope);
        this.queryCompiler = Objects.requireNonNull(queryCompiler);
        this.updateGraph = Objects.requireNonNull(updateGraph);
        this.operationInitializer = Objects.requireNonNull(operationInitializer);
    }

    public ExecutionContext withSystemic(boolean isSystemic) {
        if (isSystemic == this.isSystemic) {
            return this;
        }
        return new ExecutionContext(isSystemic, this.authContext, this.queryLibrary, this.queryScope, this.queryCompiler, this.updateGraph, this.operationInitializer);
    }

    public ExecutionContext withAuthContext(AuthContext authContext) {
        if (authContext == this.authContext) {
            return this;
        }
        return new ExecutionContext(this.isSystemic, authContext, this.queryLibrary, this.queryScope, this.queryCompiler, this.updateGraph, this.operationInitializer);
    }

    public ExecutionContext withUpdateGraph(UpdateGraph updateGraph) {
        if (updateGraph == this.updateGraph) {
            return this;
        }
        return new ExecutionContext(this.isSystemic, this.authContext, this.queryLibrary, this.queryScope, this.queryCompiler, updateGraph, this.operationInitializer);
    }

    public ExecutionContext withOperationInitializer(OperationInitializer operationInitializer) {
        if (operationInitializer == this.operationInitializer) {
            return this;
        }
        return new ExecutionContext(this.isSystemic, this.authContext, this.queryLibrary, this.queryScope, this.queryCompiler, this.updateGraph, operationInitializer);
    }

    public ExecutionContext withQueryScope(QueryScope queryScope) {
        if (queryScope == this.queryScope) {
            return this;
        }
        return new ExecutionContext(this.isSystemic, this.authContext, this.queryLibrary, queryScope, this.queryCompiler, this.updateGraph, this.operationInitializer);
    }

    public void apply(Runnable runnable) {
        this.apply(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> T apply(Supplier<T> supplier) {
        try (SafeCloseable ignored = this.open();){
            T t = supplier.get();
            return t;
        }
    }

    public SafeCloseable open() {
        ExecutionContext oldExecutionContext = currentContext.get();
        ExecutionContext.setContext(this);
        return () -> ExecutionContext.setContext(oldExecutionContext);
    }

    public QueryLibrary getQueryLibrary() {
        return this.queryLibrary;
    }

    public QueryScope getQueryScope() {
        return this.queryScope;
    }

    public QueryCompiler getQueryCompiler() {
        return this.queryCompiler;
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public UpdateGraph getUpdateGraph() {
        return this.updateGraph;
    }

    public OperationInitializer getOperationInitializer() {
        return this.operationInitializer;
    }

    public static class Builder {
        private boolean isSystemic = false;
        private final AuthContext authContext;
        private QueryLibrary queryLibrary = PoisonedQueryLibrary.INSTANCE;
        private QueryScope queryScope = PoisonedQueryScope.INSTANCE;
        private QueryCompiler queryCompiler = PoisonedQueryCompiler.INSTANCE;
        private UpdateGraph updateGraph = PoisonedUpdateGraph.INSTANCE;
        private OperationInitializer operationInitializer = PoisonedOperationInitializer.INSTANCE;

        private Builder() {
            this(ExecutionContext.getContext().authContext);
        }

        @VisibleForTesting
        Builder(AuthContext authContext) {
            this.authContext = authContext;
        }

        @ScriptApi
        public Builder markSystemic() {
            this.isSystemic = true;
            return this;
        }

        @ScriptApi
        public Builder newQueryLibrary() {
            this.queryLibrary = QueryLibrary.makeNewLibrary();
            return this;
        }

        @ScriptApi
        public Builder newQueryLibrary(String libraryVersion) {
            this.queryLibrary = QueryLibrary.makeNewLibrary(libraryVersion);
            return this;
        }

        @ScriptApi
        public Builder setQueryLibrary(QueryLibrary queryLibrary) {
            this.queryLibrary = queryLibrary;
            return this;
        }

        @ScriptApi
        public Builder captureQueryLibrary() {
            this.queryLibrary = currentContext.get().getQueryLibrary();
            return this;
        }

        @ScriptApi
        public Builder setQueryCompiler(QueryCompiler queryCompiler) {
            this.queryCompiler = queryCompiler;
            return this;
        }

        @ScriptApi
        public Builder captureQueryCompiler() {
            this.queryCompiler = currentContext.get().getQueryCompiler();
            return this;
        }

        @ScriptApi
        public Builder emptyQueryScope() {
            this.queryScope = EmptyQueryScope.INSTANCE;
            return this;
        }

        @ScriptApi
        public Builder newQueryScope() {
            this.queryScope = new StandaloneQueryScope();
            return this;
        }

        @ScriptApi
        public Builder setQueryScope(QueryScope queryScope) {
            this.queryScope = queryScope;
            return this;
        }

        @ScriptApi
        public Builder captureQueryScope() {
            this.queryScope = currentContext.get().getQueryScope();
            return this;
        }

        @ScriptApi
        public Builder captureQueryScopeVars(String ... vars) {
            QueryScopeParam<?>[] params;
            if (vars.length == 0) {
                return this.newQueryScope();
            }
            this.queryScope = new StandaloneQueryScope();
            for (QueryScopeParam<?> param : params = ExecutionContext.getContext().getQueryScope().getParams(Arrays.asList(vars))) {
                this.queryScope.putParam(param.getName(), param.getValue());
            }
            return this;
        }

        @ScriptApi
        public Builder setUpdateGraph(UpdateGraph updateGraph) {
            this.updateGraph = updateGraph;
            return this;
        }

        @Deprecated(forRemoval=true, since="0.31")
        @ScriptApi
        public Builder captureUpdateGraph() {
            this.updateGraph = ExecutionContext.getContext().getUpdateGraph();
            return this;
        }

        @ScriptApi
        public Builder setOperationInitializer(OperationInitializer operationInitializer) {
            this.operationInitializer = operationInitializer;
            return this;
        }

        @ScriptApi
        public ExecutionContext build() {
            return new ExecutionContext(this.isSystemic, this.authContext, this.queryLibrary, this.queryScope, this.queryCompiler, this.updateGraph, this.operationInitializer);
        }
    }
}

