/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.context;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.FileUtils;
import io.deephaven.base.Pair;
import io.deephaven.configuration.Configuration;
import io.deephaven.configuration.DataDir;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.util.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryCompiler {
    private static final Logger log = LoggerFactory.getLogger(QueryCompiler.class);
    private static final int DEFAULT_MAX_STRING_LITERAL_LENGTH = 65500;
    private static final String JAVA_CLASS_VERSION = System.getProperty("java.class.version").replace('.', '_');
    private static final int MAX_CLASS_COLLISIONS = 128;
    private static final String IDENTIFYING_FIELD_NAME = "_CLASS_BODY_";
    private static final String CODEGEN_TIMEOUT_PROP = "QueryCompiler.codegen.timeoutMs";
    private static final long CODEGEN_TIMEOUT_MS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private static final String CODEGEN_LOOP_DELAY_PROP = "QueryCompiler.codegen.retry.delay";
    private static final long CODEGEN_LOOP_DELAY_MS_DEFAULT = 100L;
    private static final long codegenTimeoutMs = Configuration.getInstance().getLongWithDefault("QueryCompiler.codegen.timeoutMs", CODEGEN_TIMEOUT_MS_DEFAULT);
    private static final long codegenLoopDelayMs = Configuration.getInstance().getLongWithDefault("QueryCompiler.codegen.retry.delay", 100L);
    private static boolean logEnabled = Configuration.getInstance().getBoolean("QueryCompiler.logEnabledDefault");
    public static final String FORMULA_PREFIX = "io.deephaven.temp";
    public static final String DYNAMIC_GROOVY_CLASS_PREFIX = "io.deephaven.dynamic";
    private final Map<String, CompletableFuture<Class<?>>> knownClasses = new HashMap();
    private final String[] dynamicPatterns = new String[]{"io.deephaven.dynamic", "io.deephaven.temp"};
    private final File classDestination;
    private final boolean isCacheDirectory;
    private final Set<File> additionalClassLocations;
    private volatile WritableURLClassLoader ucl;

    public static QueryCompiler create(File cacheDirectory, ClassLoader classLoader) {
        return new QueryCompiler(cacheDirectory, classLoader, true);
    }

    static QueryCompiler createForUnitTests() {
        Path queryCompilerDir = DataDir.get().resolve("io.deephaven.engine.context.QueryCompiler.createForUnitTests");
        return new QueryCompiler(queryCompilerDir.toFile());
    }

    QueryCompiler() {
        this.classDestination = null;
        this.isCacheDirectory = false;
        this.additionalClassLocations = null;
    }

    private QueryCompiler(File classDestination) {
        this(classDestination, null, false);
    }

    private QueryCompiler(File classDestination, ClassLoader parentClassLoader, boolean isCacheDirectory) {
        ClassLoader parentClassLoaderToUse = parentClassLoader == null ? QueryCompiler.class.getClassLoader() : parentClassLoader;
        this.classDestination = classDestination;
        this.isCacheDirectory = isCacheDirectory;
        QueryCompiler.ensureDirectories(this.classDestination, () -> "Failed to create missing class destination directory " + classDestination.getAbsolutePath());
        this.additionalClassLocations = new LinkedHashSet<File>();
        URL[] urls = new URL[1];
        try {
            urls[0] = classDestination.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedDeephavenException((Throwable)e);
        }
        this.ucl = new WritableURLClassLoader(urls, parentClassLoaderToUse);
        if (isCacheDirectory) {
            this.addClassSource(classDestination);
        }
    }

    public static boolean setLogEnabled(boolean logEnabled) {
        boolean original = QueryCompiler.logEnabled;
        QueryCompiler.logEnabled = logEnabled;
        return original;
    }

    public static void writeClass(File destinationDirectory, String className, byte[] data) throws IOException {
        QueryCompiler.writeClass(destinationDirectory, className, data, null);
    }

    public static void writeClass(File destinationDirectory, String className, byte[] data, String message) throws IOException {
        File destinationFile = new File(destinationDirectory, className.replace('.', File.separatorChar) + JavaFileObject.Kind.CLASS.extension);
        if (destinationFile.exists()) {
            byte[] existingBytes = Files.readAllBytes(destinationFile.toPath());
            if (Arrays.equals(existingBytes, data)) {
                if (message == null) {
                    log.info().append((CharSequence)"Ignoring pushed class ").append((CharSequence)className).append((CharSequence)" because it already exists in this context!").endl();
                } else {
                    log.info().append((CharSequence)"Ignoring pushed class ").append((CharSequence)className).append((CharSequence)message).append((CharSequence)" because it already exists in this context!").endl();
                }
                return;
            }
            if (message == null) {
                log.info().append((CharSequence)"Pushed class ").append((CharSequence)className).append((CharSequence)" already exists in this context, but has changed!").endl();
            } else {
                log.info().append((CharSequence)"Pushed class ").append((CharSequence)className).append((CharSequence)message).append((CharSequence)" already exists in this context, but has changed!").endl();
            }
            if (!destinationFile.delete()) {
                throw new IOException("Could not delete existing class file: " + destinationFile);
            }
        }
        File parentDir = destinationFile.getParentFile();
        QueryCompiler.ensureDirectories(parentDir, () -> "Unable to create missing destination directory " + parentDir.getAbsolutePath());
        if (!destinationFile.createNewFile()) {
            throw new UncheckedDeephavenException("Unable to create destination file " + destinationFile.getAbsolutePath());
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(data.length);
        byteOutStream.write(data, 0, data.length);
        FileOutputStream fileOutStream = new FileOutputStream(destinationFile);
        byteOutStream.writeTo(fileOutStream);
        fileOutStream.close();
    }

    public File getFakeClassDestination() {
        return this.isCacheDirectory ? this.classDestination : null;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.ucl = new WritableURLClassLoader(this.ucl.getURLs(), parentClassLoader);
    }

    public final Class<?> compile(String className, String classBody, String packageNameRoot) {
        return this.compile(className, classBody, packageNameRoot, null, Collections.emptyMap());
    }

    public final Class<?> compile(String className, String classBody, String packageNameRoot, Map<String, Class<?>> parameterClasses) {
        return this.compile(className, classBody, packageNameRoot, null, parameterClasses);
    }

    public final Class<?> compile(String className, String classBody, String packageNameRoot, StringBuilder codeLog) {
        return this.compile(className, classBody, packageNameRoot, codeLog, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> compile(@NotNull String className, @NotNull String classBody, @NotNull String packageNameRoot, @Nullable StringBuilder codeLog, @NotNull Map<String, Class<?>> parameterClasses) {
        boolean alreadyExists;
        CompletableFuture<Class<?>> future;
        QueryCompiler queryCompiler = this;
        synchronized (queryCompiler) {
            future = this.knownClasses.get(classBody);
            if (future != null) {
                alreadyExists = true;
            } else {
                future = new CompletableFuture();
                this.knownClasses.put(classBody, future);
                alreadyExists = false;
            }
        }
        if (alreadyExists) {
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException error) {
                throw new UncheckedDeephavenException((Throwable)error);
            }
        }
        try {
            return this.compileHelper(className, classBody, packageNameRoot, codeLog, parameterClasses, future);
        }
        catch (RuntimeException e) {
            future.completeExceptionally(e);
            throw e;
        }
    }

    private static void ensureDirectories(File file, Supplier<String> runtimeErrMsg) {
        if (!file.mkdirs() && !file.isDirectory()) {
            throw new UncheckedDeephavenException(runtimeErrMsg.get());
        }
    }

    private ClassLoader getClassLoaderForFormula(final Map<String, Class<?>> parameterClasses) {
        return new URLClassLoader(this.ucl.getURLs(), (ClassLoader)this.ucl){
            final HashSet<String> missingClasses;
            {
                super(urls, parent);
                this.missingClasses = new HashSet();
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                byte[] bytes;
                Class paramClass = (Class)parameterClasses.get(name);
                if (paramClass != null) {
                    return paramClass;
                }
                if (!this.isFormulaClass(name)) {
                    return super.findClass(name);
                }
                if (name.startsWith(QueryCompiler.DYNAMIC_GROOVY_CLASS_PREFIX)) {
                    try {
                        return QueryCompiler.this.ucl.getParent().loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.missingClasses.contains(name)) {
                    return super.findClass(name);
                }
                try {
                    bytes = this.loadClassData(name);
                }
                catch (IOException ioe) {
                    this.missingClasses.add(name);
                    return super.loadClass(name);
                }
                return this.defineClass(name, bytes, 0, bytes.length);
            }

            private boolean isFormulaClass(String name) {
                return Arrays.stream(QueryCompiler.this.dynamicPatterns).anyMatch(name::startsWith);
            }

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (!this.isFormulaClass(name)) {
                    return super.loadClass(name);
                }
                return this.findClass(name);
            }

            private byte[] loadClassData(String name) throws IOException {
                File destFile = new File(QueryCompiler.this.classDestination, name.replace('.', File.separatorChar) + JavaFileObject.Kind.CLASS.extension);
                if (destFile.exists()) {
                    return Files.readAllBytes(destFile.toPath());
                }
                for (File location : QueryCompiler.this.additionalClassLocations) {
                    File checkFile = new File(location, name.replace('.', File.separatorChar) + JavaFileObject.Kind.CLASS.extension);
                    if (!checkFile.exists()) continue;
                    return Files.readAllBytes(checkFile.toPath());
                }
                throw new FileNotFoundException(name);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassSource(File classSourceDirectory) {
        Set<File> set = this.additionalClassLocations;
        synchronized (set) {
            if (this.additionalClassLocations.contains(classSourceDirectory)) {
                return;
            }
            this.additionalClassLocations.add(classSourceDirectory);
        }
        try {
            this.ucl.addURL(classSourceDirectory.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new UncheckedDeephavenException((Throwable)e);
        }
    }

    private File getClassDestination() {
        return this.classDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.classDestination.getAbsolutePath());
        Set<File> set = this.additionalClassLocations;
        synchronized (set) {
            for (File classLoc : this.additionalClassLocations) {
                sb.append(File.pathSeparatorChar).append(classLoc.getAbsolutePath());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> compileHelper(@NotNull String className, @NotNull String classBody, @NotNull String packageNameRoot, @Nullable StringBuilder codeLog, @NotNull Map<String, Class<?>> parameterClasses, @NotNull CompletableFuture<Class<?>> resultFuture) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedDeephavenException("Unable to create SHA-256 hashing digest", (Throwable)e);
        }
        String basicHashText = ByteUtils.byteArrToHex((byte[])digest.digest(classBody.getBytes(StandardCharsets.UTF_8)));
        for (int pi = 0; pi < 128; ++pi) {
            String identifyingFieldValue;
            String packageNameSuffix = "c_" + basicHashText + (String)(pi == 0 ? "" : "p" + pi) + "v" + JAVA_CLASS_VERSION;
            String packageName = packageNameRoot.isEmpty() ? packageNameSuffix : packageNameRoot + (packageNameRoot.endsWith(".") ? "" : ".") + packageNameSuffix;
            String fqClassName = packageName + "." + className;
            Class<?> result = this.tryLoadClassByFqName(fqClassName, parameterClasses);
            if (result == null) {
                this.maybeCreateClass(className, classBody, packageName, fqClassName);
                result = this.tryLoadClassByFqName(fqClassName, parameterClasses);
                try {
                    long deadline = System.currentTimeMillis() + codegenTimeoutMs - codegenLoopDelayMs;
                    while (result == null && System.currentTimeMillis() < deadline) {
                        Thread.sleep(codegenLoopDelayMs);
                        result = this.tryLoadClassByFqName(fqClassName, parameterClasses);
                    }
                }
                catch (InterruptedException deadline) {
                    // empty catch block
                }
                if (result == null) {
                    throw new IllegalStateException("Should have been able to load *some* class here");
                }
            }
            if (!classBody.equals(identifyingFieldValue = QueryCompiler.loadIdentifyingField(result))) continue;
            if (codeLog != null) {
                codeLog.append(QueryCompiler.makeFinalCode(className, classBody, packageName));
            }
            resultFuture.complete(result);
            QueryCompiler queryCompiler = this;
            synchronized (queryCompiler) {
                this.knownClasses.remove(identifyingFieldValue);
                this.knownClasses.put(identifyingFieldValue, resultFuture);
            }
            return result;
        }
        throw new IllegalStateException("Found too many collisions for package name root " + packageNameRoot + ", class name=" + className + ", class body hash=" + basicHashText + " - contact Deephaven support!");
    }

    private Class<?> tryLoadClassByFqName(String fqClassName, Map<String, Class<?>> parameterClasses) {
        try {
            return this.getClassLoaderForFormula(parameterClasses).loadClass(fqClassName);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private static String loadIdentifyingField(Class<?> c) {
        try {
            Field field = c.getDeclaredField(IDENTIFYING_FIELD_NAME);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Malformed class in cache", e);
        }
    }

    private static String makeFinalCode(String className, String classBody, String packageName) {
        String joinedEscapedBody = QueryCompiler.createEscapedJoinedString((String)classBody);
        classBody = ((String)classBody).replaceAll("\\$CLASSNAME\\$", className);
        classBody = ((String)classBody).substring(0, ((String)classBody).lastIndexOf("}"));
        classBody = (String)classBody + "    public static String _CLASS_BODY_ = " + joinedEscapedBody + ";\n}";
        return "package " + packageName + ";\n" + (String)classBody;
    }

    public static String createEscapedJoinedString(String originalString) {
        return QueryCompiler.createEscapedJoinedString(originalString, 65500);
    }

    public static String createEscapedJoinedString(String originalString, int maxStringLength) {
        CharSequence[] splits = QueryCompiler.splitByModifiedUtf8Encoding(originalString, maxStringLength);
        for (int ii = 0; ii < splits.length; ++ii) {
            String escaped = StringEscapeUtils.escapeJava((String)splits[ii]);
            splits[ii] = "\"" + escaped + "\"";
        }
        assert (splits.length > 0);
        if (splits.length == 1) {
            return splits[0];
        }
        String formattedInnards = String.join((CharSequence)",\n", splits);
        return "String.join(\"\", " + formattedInnards + ")";
    }

    private static String[] splitByModifiedUtf8Encoding(String originalString, int maxBytes) {
        ArrayList<String> splits = new ArrayList<String>();
        int previousEnd = 0;
        int currentByteCount = 0;
        for (int ii = 0; ii < originalString.length(); ++ii) {
            int bytesConsumed = QueryCompiler.calcBytesConsumed(originalString.charAt(ii));
            if (currentByteCount + bytesConsumed > maxBytes) {
                splits.add(originalString.substring(previousEnd, ii));
                previousEnd = ii;
                currentByteCount = 0;
            }
            currentByteCount += bytesConsumed;
        }
        splits.add(originalString.substring(previousEnd));
        return splits.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
    }

    private static int calcBytesConsumed(char ch) {
        if (ch == '\u0000') {
            return 2;
        }
        if (ch <= '\u007f') {
            return 1;
        }
        if (ch <= '\u07ff') {
            return 2;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCreateClass(String className, String code, String packageName, String fqClassName) {
        String tempDirAsString;
        String rootPathAsString;
        String finalCode = QueryCompiler.makeFinalCode(className, code, packageName);
        if (logEnabled) {
            log.info().append((CharSequence)"Generating code ").append((CharSequence)finalCode).endl();
        }
        File ctxClassDestination = this.getClassDestination();
        String[] splitPackageName = packageName.split("\\.");
        if (splitPackageName.length == 0) {
            throw new UncheckedDeephavenException(String.format("packageName %s expected to have at least one .", packageName));
        }
        String[] truncatedSplitPackageName = Arrays.copyOf(splitPackageName, splitPackageName.length - 1);
        try {
            rootPathAsString = ctxClassDestination.getAbsolutePath();
            Path rootPathWithPackage = Paths.get(rootPathAsString, truncatedSplitPackageName);
            File rpf = rootPathWithPackage.toFile();
            QueryCompiler.ensureDirectories(rpf, () -> "Couldn't create package directories: " + rootPathWithPackage);
            Path tempPath = Files.createTempDirectory(Paths.get(rootPathAsString, new String[0]), "temporaryCompilationDirectory", new FileAttribute[0]);
            tempDirAsString = tempPath.toFile().getAbsolutePath();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        try {
            this.maybeCreateClassHelper(fqClassName, finalCode, splitPackageName, rootPathAsString, tempDirAsString);
        }
        finally {
            try {
                FileUtils.deleteRecursively((File)new File(tempDirAsString));
            }
            catch (Exception exception) {}
        }
    }

    private void maybeCreateClassHelper(String fqClassName, String finalCode, String[] splitPackageName, String rootPathAsString, String tempDirAsString) {
        block15: {
            StringWriter compilerOutput = new StringWriter();
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new UncheckedDeephavenException("No Java compiler provided - are you using a JRE instead of a JDK?");
            }
            String classPathAsString = this.getClassPath() + File.pathSeparator + QueryCompiler.getJavaClassPath();
            List<String> compilerOptions = Arrays.asList("-d", tempDirAsString, "-cp", classPathAsString);
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            boolean result = false;
            boolean exceptionThrown = false;
            try {
                result = compiler.getTask(compilerOutput, fileManager, null, compilerOptions, null, Collections.singletonList(new JavaSourceFromString(fqClassName, finalCode))).call();
            }
            catch (Throwable err) {
                exceptionThrown = true;
                throw err;
            }
            finally {
                block14: {
                    try {
                        fileManager.close();
                    }
                    catch (IOException ioe) {
                        if (exceptionThrown) break block14;
                        throw new UncheckedIOException("Could not close JavaFileManager", ioe);
                    }
                }
            }
            if (!result) {
                throw new UncheckedDeephavenException("Error compiling class " + fqClassName + ":\n" + compilerOutput);
            }
            Path srcDir = Paths.get(tempDirAsString, splitPackageName);
            Path destDir = Paths.get(rootPathAsString, splitPackageName);
            try {
                Files.move(srcDir, destDir, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException ioe) {
                if (Files.exists(destDir, new LinkOption[0])) break block15;
                throw new UncheckedIOException("Move failed for some reason other than destination already existing", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Boolean, String> tryCompile(File basePath, Collection<File> javaFiles) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new UncheckedDeephavenException("No Java compiler provided - are you using a JRE instead of a JDK?");
        }
        File outputDirectory = Files.createTempDirectory("temporaryCompilationDirectory", new FileAttribute[0]).toFile();
        try {
            StringWriter compilerOutput = new StringWriter();
            String javaClasspath = QueryCompiler.getJavaClassPath();
            Collection javaFileObjects = javaFiles.stream().map(f -> new JavaSourceFromFile(basePath, (File)f)).collect(Collectors.toList());
            boolean result = compiler.getTask(compilerOutput, null, null, Arrays.asList("-d", outputDirectory.getAbsolutePath(), "-cp", this.getClassPath() + File.pathSeparator + javaClasspath), null, javaFileObjects).call();
            Pair pair = new Pair((Object)result, (Object)compilerOutput.toString());
            return pair;
        }
        finally {
            FileUtils.deleteRecursively((File)outputDirectory);
        }
    }

    private static String getJavaClassPath() {
        StringBuilder javaClasspathBuilder = new StringBuilder(System.getProperty("java.class.path"));
        String teamCityWorkDir = System.getProperty("teamcity.build.workingDir");
        if (teamCityWorkDir != null) {
            File[] jars;
            File[] testDirs;
            File[] classDirs;
            for (File f : classDirs = new File(teamCityWorkDir + "/_out_/classes").listFiles()) {
                javaClasspathBuilder.append(File.pathSeparator).append(f.getAbsolutePath());
            }
            for (File f : testDirs = new File(teamCityWorkDir + "/_out_/test-classes").listFiles()) {
                javaClasspathBuilder.append(File.pathSeparator).append(f.getAbsolutePath());
            }
            for (File f : jars = FileUtils.findAllFiles((File)new File(teamCityWorkDir + "/lib"))) {
                if (!f.getName().endsWith(".jar")) continue;
                javaClasspathBuilder.append(File.pathSeparator).append(f.getAbsolutePath());
            }
        }
        String javaClasspath = javaClasspathBuilder.toString();
        String intellijClassPathJarRegex = ".*classpath[0-9]*\\.jar.*";
        if (javaClasspath.matches(".*classpath[0-9]*\\.jar.*")) {
            try {
                Enumeration<URL> resources = QueryCompiler.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                Attributes.Name createdByAttribute = new Attributes.Name("Created-By");
                Attributes.Name classPathAttribute = new Attributes.Name("Class-Path");
                while (resources.hasMoreElements()) {
                    String extendedClassPath;
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    Object createdBy = attributes.get(createdByAttribute);
                    if (!"IntelliJ IDEA".equals(createdBy) || (extendedClassPath = (String)attributes.get(classPathAttribute)) == null) continue;
                    String filePaths = Stream.of(extendedClassPath.split("file:/")).map(String::trim).filter(fileName -> fileName.length() > 0).collect(Collectors.joining(File.pathSeparator));
                    javaClasspath = Stream.of(javaClasspath.split(File.pathSeparator)).map(cp -> cp.matches(".*classpath[0-9]*\\.jar.*") ? filePaths : cp).collect(Collectors.joining(File.pathSeparator));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error extract manifest file from " + javaClasspath + ".\n", e);
            }
        }
        return javaClasspath;
    }

    private static class JavaSourceFromFile
    extends SimpleJavaFileObject {
        private static final int JAVA_LENGTH = JavaFileObject.Kind.SOURCE.extension.length();
        final String code;

        private JavaSourceFromFile(File basePath, File file) {
            super(URI.create("string:///" + JavaSourceFromFile.createName(basePath, file).replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            try {
                this.code = FileUtils.readTextFile((File)file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static String createName(File basePath, File file) {
            String base = basePath.getAbsolutePath();
            String fileName = file.getAbsolutePath();
            if (!fileName.startsWith(base)) {
                throw new IllegalArgumentException(file + " is not in " + basePath);
            }
            String basename = fileName.substring(base.length());
            if (basename.endsWith(".java")) {
                return basename.substring(0, basename.length() - JAVA_LENGTH);
            }
            return basename;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    private static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    private static class WritableURLClassLoader
    extends URLClassLoader {
        private WritableURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz;
            block4: {
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (this.getParent() == null) break block4;
                    clazz = this.getParent().loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        @Override
        public synchronized void addURL(URL url) {
            super.addURL(url);
        }
    }
}

