/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.context;

import com.github.f4b6a3.uuid.UuidCreator;
import io.deephaven.engine.context.QueryLibraryImports;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;

public class QueryLibrary {
    private static final QueryLibraryImports IMPORTS_INSTANCE = QueryLibraryImports.copyFromServiceLoader();
    private String versionString;
    private final Map<String, Package> packageImports;
    private final Map<String, Class<?>> classImports;
    private final Map<String, Class<?>> staticImports;

    static QueryLibrary makeNewLibrary() {
        return new QueryLibrary(IMPORTS_INSTANCE);
    }

    static QueryLibrary makeNewLibrary(String libraryVersion) {
        QueryLibrary ql = QueryLibrary.makeNewLibrary();
        ql.versionString = libraryVersion;
        return ql;
    }

    QueryLibrary() {
        this.packageImports = null;
        this.classImports = null;
        this.staticImports = null;
    }

    private QueryLibrary(QueryLibraryImports imports) {
        this.packageImports = new ConcurrentSkipListMap<String, Package>();
        for (Package package_ : imports.packages()) {
            this.packageImports.put(package_.getName(), package_);
        }
        this.classImports = new ConcurrentSkipListMap();
        for (Class clazz : imports.classes()) {
            this.classImports.put(clazz.getCanonicalName(), clazz);
        }
        this.staticImports = new ConcurrentSkipListMap();
        for (Class clazz : imports.statics()) {
            this.staticImports.put(clazz.getCanonicalName(), clazz);
        }
        this.updateVersionString();
    }

    public Collection<Class<?>> getClassImports() {
        return Collections.unmodifiableCollection(this.classImports.values());
    }

    public Collection<Class<?>> getStaticImports() {
        return Collections.unmodifiableCollection(this.staticImports.values());
    }

    public Collection<Package> getPackageImports() {
        return Collections.unmodifiableCollection(this.packageImports.values());
    }

    public void importPackage(Package aPackage) {
        Package previous = this.packageImports.put(aPackage.getName(), aPackage);
        if (aPackage != previous) {
            this.updateVersionString();
        }
    }

    public void importClass(Class<?> aClass) {
        Class<?> previous = this.classImports.put(aClass.getName(), aClass);
        if (aClass != previous) {
            this.updateVersionString();
        }
    }

    public void importStatic(Class<?> aClass) {
        Class<?> previous = this.staticImports.put(aClass.getCanonicalName(), aClass);
        if (aClass != previous) {
            this.updateVersionString();
        }
    }

    public Collection<String> getImportStrings() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("// QueryLibrary internal version number: " + this.versionString);
        for (Package package_ : this.packageImports.values()) {
            imports.add("import " + package_.getName() + ".*;");
        }
        for (Class clazz : this.classImports.values()) {
            if (clazz.getDeclaringClass() != null) {
                imports.add("import static " + clazz.getCanonicalName() + ";");
                continue;
            }
            if (this.packageImports.containsKey(clazz.getPackage().getName())) continue;
            imports.add("import " + clazz.getName() + ";");
        }
        for (Class clazz : this.staticImports.values()) {
            imports.add("import static " + clazz.getCanonicalName() + ".*;");
        }
        return imports;
    }

    public void updateVersionString() {
        this.versionString = UuidCreator.toString((UUID)UuidCreator.getRandomBased());
    }

    public void updateVersionString(String version) {
        this.versionString = version;
    }
}

