/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.context;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScopeParam;
import io.deephaven.engine.liveness.LivenessNode;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface QueryScope
extends LivenessNode,
LogOutputAppendable {
    public static <T> void addParam(String name, T value) {
        ExecutionContext.getContext().getQueryScope().putParam(name, value);
    }

    public static <T> T getParamValue(String name) throws MissingVariableException {
        return ExecutionContext.getContext().getQueryScope().readParamValue(name);
    }

    default public QueryScopeParam<?>[] getParams(Collection<String> names) throws MissingVariableException {
        QueryScopeParam[] result = new QueryScopeParam[names.size()];
        int pi = 0;
        for (String name : names) {
            result[pi++] = this.createParam(name);
        }
        return result;
    }

    public Set<String> getParamNames();

    public boolean hasParamName(String var1);

    public <T> QueryScopeParam<T> createParam(String var1) throws MissingVariableException;

    public <T> T readParamValue(String var1) throws MissingVariableException;

    public <T> T readParamValue(String var1, T var2);

    public <T> void putParam(String var1, T var2);

    public Map<String, Object> toMap(@NotNull ParamFilter<Object> var1);

    public <T> Map<String, T> toMap(@NotNull Function<Object, T> var1, @NotNull ParamFilter<T> var2);

    default public Object unwrapObject(@Nullable Object object) {
        return object;
    }

    default public LogOutput append(@NotNull LogOutput logOutput) {
        logOutput.append('{');
        for (Map.Entry<String, Object> param : this.toMap((name, value) -> true).entrySet()) {
            logOutput.nl().append((CharSequence)param.getKey()).append((CharSequence)"=");
            Object paramValue = param.getValue();
            if (paramValue == this) {
                logOutput.append((CharSequence)("this QueryScope (" + paramValue.getClass().getName() + ":" + System.identityHashCode(paramValue) + ")"));
                continue;
            }
            if (paramValue instanceof LogOutputAppendable) {
                logOutput.append((LogOutputAppendable)paramValue);
                continue;
            }
            logOutput.append((CharSequence)Objects.toString(paramValue));
        }
        return logOutput.nl().append('}');
    }

    @FunctionalInterface
    public static interface ParamFilter<T> {
        public boolean accept(String var1, T var2);
    }

    public static class MissingVariableException
    extends RuntimeException {
        public MissingVariableException(String message, Throwable cause) {
            super(message, cause);
        }

        public MissingVariableException(String message) {
            super(message);
        }

        private MissingVariableException(Throwable cause) {
            super(cause);
        }
    }
}

