/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.context;

import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.context.QueryScopeParam;
import io.deephaven.engine.liveness.LivenessArtifact;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.updategraph.DynamicNode;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandaloneQueryScope
extends LivenessArtifact
implements QueryScope {
    private final Map<String, ValueRetriever<?>> valueRetrievers = new KeyedObjectHashMap((KeyedObjectKey)new ValueRetrieverNameKey());

    @Override
    public Set<String> getParamNames() {
        return new HashSet<String>(this.valueRetrievers.keySet());
    }

    @Override
    public boolean hasParamName(String name) {
        return this.valueRetrievers.containsKey(name);
    }

    @Override
    public <T> QueryScopeParam<T> createParam(String name) throws QueryScope.MissingVariableException {
        ValueRetriever<?> valueRetriever = this.valueRetrievers.get(name);
        if (valueRetriever == null) {
            throw new QueryScope.MissingVariableException("Missing variable " + name);
        }
        return valueRetriever.createParam();
    }

    @Override
    public <T> T readParamValue(String name) throws QueryScope.MissingVariableException {
        ValueRetriever<?> valueRetriever = this.valueRetrievers.get(name);
        if (valueRetriever == null) {
            throw new QueryScope.MissingVariableException("Missing variable " + name);
        }
        return (T)valueRetriever.getValue();
    }

    @Override
    public <T> T readParamValue(String name, T defaultValue) {
        ValueRetriever<?> valueRetriever = this.valueRetrievers.get(name);
        if (valueRetriever == null) {
            return defaultValue;
        }
        return (T)valueRetriever.getValue();
    }

    @Override
    public <T> void putParam(String name, T value) {
        T oldValue;
        ValueRetriever<T> oldValueRetriever;
        if (value instanceof LivenessReferent && DynamicNode.notDynamicOrIsRefreshing(value)) {
            this.manage((LivenessReferent)value);
        }
        if ((oldValueRetriever = this.valueRetrievers.put(name, new ValueRetriever<T>(name, value))) != null && (oldValue = oldValueRetriever.getValue()) instanceof LivenessReferent && DynamicNode.notDynamicOrIsRefreshing(oldValue)) {
            this.unmanage((LivenessReferent)oldValue);
        }
    }

    @Override
    public Map<String, Object> toMap(@NotNull QueryScope.ParamFilter<Object> filter) {
        return this.toMapInternal(null, filter);
    }

    @Override
    public <T> Map<String, T> toMap(@NotNull Function<Object, T> valueMapper, @NotNull QueryScope.ParamFilter<T> filter) {
        return this.toMapInternal(valueMapper, filter);
    }

    private <T> Map<String, T> toMapInternal(@Nullable Function<Object, T> valueMapper, @NotNull QueryScope.ParamFilter<T> filter) {
        HashMap result = new HashMap();
        for (Map.Entry<String, ValueRetriever<?>> entry : this.valueRetrievers.entrySet()) {
            String name = entry.getKey();
            ValueRetriever<?> valueRetriever = entry.getValue();
            Object value = valueRetriever.getValue();
            if (valueMapper != null) {
                value = valueMapper.apply(value);
            }
            if (!filter.accept(name, value)) continue;
            result.put(name, value);
        }
        return result;
    }

    private static class ValueRetrieverNameKey
    extends KeyedObjectKey.Basic<String, ValueRetriever<?>> {
        private ValueRetrieverNameKey() {
        }

        public String getKey(ValueRetriever valueRetriever) {
            return valueRetriever.getName();
        }
    }

    private static class ValueRetriever<T> {
        protected final T value;
        private final String name;

        protected ValueRetriever(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public T getValue() {
            return this.value;
        }

        public QueryScopeParam<T> createParam() {
            return new QueryScopeParam<T>(this.getName(), this.getValue());
        }
    }
}

