/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TCharArrayList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.list.array.TShortArrayList;
import gnu.trove.set.hash.TByteHashSet;
import gnu.trove.set.hash.TCharHashSet;
import gnu.trove.set.hash.TDoubleHashSet;
import gnu.trove.set.hash.TFloatHashSet;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import gnu.trove.set.hash.TShortHashSet;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfChar;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.util.QueryConstants;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.CharVectorDirect;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorDirect;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class Basic {
    public static <T> T nullValueFor(Class<T> clazz) {
        if (clazz == Byte.class) {
            return (T)QueryConstants.NULL_BYTE_BOXED;
        }
        if (clazz == Character.class) {
            return (T)QueryConstants.NULL_CHAR_BOXED;
        }
        if (clazz == Short.class) {
            return (T)QueryConstants.NULL_SHORT_BOXED;
        }
        if (clazz == Integer.class) {
            return (T)QueryConstants.NULL_INT_BOXED;
        }
        if (clazz == Float.class) {
            return (T)QueryConstants.NULL_FLOAT_BOXED;
        }
        if (clazz == Long.class) {
            return (T)QueryConstants.NULL_LONG_BOXED;
        }
        if (clazz == Double.class) {
            return (T)QueryConstants.NULL_DOUBLE_BOXED;
        }
        return null;
    }

    public static <T> boolean isNull(T value) {
        return value == null || value instanceof Byte && (Byte)value == -128 || value instanceof Character && ((Character)value).charValue() == '\uffff' || value instanceof Short && (Short)value == Short.MIN_VALUE || value instanceof Integer && (Integer)value == Integer.MIN_VALUE || value instanceof Float && ((Float)value).floatValue() == -3.4028235E38f || value instanceof Long && (Long)value == Long.MIN_VALUE || value instanceof Double && (Double)value == -1.7976931348623157E308;
    }

    public static <T> T replaceIfNull(T value, T replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static <T> T[] replaceIfNull(T[] values, T replacement) {
        T[] result = Arrays.copyOf(values, values.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = Basic.replaceIfNull(result[i], replacement);
        }
        return result;
    }

    public static <T> T[] replaceIfNull(ObjectVector<T> values, T replacement) {
        Object[] result = values.copyToArray();
        for (int i = 0; i < result.length; ++i) {
            result[i] = Basic.replaceIfNull(result[i], replacement);
        }
        return result;
    }

    public static <T> long len(T[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long len(LongSizedDataStructure values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.size();
    }

    @SafeVarargs
    public static <T> long countObj(T ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countObj(new ObjectVectorDirect((Object[])values));
    }

    public static <T> long countObj(ObjectVector<T> values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Object c = vi.next();
                if (Basic.isNull(c)) continue;
                ++count;
            }
        }
        return count;
    }

    @SafeVarargs
    public static <T> T lastObj(T ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return values[values.length - 1];
    }

    public static <T> T lastObj(ObjectVector<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (T)values.get(values.size() - 1L);
    }

    @SafeVarargs
    public static <T> T firstObj(T ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public static <T> T firstObj(ObjectVector<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (T)values.get(0L);
    }

    @SafeVarargs
    public static <T> T nthObj(long index, T ... values) {
        if (values == null || index < 0L || index >= (long)values.length) {
            return null;
        }
        return values[(int)index];
    }

    public static <T> T nthObj(long index, ObjectVector<T> values) {
        if (values == null || index < 0L || index >= values.size()) {
            return null;
        }
        return (T)values.get(index);
    }

    public static <T> T[] arrayObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    @SafeVarargs
    public static <T> ObjectVector<T> vecObj(T ... values) {
        if (values == null) {
            return null;
        }
        return new ObjectVectorDirect((Object[])values);
    }

    public static <T extends Comparable<? super T>> boolean inRange(T testedValue, T lowInclusiveValue, T highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue.compareTo(lowInclusiveValue) >= 0 && testedValue.compareTo(highInclusiveValue) <= 0;
    }

    @SafeVarargs
    public static <T> boolean inObj(T testedValue, T ... possibleValues) {
        return Basic.inObj(testedValue, new ObjectVectorDirect((Object[])possibleValues));
    }

    public static <T> boolean inObj(T testedValue, ObjectVector<T> possibleValues) {
        boolean testedIsNull = Basic.isNull(testedValue);
        try (CloseableIterator vi = possibleValues.iterator();){
            while (vi.hasNext()) {
                Object possibleValue = vi.next();
                boolean possibleIsNull = Basic.isNull(possibleValue);
                if (testedIsNull != possibleIsNull || !testedIsNull && !testedValue.equals(possibleValue)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static <T extends Comparable<? super T>> long countDistinctObj(ObjectVector<T> values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinctObj(values, false);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> long countDistinctObj(T ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinctObj(new ObjectVectorDirect((Object[])values), false);
    }

    public static <T extends Comparable<? super T>> long countDistinctObj(T[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinctObj(new ObjectVectorDirect((Object[])values), countNull);
    }

    public static <T extends Comparable<? super T>> long countDistinctObj(ObjectVector<T> values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && Basic.isNull((Comparable)values.get(0L)) ? 0L : 1L;
        }
        THashSet keys = new THashSet();
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Comparable v = (Comparable)vi.next();
                keys.add((Object)v);
            }
        }
        if (!countNull) {
            keys.remove(null);
            keys.remove((Object)QueryConstants.NULL_BOOLEAN);
            keys.remove((Object)QueryConstants.NULL_CHAR_BOXED);
            keys.remove((Object)QueryConstants.NULL_BYTE_BOXED);
            keys.remove((Object)QueryConstants.NULL_SHORT_BOXED);
            keys.remove((Object)QueryConstants.NULL_INT_BOXED);
            keys.remove((Object)QueryConstants.NULL_LONG_BOXED);
            keys.remove((Object)QueryConstants.NULL_FLOAT_BOXED);
            keys.remove((Object)QueryConstants.NULL_DOUBLE_BOXED);
        }
        return keys.size();
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T[] distinctObj(T ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinctObj((ObjectVector)new ObjectVectorDirect((Object[])values), (boolean)false);
    }

    public static <T extends Comparable<? super T>> T[] distinctObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }
        return Basic.distinctObj(values, (boolean)false);
    }

    public static <T extends Comparable<? super T>> T[] distinctObj(T[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        return Basic.distinctObj((ObjectVector)new ObjectVectorDirect((Object[])values), (boolean)includeNull);
    }

    public static <T extends Comparable<? super T>> T[] distinctObj(ObjectVector<T> values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        Comparable[] empty = (Comparable[])Array.newInstance(values.getComponentType(), 0);
        if (n == 0L) {
            return empty;
        }
        if (n == 1L) {
            return !includeNull && Basic.isNull((Comparable)values.get(0L)) ? empty : (Comparable[])values.copyToArray();
        }
        ArrayList<Comparable> orderedList = new ArrayList<Comparable>();
        THashSet counts = new THashSet();
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Comparable val = (Comparable)vi.next();
                if (!includeNull && Basic.isNull(val) || !counts.add((Object)val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray(empty);
    }

    public static <T> T[] repeat(T value, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size: size=" + size);
        }
        Object[] array = (Object[])Array.newInstance(value.getClass(), size);
        for (int i = 0; i < size; ++i) {
            array[i] = value;
        }
        return array;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] ... values) {
        int n = 0;
        for (T[] v : values) {
            if (v == null) continue;
            n += v.length;
        }
        Object[] result = (Object[])Array.newInstance(values.getClass().getComponentType().getComponentType(), n);
        int idx = 0;
        for (T[] v : values) {
            if (v == null) continue;
            for (T t : v) {
                result[idx] = t;
                ++idx;
            }
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] concat(ObjectVector<T> ... values) {
        if (values.length == 0) {
            return (Object[])Array.newInstance(Object.class, 0);
        }
        int n = 0;
        ObjectVector<T> nonNullValues = null;
        for (ObjectVector<T> v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
            nonNullValues = v;
        }
        Object[] result = (Object[])Array.newInstance(nonNullValues == null ? Object.class : nonNullValues.getComponentType(), n);
        int idx = 0;
        for (ObjectVector<T> v : values) {
            if (v == null) continue;
            try (CloseableIterator vi = v.iterator();){
                while (vi.hasNext()) {
                    Object vv;
                    result[idx] = vv = vi.next();
                    ++idx;
                }
            }
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] reverseObj(T ... values) {
        if (values == null) {
            return null;
        }
        Object[] result = Arrays.copyOf(values, values.length);
        ArrayUtils.reverse((Object[])result);
        return result;
    }

    public static <T> T[] reverseObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }
        Object[] result = values.copyToArray();
        ArrayUtils.reverse((Object[])result);
        return result;
    }

    @SafeVarargs
    public static <T> long firstIndexOfObj(T val, T ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOfObj(val, new ObjectVectorDirect((Object[])values));
    }

    public static <T> long firstIndexOfObj(T val, ObjectVector<T> values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        boolean isNullVal = Basic.isNull(val);
        long i = 0L;
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Object c = vi.next();
                boolean isnullc = Basic.isNull(c);
                if (isnullc && isNullVal || !isnullc && c.equals(val)) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static <T> T ifelseObj(Boolean condition, T trueCase, T falseCase) {
        if (condition == null) {
            return null;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static <T> T[] ifelseObj(ObjectVector<Boolean> condition, ObjectVector<T> trueCase, ObjectVector<T> falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        if (!trueCase.getComponentType().equals(falseCase.getComponentType())) {
            throw new IllegalArgumentException("Input vectors have different element types. trueCase=" + trueCase.getComponentType() + " falseCase=" + falseCase.getComponentType());
        }
        Object[] result = (Object[])Array.newInstance(trueCase.getComponentType(), n_c);
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseableIterator ti = trueCase.iterator();
             CloseableIterator fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                Object t = ti.next();
                Object f = fi.next();
                result[i] = c == null ? null : (c != false ? t : f);
                ++i;
            }
        }
        return result;
    }

    public static <T> T[] ifelseObj(Boolean[] condition, T[] trueCase, T[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelseObj((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), new ObjectVectorDirect((Object[])trueCase), new ObjectVectorDirect((Object[])falseCase));
    }

    public static <T> T[] ifelseObj(ObjectVector<Boolean> condition, T trueCase, T falseCase) {
        T typeToUse;
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        T t = typeToUse = trueCase != null ? trueCase : falseCase;
        if (typeToUse == null) {
            throw new IllegalArgumentException("trueCase and falseCase are null.  Can not resolve a return type.");
        }
        if (trueCase != null && falseCase != null && trueCase.getClass() != falseCase.getClass()) {
            throw new IllegalArgumentException("Inputs have different types. trueCase=" + trueCase.getClass() + " falseCase=" + falseCase.getClass());
        }
        Object[] result = (Object[])Array.newInstance(typeToUse.getClass(), n_c);
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? null : (c != false ? trueCase : falseCase);
                ++i;
            }
        }
        return result;
    }

    public static <T> T[] ifelseObj(Boolean[] condition, T trueCase, T falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelseObj((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    @SafeVarargs
    public static <T> T[] forwardFillObj(T ... values) {
        if (values == null) {
            return null;
        }
        T[] result = Arrays.copyOf(values, values.length);
        Object lastGood = null;
        for (int ii = 0; ii < result.length; ++ii) {
            if (!Basic.isNull(result[ii])) {
                lastGood = result[ii];
            }
            result[ii] = lastGood;
        }
        return result;
    }

    public static <T> T[] forwardFillObj(ObjectVector<T> values) {
        if (values == null) {
            return null;
        }
        Object[] result = values.copyToArray();
        Object lastGood = null;
        for (int ii = 0; ii < result.length; ++ii) {
            if (!Basic.isNull(result[ii])) {
                lastGood = result[ii];
            }
            result[ii] = lastGood;
        }
        return result;
    }

    public static boolean isNull(char value) {
        return value == '\uffff';
    }

    public static char[] unbox(Character ... values) {
        if (values == null) {
            return null;
        }
        char[] result = new char[values.length];
        for (int i = 0; i < values.length; ++i) {
            Character v = values[i];
            result[i] = v == null || Basic.isNull(v.charValue()) ? 65535 : v.charValue();
        }
        return result;
    }

    public static char replaceIfNull(char value, char replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static char[] replaceIfNull(char[] values, char replacement) {
        return Basic.replaceIfNull((CharVector)new CharVectorDirect(values), replacement);
    }

    public static char[] replaceIfNull(CharVector values, char replacement) {
        int n = values.intSize("replaceIfNull");
        char[] result = new char[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char v = vi.nextChar();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(char[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(char ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((CharVector)new CharVectorDirect(values));
    }

    public static long count(CharVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char v = vi.nextChar();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static char last(CharVector values) {
        if (values == null) {
            return '\uffff';
        }
        long n = values.size();
        if (n == 0L) {
            return '\uffff';
        }
        return values.get(n - 1L);
    }

    public static char last(char ... values) {
        if (values == null) {
            return '\uffff';
        }
        return Basic.last(Basic.vec(values));
    }

    public static char first(CharVector values) {
        if (values == null || values.isEmpty()) {
            return '\uffff';
        }
        return values.get(0L);
    }

    public static char first(char ... values) {
        if (values == null) {
            return '\uffff';
        }
        return Basic.first(Basic.vec(values));
    }

    public static char nth(long index, CharVector values) {
        if (index < 0L || index >= values.size()) {
            return '\uffff';
        }
        return values.get(index);
    }

    public static char nth(long index, char ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static char[] array(CharVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static CharVector vec(char ... values) {
        return new CharVectorDirect(values);
    }

    public static boolean inRange(char testedValue, char lowInclusiveValue, char highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(char testedValues, char ... possibleValues) {
        for (char possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(char ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((CharVector)new CharVectorDirect(values));
    }

    public static long countDistinct(CharVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(char[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((CharVector)new CharVectorDirect(values), countNull);
    }

    public static long countDistinct(CharVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == '\uffff' ? 0L : 1L;
        }
        TCharHashSet keys = new TCharHashSet();
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char v = vi.nextChar();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove('\uffff');
        }
        return keys.size();
    }

    public static char[] distinct(char ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((CharVector)new CharVectorDirect(values));
    }

    public static char[] distinct(CharVector values) {
        return Basic.distinct(values, false);
    }

    public static char[] distinct(char[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new char[0];
        }
        if (values.length == 1) {
            char[] cArray;
            if (!includeNull && values[0] == '\uffff') {
                cArray = new char[]{};
            } else {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = values[0];
            }
            return cArray;
        }
        TCharArrayList orderedList = new TCharArrayList();
        TCharHashSet counts = new TCharHashSet();
        for (char val : values) {
            if (!includeNull && val == '\uffff' || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static char[] distinct(CharVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new char[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == '\uffff' ? new char[]{} : values.copyToArray();
        }
        TCharArrayList orderedList = new TCharArrayList();
        TCharHashSet counts = new TCharHashSet();
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char val = vi.nextChar();
                if (!includeNull && val == '\uffff' || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static char[] repeat(char value, int size) {
        if (size < 0) {
            return new char[0];
        }
        char[] result = new char[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static char[] enlist(char ... values) {
        if (values == null) {
            return new char[0];
        }
        return values;
    }

    public static char[] concat(char[] ... values) {
        if (values == null) {
            return new char[0];
        }
        return Basic.concat((CharVector[])Arrays.stream(values).map(e -> e == null ? null : new CharVectorDirect(e)).toArray(CharVector[]::new));
    }

    public static char[] concat(CharVector ... values) {
        if (values == null) {
            return new char[0];
        }
        int n = 0;
        for (CharVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        char[] result = new char[n];
        int idx = 0;
        for (CharVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfChar vi = v.iterator();){
                while (vi.hasNext()) {
                    char vv;
                    result[idx] = vv = vi.nextChar();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static char[] reverse(char ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((CharVector)new CharVectorDirect(values));
    }

    public static char[] reverse(CharVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        char[] result = new char[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char v;
                result[i] = v = vi.nextChar();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(char val, char ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (CharVector)new CharVectorDirect(values));
    }

    public static long firstIndexOf(char val, CharVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char c = vi.nextChar();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static char ifelse(Boolean condition, char trueCase, char falseCase) {
        if (condition == null) {
            return '\uffff';
        }
        return condition != false ? trueCase : falseCase;
    }

    public static char[] ifelse(ObjectVector<Boolean> condition, CharVector trueCase, CharVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        char[] result = new char[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfChar ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfChar fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                char t = ti.nextChar();
                char f = fi.nextChar();
                result[i] = c == null ? 65535 : (c != false ? (int)t : (int)f);
                ++i;
            }
        }
        return result;
    }

    public static char[] ifelse(Boolean[] condition, char[] trueCase, char[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (CharVector)new CharVectorDirect(trueCase), (CharVector)new CharVectorDirect(falseCase));
    }

    public static char[] ifelse(ObjectVector<Boolean> condition, char trueCase, char falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        char[] result = new char[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? 65535 : (c != false ? (int)trueCase : (int)falseCase);
                ++i;
            }
        }
        return result;
    }

    public static char[] ifelse(Boolean[] condition, char trueCase, char falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static char[] forwardFill(char ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((CharVector)new CharVectorDirect(values));
    }

    public static char[] forwardFill(CharVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        char[] result = new char[n];
        int ii = 0;
        int lastGood = 65535;
        try (CloseablePrimitiveIteratorOfChar vi = values.iterator();){
            while (vi.hasNext()) {
                char v = vi.nextChar();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }

    public static boolean isNull(byte value) {
        return value == -128;
    }

    public static byte[] unbox(Byte ... values) {
        if (values == null) {
            return null;
        }
        byte[] result = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            Byte v = values[i];
            result[i] = v == null || Basic.isNull(v) ? -128 : v;
        }
        return result;
    }

    public static byte replaceIfNull(byte value, byte replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static byte[] replaceIfNull(byte[] values, byte replacement) {
        return Basic.replaceIfNull((ByteVector)new ByteVectorDirect(values), replacement);
    }

    public static byte[] replaceIfNull(ByteVector values, byte replacement) {
        int n = values.intSize("replaceIfNull");
        byte[] result = new byte[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(byte[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((ByteVector)new ByteVectorDirect(values));
    }

    public static long count(ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static byte last(ByteVector values) {
        if (values == null) {
            return -128;
        }
        long n = values.size();
        if (n == 0L) {
            return -128;
        }
        return values.get(n - 1L);
    }

    public static byte last(byte ... values) {
        if (values == null) {
            return -128;
        }
        return Basic.last(Basic.vec(values));
    }

    public static byte first(ByteVector values) {
        if (values == null || values.isEmpty()) {
            return -128;
        }
        return values.get(0L);
    }

    public static byte first(byte ... values) {
        if (values == null) {
            return -128;
        }
        return Basic.first(Basic.vec(values));
    }

    public static byte nth(long index, ByteVector values) {
        if (index < 0L || index >= values.size()) {
            return -128;
        }
        return values.get(index);
    }

    public static byte nth(long index, byte ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static byte[] array(ByteVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static ByteVector vec(byte ... values) {
        return new ByteVectorDirect(values);
    }

    public static boolean inRange(byte testedValue, byte lowInclusiveValue, byte highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(byte testedValues, byte ... possibleValues) {
        for (byte possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((ByteVector)new ByteVectorDirect(values));
    }

    public static long countDistinct(ByteVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(byte[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((ByteVector)new ByteVectorDirect(values), countNull);
    }

    public static long countDistinct(ByteVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == -128 ? 0L : 1L;
        }
        TByteHashSet keys = new TByteHashSet();
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove((byte)-128);
        }
        return keys.size();
    }

    public static byte[] distinct(byte ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] distinct(ByteVector values) {
        return Basic.distinct(values, false);
    }

    public static byte[] distinct(byte[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new byte[0];
        }
        if (values.length == 1) {
            byte[] byArray;
            if (!includeNull && values[0] == -128) {
                byArray = new byte[]{};
            } else {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = values[0];
            }
            return byArray;
        }
        TByteArrayList orderedList = new TByteArrayList();
        TByteHashSet counts = new TByteHashSet();
        for (byte val : values) {
            if (!includeNull && val == -128 || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static byte[] distinct(ByteVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new byte[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == -128 ? new byte[]{} : values.copyToArray();
        }
        TByteArrayList orderedList = new TByteArrayList();
        TByteHashSet counts = new TByteHashSet();
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte val = vi.nextByte();
                if (!includeNull && val == -128 || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static byte[] repeat(byte value, int size) {
        if (size < 0) {
            return new byte[0];
        }
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static byte[] enlist(byte ... values) {
        if (values == null) {
            return new byte[0];
        }
        return values;
    }

    public static byte[] concat(byte[] ... values) {
        if (values == null) {
            return new byte[0];
        }
        return Basic.concat((ByteVector[])Arrays.stream(values).map(e -> e == null ? null : new ByteVectorDirect(e)).toArray(ByteVector[]::new));
    }

    public static byte[] concat(ByteVector ... values) {
        if (values == null) {
            return new byte[0];
        }
        int n = 0;
        for (ByteVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        byte[] result = new byte[n];
        int idx = 0;
        for (ByteVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfByte vi = v.iterator();){
                while (vi.hasNext()) {
                    byte vv;
                    result[idx] = vv = vi.nextByte();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static byte[] reverse(byte ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] reverse(ByteVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        byte[] result = new byte[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v;
                result[i] = v = vi.nextByte();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(byte val, byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (ByteVector)new ByteVectorDirect(values));
    }

    public static long firstIndexOf(byte val, ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static byte ifelse(Boolean condition, byte trueCase, byte falseCase) {
        if (condition == null) {
            return -128;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static byte[] ifelse(ObjectVector<Boolean> condition, ByteVector trueCase, ByteVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        byte[] result = new byte[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfByte ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfByte fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                byte t = ti.nextByte();
                byte f = fi.nextByte();
                result[i] = c == null ? -128 : (c != false ? (int)t : (int)f);
                ++i;
            }
        }
        return result;
    }

    public static byte[] ifelse(Boolean[] condition, byte[] trueCase, byte[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (ByteVector)new ByteVectorDirect(trueCase), (ByteVector)new ByteVectorDirect(falseCase));
    }

    public static byte[] ifelse(ObjectVector<Boolean> condition, byte trueCase, byte falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        byte[] result = new byte[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? -128 : (c != false ? (int)trueCase : (int)falseCase);
                ++i;
            }
        }
        return result;
    }

    public static byte[] ifelse(Boolean[] condition, byte trueCase, byte falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static byte[] forwardFill(byte ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] forwardFill(ByteVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        byte[] result = new byte[n];
        int ii = 0;
        int lastGood = -128;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }

    public static boolean isNull(short value) {
        return value == Short.MIN_VALUE;
    }

    public static short[] unbox(Short ... values) {
        if (values == null) {
            return null;
        }
        short[] result = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            Short v = values[i];
            result[i] = v == null || Basic.isNull(v) ? Short.MIN_VALUE : v;
        }
        return result;
    }

    public static short replaceIfNull(short value, short replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static short[] replaceIfNull(short[] values, short replacement) {
        return Basic.replaceIfNull((ShortVector)new ShortVectorDirect(values), replacement);
    }

    public static short[] replaceIfNull(ShortVector values, short replacement) {
        int n = values.intSize("replaceIfNull");
        short[] result = new short[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(short[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((ShortVector)new ShortVectorDirect(values));
    }

    public static long count(ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static short last(ShortVector values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return Short.MIN_VALUE;
        }
        return values.get(n - 1L);
    }

    public static short last(short ... values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        return Basic.last(Basic.vec(values));
    }

    public static short first(ShortVector values) {
        if (values == null || values.isEmpty()) {
            return Short.MIN_VALUE;
        }
        return values.get(0L);
    }

    public static short first(short ... values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        return Basic.first(Basic.vec(values));
    }

    public static short nth(long index, ShortVector values) {
        if (index < 0L || index >= values.size()) {
            return Short.MIN_VALUE;
        }
        return values.get(index);
    }

    public static short nth(long index, short ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static short[] array(ShortVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static ShortVector vec(short ... values) {
        return new ShortVectorDirect(values);
    }

    public static boolean inRange(short testedValue, short lowInclusiveValue, short highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(short testedValues, short ... possibleValues) {
        for (short possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((ShortVector)new ShortVectorDirect(values));
    }

    public static long countDistinct(ShortVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(short[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((ShortVector)new ShortVectorDirect(values), countNull);
    }

    public static long countDistinct(ShortVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == Short.MIN_VALUE ? 0L : 1L;
        }
        TShortHashSet keys = new TShortHashSet();
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove((short)Short.MIN_VALUE);
        }
        return keys.size();
    }

    public static short[] distinct(short ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] distinct(ShortVector values) {
        return Basic.distinct(values, false);
    }

    public static short[] distinct(short[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new short[0];
        }
        if (values.length == 1) {
            short[] sArray;
            if (!includeNull && values[0] == Short.MIN_VALUE) {
                sArray = new short[]{};
            } else {
                short[] sArray2 = new short[1];
                sArray = sArray2;
                sArray2[0] = values[0];
            }
            return sArray;
        }
        TShortArrayList orderedList = new TShortArrayList();
        TShortHashSet counts = new TShortHashSet();
        for (short val : values) {
            if (!includeNull && val == Short.MIN_VALUE || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static short[] distinct(ShortVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new short[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == Short.MIN_VALUE ? new short[]{} : values.copyToArray();
        }
        TShortArrayList orderedList = new TShortArrayList();
        TShortHashSet counts = new TShortHashSet();
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short val = vi.nextShort();
                if (!includeNull && val == Short.MIN_VALUE || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static short[] repeat(short value, int size) {
        if (size < 0) {
            return new short[0];
        }
        short[] result = new short[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static short[] enlist(short ... values) {
        if (values == null) {
            return new short[0];
        }
        return values;
    }

    public static short[] concat(short[] ... values) {
        if (values == null) {
            return new short[0];
        }
        return Basic.concat((ShortVector[])Arrays.stream(values).map(e -> e == null ? null : new ShortVectorDirect(e)).toArray(ShortVector[]::new));
    }

    public static short[] concat(ShortVector ... values) {
        if (values == null) {
            return new short[0];
        }
        int n = 0;
        for (ShortVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        short[] result = new short[n];
        int idx = 0;
        for (ShortVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfShort vi = v.iterator();){
                while (vi.hasNext()) {
                    short vv;
                    result[idx] = vv = vi.nextShort();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static short[] reverse(short ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] reverse(ShortVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        short[] result = new short[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v;
                result[i] = v = vi.nextShort();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(short val, short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (ShortVector)new ShortVectorDirect(values));
    }

    public static long firstIndexOf(short val, ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static short ifelse(Boolean condition, short trueCase, short falseCase) {
        if (condition == null) {
            return Short.MIN_VALUE;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static short[] ifelse(ObjectVector<Boolean> condition, ShortVector trueCase, ShortVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        short[] result = new short[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfShort ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfShort fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                short t = ti.nextShort();
                short f = fi.nextShort();
                result[i] = c == null ? Short.MIN_VALUE : (c != false ? (int)t : (int)f);
                ++i;
            }
        }
        return result;
    }

    public static short[] ifelse(Boolean[] condition, short[] trueCase, short[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (ShortVector)new ShortVectorDirect(trueCase), (ShortVector)new ShortVectorDirect(falseCase));
    }

    public static short[] ifelse(ObjectVector<Boolean> condition, short trueCase, short falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        short[] result = new short[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? Short.MIN_VALUE : (c != false ? (int)trueCase : (int)falseCase);
                ++i;
            }
        }
        return result;
    }

    public static short[] ifelse(Boolean[] condition, short trueCase, short falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static short[] forwardFill(short ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] forwardFill(ShortVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        short[] result = new short[n];
        int ii = 0;
        int lastGood = Short.MIN_VALUE;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }

    public static boolean isNull(int value) {
        return value == Integer.MIN_VALUE;
    }

    public static int[] unbox(Integer ... values) {
        if (values == null) {
            return null;
        }
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer v = values[i];
            result[i] = v == null || Basic.isNull(v) ? Integer.MIN_VALUE : v;
        }
        return result;
    }

    public static int replaceIfNull(int value, int replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static int[] replaceIfNull(int[] values, int replacement) {
        return Basic.replaceIfNull((IntVector)new IntVectorDirect(values), replacement);
    }

    public static int[] replaceIfNull(IntVector values, int replacement) {
        int n = values.intSize("replaceIfNull");
        int[] result = new int[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(int[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((IntVector)new IntVectorDirect(values));
    }

    public static long count(IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static int last(IntVector values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return Integer.MIN_VALUE;
        }
        return values.get(n - 1L);
    }

    public static int last(int ... values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return Basic.last(Basic.vec(values));
    }

    public static int first(IntVector values) {
        if (values == null || values.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        return values.get(0L);
    }

    public static int first(int ... values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return Basic.first(Basic.vec(values));
    }

    public static int nth(long index, IntVector values) {
        if (index < 0L || index >= values.size()) {
            return Integer.MIN_VALUE;
        }
        return values.get(index);
    }

    public static int nth(long index, int ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static int[] array(IntVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static IntVector vec(int ... values) {
        return new IntVectorDirect(values);
    }

    public static boolean inRange(int testedValue, int lowInclusiveValue, int highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(int testedValues, int ... possibleValues) {
        for (int possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((IntVector)new IntVectorDirect(values));
    }

    public static long countDistinct(IntVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(int[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((IntVector)new IntVectorDirect(values), countNull);
    }

    public static long countDistinct(IntVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == Integer.MIN_VALUE ? 0L : 1L;
        }
        TIntHashSet keys = new TIntHashSet();
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove(Integer.MIN_VALUE);
        }
        return keys.size();
    }

    public static int[] distinct(int ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((IntVector)new IntVectorDirect(values));
    }

    public static int[] distinct(IntVector values) {
        return Basic.distinct(values, false);
    }

    public static int[] distinct(int[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new int[0];
        }
        if (values.length == 1) {
            int[] nArray;
            if (!includeNull && values[0] == Integer.MIN_VALUE) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = values[0];
            }
            return nArray;
        }
        TIntArrayList orderedList = new TIntArrayList();
        TIntHashSet counts = new TIntHashSet();
        for (int val : values) {
            if (!includeNull && val == Integer.MIN_VALUE || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static int[] distinct(IntVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new int[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == Integer.MIN_VALUE ? new int[]{} : values.copyToArray();
        }
        TIntArrayList orderedList = new TIntArrayList();
        TIntHashSet counts = new TIntHashSet();
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int val = vi.nextInt();
                if (!includeNull && val == Integer.MIN_VALUE || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static int[] repeat(int value, int size) {
        if (size < 0) {
            return new int[0];
        }
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static int[] enlist(int ... values) {
        if (values == null) {
            return new int[0];
        }
        return values;
    }

    public static int[] concat(int[] ... values) {
        if (values == null) {
            return new int[0];
        }
        return Basic.concat((IntVector[])Arrays.stream(values).map(e -> e == null ? null : new IntVectorDirect(e)).toArray(IntVector[]::new));
    }

    public static int[] concat(IntVector ... values) {
        if (values == null) {
            return new int[0];
        }
        int n = 0;
        for (IntVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        int[] result = new int[n];
        int idx = 0;
        for (IntVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfInt vi = v.iterator();){
                while (vi.hasNext()) {
                    int vv;
                    result[idx] = vv = vi.nextInt();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static int[] reverse(int ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((IntVector)new IntVectorDirect(values));
    }

    public static int[] reverse(IntVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        int[] result = new int[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v;
                result[i] = v = vi.nextInt();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(int val, int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (IntVector)new IntVectorDirect(values));
    }

    public static long firstIndexOf(int val, IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static int ifelse(Boolean condition, int trueCase, int falseCase) {
        if (condition == null) {
            return Integer.MIN_VALUE;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static int[] ifelse(ObjectVector<Boolean> condition, IntVector trueCase, IntVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        int[] result = new int[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfInt ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfInt fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                int t = ti.nextInt();
                int f = fi.nextInt();
                result[i] = c == null ? Integer.MIN_VALUE : (c != false ? t : f);
                ++i;
            }
        }
        return result;
    }

    public static int[] ifelse(Boolean[] condition, int[] trueCase, int[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (IntVector)new IntVectorDirect(trueCase), (IntVector)new IntVectorDirect(falseCase));
    }

    public static int[] ifelse(ObjectVector<Boolean> condition, int trueCase, int falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int[] result = new int[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? Integer.MIN_VALUE : (c != false ? trueCase : falseCase);
                ++i;
            }
        }
        return result;
    }

    public static int[] ifelse(Boolean[] condition, int trueCase, int falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static int[] forwardFill(int ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((IntVector)new IntVectorDirect(values));
    }

    public static int[] forwardFill(IntVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        int[] result = new int[n];
        int ii = 0;
        int lastGood = Integer.MIN_VALUE;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }

    public static boolean isNull(long value) {
        return value == Long.MIN_VALUE;
    }

    public static long[] unbox(Long ... values) {
        if (values == null) {
            return null;
        }
        long[] result = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long v = values[i];
            result[i] = v == null || Basic.isNull(v) ? Long.MIN_VALUE : v;
        }
        return result;
    }

    public static long replaceIfNull(long value, long replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static long[] replaceIfNull(long[] values, long replacement) {
        return Basic.replaceIfNull((LongVector)new LongVectorDirect(values), replacement);
    }

    public static long[] replaceIfNull(LongVector values, long replacement) {
        int n = values.intSize("replaceIfNull");
        long[] result = new long[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(long[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((LongVector)new LongVectorDirect(values));
    }

    public static long count(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static long last(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return Long.MIN_VALUE;
        }
        return values.get(n - 1L);
    }

    public static long last(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.last(Basic.vec(values));
    }

    public static long first(LongVector values) {
        if (values == null || values.isEmpty()) {
            return Long.MIN_VALUE;
        }
        return values.get(0L);
    }

    public static long first(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.first(Basic.vec(values));
    }

    public static long nth(long index, LongVector values) {
        if (index < 0L || index >= values.size()) {
            return Long.MIN_VALUE;
        }
        return values.get(index);
    }

    public static long nth(long index, long ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static long[] array(LongVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static LongVector vec(long ... values) {
        return new LongVectorDirect(values);
    }

    public static boolean inRange(long testedValue, long lowInclusiveValue, long highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(long testedValues, long ... possibleValues) {
        for (long possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((LongVector)new LongVectorDirect(values));
    }

    public static long countDistinct(LongVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(long[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((LongVector)new LongVectorDirect(values), countNull);
    }

    public static long countDistinct(LongVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == Long.MIN_VALUE ? 0L : 1L;
        }
        TLongHashSet keys = new TLongHashSet();
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove(Long.MIN_VALUE);
        }
        return keys.size();
    }

    public static long[] distinct(long ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((LongVector)new LongVectorDirect(values));
    }

    public static long[] distinct(LongVector values) {
        return Basic.distinct(values, false);
    }

    public static long[] distinct(long[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new long[0];
        }
        if (values.length == 1) {
            long[] lArray;
            if (!includeNull && values[0] == Long.MIN_VALUE) {
                lArray = new long[]{};
            } else {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = values[0];
            }
            return lArray;
        }
        TLongArrayList orderedList = new TLongArrayList();
        TLongHashSet counts = new TLongHashSet();
        for (long val : values) {
            if (!includeNull && val == Long.MIN_VALUE || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static long[] distinct(LongVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new long[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == Long.MIN_VALUE ? new long[]{} : values.copyToArray();
        }
        TLongArrayList orderedList = new TLongArrayList();
        TLongHashSet counts = new TLongHashSet();
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long val = vi.nextLong();
                if (!includeNull && val == Long.MIN_VALUE || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static long[] repeat(long value, int size) {
        if (size < 0) {
            return new long[0];
        }
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static long[] enlist(long ... values) {
        if (values == null) {
            return new long[0];
        }
        return values;
    }

    public static long[] concat(long[] ... values) {
        if (values == null) {
            return new long[0];
        }
        return Basic.concat((LongVector[])Arrays.stream(values).map(e -> e == null ? null : new LongVectorDirect(e)).toArray(LongVector[]::new));
    }

    public static long[] concat(LongVector ... values) {
        if (values == null) {
            return new long[0];
        }
        int n = 0;
        for (LongVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        long[] result = new long[n];
        int idx = 0;
        for (LongVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfLong vi = v.iterator();){
                while (vi.hasNext()) {
                    long vv;
                    result[idx] = vv = vi.nextLong();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static long[] reverse(long ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((LongVector)new LongVectorDirect(values));
    }

    public static long[] reverse(LongVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        long[] result = new long[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v;
                result[i] = v = vi.nextLong();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(long val, long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (LongVector)new LongVectorDirect(values));
    }

    public static long firstIndexOf(long val, LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static long ifelse(Boolean condition, long trueCase, long falseCase) {
        if (condition == null) {
            return Long.MIN_VALUE;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static long[] ifelse(ObjectVector<Boolean> condition, LongVector trueCase, LongVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        long[] result = new long[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfLong ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfLong fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                long t = ti.nextLong();
                long f = fi.nextLong();
                result[i] = c == null ? Long.MIN_VALUE : (c != false ? t : f);
                ++i;
            }
        }
        return result;
    }

    public static long[] ifelse(Boolean[] condition, long[] trueCase, long[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (LongVector)new LongVectorDirect(trueCase), (LongVector)new LongVectorDirect(falseCase));
    }

    public static long[] ifelse(ObjectVector<Boolean> condition, long trueCase, long falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        long[] result = new long[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? Long.MIN_VALUE : (c != false ? trueCase : falseCase);
                ++i;
            }
        }
        return result;
    }

    public static long[] ifelse(Boolean[] condition, long trueCase, long falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static long[] forwardFill(long ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((LongVector)new LongVectorDirect(values));
    }

    public static long[] forwardFill(LongVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        long[] result = new long[n];
        int ii = 0;
        long lastGood = Long.MIN_VALUE;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }

    public static boolean isNull(float value) {
        return value == -3.4028235E38f;
    }

    public static float[] unbox(Float ... values) {
        if (values == null) {
            return null;
        }
        float[] result = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            Float v = values[i];
            result[i] = v == null || Basic.isNull(v.floatValue()) ? -3.4028235E38f : v.floatValue();
        }
        return result;
    }

    public static float replaceIfNull(float value, float replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static float[] replaceIfNull(float[] values, float replacement) {
        return Basic.replaceIfNull((FloatVector)new FloatVectorDirect(values), replacement);
    }

    public static float[] replaceIfNull(FloatVector values, float replacement) {
        int n = values.intSize("replaceIfNull");
        float[] result = new float[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(float[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((FloatVector)new FloatVectorDirect(values));
    }

    public static long count(FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static float last(FloatVector values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        long n = values.size();
        if (n == 0L) {
            return -3.4028235E38f;
        }
        return values.get(n - 1L);
    }

    public static float last(float ... values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        return Basic.last(Basic.vec(values));
    }

    public static float first(FloatVector values) {
        if (values == null || values.isEmpty()) {
            return -3.4028235E38f;
        }
        return values.get(0L);
    }

    public static float first(float ... values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        return Basic.first(Basic.vec(values));
    }

    public static float nth(long index, FloatVector values) {
        if (index < 0L || index >= values.size()) {
            return -3.4028235E38f;
        }
        return values.get(index);
    }

    public static float nth(long index, float ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static float[] array(FloatVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static FloatVector vec(float ... values) {
        return new FloatVectorDirect(values);
    }

    public static boolean inRange(float testedValue, float lowInclusiveValue, float highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(float testedValues, float ... possibleValues) {
        for (float possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((FloatVector)new FloatVectorDirect(values));
    }

    public static long countDistinct(FloatVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(float[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((FloatVector)new FloatVectorDirect(values), countNull);
    }

    public static long countDistinct(FloatVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == -3.4028235E38f ? 0L : 1L;
        }
        TFloatHashSet keys = new TFloatHashSet();
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove(-3.4028235E38f);
        }
        return keys.size();
    }

    public static float[] distinct(float ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] distinct(FloatVector values) {
        return Basic.distinct(values, false);
    }

    public static float[] distinct(float[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new float[0];
        }
        if (values.length == 1) {
            float[] fArray;
            if (!includeNull && values[0] == -3.4028235E38f) {
                fArray = new float[]{};
            } else {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = values[0];
            }
            return fArray;
        }
        TFloatArrayList orderedList = new TFloatArrayList();
        TFloatHashSet counts = new TFloatHashSet();
        for (float val : values) {
            if (!includeNull && val == -3.4028235E38f || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static float[] distinct(FloatVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new float[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == -3.4028235E38f ? new float[]{} : values.copyToArray();
        }
        TFloatArrayList orderedList = new TFloatArrayList();
        TFloatHashSet counts = new TFloatHashSet();
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float val = vi.nextFloat();
                if (!includeNull && val == -3.4028235E38f || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static float[] repeat(float value, int size) {
        if (size < 0) {
            return new float[0];
        }
        float[] result = new float[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static float[] enlist(float ... values) {
        if (values == null) {
            return new float[0];
        }
        return values;
    }

    public static float[] concat(float[] ... values) {
        if (values == null) {
            return new float[0];
        }
        return Basic.concat((FloatVector[])Arrays.stream(values).map(e -> e == null ? null : new FloatVectorDirect(e)).toArray(FloatVector[]::new));
    }

    public static float[] concat(FloatVector ... values) {
        if (values == null) {
            return new float[0];
        }
        int n = 0;
        for (FloatVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        float[] result = new float[n];
        int idx = 0;
        for (FloatVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfFloat vi = v.iterator();){
                while (vi.hasNext()) {
                    float vv;
                    result[idx] = vv = vi.nextFloat();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static float[] reverse(float ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] reverse(FloatVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        float[] result = new float[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v;
                result[i] = v = vi.nextFloat();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(float val, float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (FloatVector)new FloatVectorDirect(values));
    }

    public static long firstIndexOf(float val, FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static float ifelse(Boolean condition, float trueCase, float falseCase) {
        if (condition == null) {
            return -3.4028235E38f;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static float[] ifelse(ObjectVector<Boolean> condition, FloatVector trueCase, FloatVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        float[] result = new float[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfFloat ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfFloat fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                float t = ti.nextFloat();
                float f = fi.nextFloat();
                result[i] = c == null ? -3.4028235E38f : (c != false ? t : f);
                ++i;
            }
        }
        return result;
    }

    public static float[] ifelse(Boolean[] condition, float[] trueCase, float[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (FloatVector)new FloatVectorDirect(trueCase), (FloatVector)new FloatVectorDirect(falseCase));
    }

    public static float[] ifelse(ObjectVector<Boolean> condition, float trueCase, float falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        float[] result = new float[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? -3.4028235E38f : (c != false ? trueCase : falseCase);
                ++i;
            }
        }
        return result;
    }

    public static float[] ifelse(Boolean[] condition, float trueCase, float falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static float[] forwardFill(float ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] forwardFill(FloatVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        float[] result = new float[n];
        int ii = 0;
        float lastGood = -3.4028235E38f;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }

    public static boolean isNull(double value) {
        return value == -1.7976931348623157E308;
    }

    public static double[] unbox(Double ... values) {
        if (values == null) {
            return null;
        }
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            Double v = values[i];
            result[i] = v == null || Basic.isNull(v) ? -1.7976931348623157E308 : v;
        }
        return result;
    }

    public static double replaceIfNull(double value, double replacement) {
        if (Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static double[] replaceIfNull(double[] values, double replacement) {
        return Basic.replaceIfNull((DoubleVector)new DoubleVectorDirect(values), replacement);
    }

    public static double[] replaceIfNull(DoubleVector values, double replacement) {
        int n = values.intSize("replaceIfNull");
        double[] result = new double[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Basic.replaceIfNull(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long len(double[] values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return values.length;
    }

    public static long count(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.count((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long count(DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                if (Basic.isNull(v)) continue;
                ++count;
            }
        }
        return count;
    }

    public static double last(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n == 0L) {
            return -1.7976931348623157E308;
        }
        return values.get(n - 1L);
    }

    public static double last(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Basic.last(Basic.vec(values));
    }

    public static double first(DoubleVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        return values.get(0L);
    }

    public static double first(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Basic.first(Basic.vec(values));
    }

    public static double nth(long index, DoubleVector values) {
        if (index < 0L || index >= values.size()) {
            return -1.7976931348623157E308;
        }
        return values.get(index);
    }

    public static double nth(long index, double ... values) {
        return Basic.nth(index, Basic.vec(values));
    }

    public static double[] array(DoubleVector values) {
        if (values == null) {
            return null;
        }
        return values.copyToArray();
    }

    public static DoubleVector vec(double ... values) {
        return new DoubleVectorDirect(values);
    }

    public static boolean inRange(double testedValue, double lowInclusiveValue, double highInclusiveValue) {
        if (Basic.isNull(testedValue)) {
            return false;
        }
        return testedValue >= lowInclusiveValue && testedValue <= highInclusiveValue;
    }

    public static boolean in(double testedValues, double ... possibleValues) {
        for (double possibleValue : possibleValues) {
            if (testedValues != possibleValue) continue;
            return true;
        }
        return false;
    }

    public static long countDistinct(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long countDistinct(DoubleVector values) {
        return Basic.countDistinct(values, false);
    }

    public static long countDistinct(double[] values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.countDistinct((DoubleVector)new DoubleVectorDirect(values), countNull);
    }

    public static long countDistinct(DoubleVector values, boolean countNull) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long n = values.size();
        if (n == 0L) {
            return 0L;
        }
        if (n == 1L) {
            return !countNull && values.get(0L) == -1.7976931348623157E308 ? 0L : 1L;
        }
        TDoubleHashSet keys = new TDoubleHashSet();
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                keys.add(v);
            }
        }
        if (!countNull) {
            keys.remove(-1.7976931348623157E308);
        }
        return keys.size();
    }

    public static double[] distinct(double ... values) {
        if (values == null) {
            return null;
        }
        return Basic.distinct((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] distinct(DoubleVector values) {
        return Basic.distinct(values, false);
    }

    public static double[] distinct(double[] values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new double[0];
        }
        if (values.length == 1) {
            double[] dArray;
            if (!includeNull && values[0] == -1.7976931348623157E308) {
                dArray = new double[]{};
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = values[0];
            }
            return dArray;
        }
        TDoubleArrayList orderedList = new TDoubleArrayList();
        TDoubleHashSet counts = new TDoubleHashSet();
        for (double val : values) {
            if (!includeNull && val == -1.7976931348623157E308 || !counts.add(val)) continue;
            orderedList.add(val);
        }
        return orderedList.toArray();
    }

    public static double[] distinct(DoubleVector values, boolean includeNull) {
        if (values == null) {
            return null;
        }
        long n = values.size();
        if (n == 0L) {
            return new double[0];
        }
        if (n == 1L) {
            return !includeNull && values.get(0L) == -1.7976931348623157E308 ? new double[]{} : values.copyToArray();
        }
        TDoubleArrayList orderedList = new TDoubleArrayList();
        TDoubleHashSet counts = new TDoubleHashSet();
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double val = vi.nextDouble();
                if (!includeNull && val == -1.7976931348623157E308 || !counts.add(val)) continue;
                orderedList.add(val);
            }
        }
        return orderedList.toArray();
    }

    public static double[] repeat(double value, int size) {
        if (size < 0) {
            return new double[0];
        }
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static double[] enlist(double ... values) {
        if (values == null) {
            return new double[0];
        }
        return values;
    }

    public static double[] concat(double[] ... values) {
        if (values == null) {
            return new double[0];
        }
        return Basic.concat((DoubleVector[])Arrays.stream(values).map(e -> e == null ? null : new DoubleVectorDirect(e)).toArray(DoubleVector[]::new));
    }

    public static double[] concat(DoubleVector ... values) {
        if (values == null) {
            return new double[0];
        }
        int n = 0;
        for (DoubleVector v : values) {
            if (v == null) continue;
            n = (int)((long)n + v.size());
        }
        double[] result = new double[n];
        int idx = 0;
        for (DoubleVector v : values) {
            if (v == null) continue;
            try (CloseablePrimitiveIteratorOfDouble vi = v.iterator();){
                while (vi.hasNext()) {
                    double vv;
                    result[idx] = vv = vi.nextDouble();
                    ++idx;
                }
            }
        }
        return result;
    }

    public static double[] reverse(double ... values) {
        if (values == null) {
            return null;
        }
        return Basic.reverse((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] reverse(DoubleVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("reverse");
        double[] result = new double[n];
        int i = n - 1;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v;
                result[i] = v = vi.nextDouble();
                --i;
            }
        }
        return result;
    }

    public static long firstIndexOf(double val, double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Basic.firstIndexOf(val, (DoubleVector)new DoubleVectorDirect(values));
    }

    public static long firstIndexOf(double val, DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long i = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (c == val) {
                    long l = i;
                    return l;
                }
                ++i;
            }
        }
        return Long.MIN_VALUE;
    }

    public static double ifelse(Boolean condition, double trueCase, double falseCase) {
        if (condition == null) {
            return -1.7976931348623157E308;
        }
        return condition != false ? trueCase : falseCase;
    }

    public static double[] ifelse(ObjectVector<Boolean> condition, DoubleVector trueCase, DoubleVector falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        int n_t = trueCase.intSize("trueCase");
        int n_f = falseCase.intSize("falseCase");
        if (n_c != n_t || n_c != n_f) {
            throw new IllegalArgumentException("Inconsistent input sizes: condition=" + n_c + " trueCase=" + n_t + " falseCase=" + n_f);
        }
        double[] result = new double[n_c];
        int i = 0;
        try (CloseableIterator ci = condition.iterator();
             CloseablePrimitiveIteratorOfDouble ti = trueCase.iterator();
             CloseablePrimitiveIteratorOfDouble fi = falseCase.iterator();){
            while (ci.hasNext()) {
                Boolean c = (Boolean)ci.next();
                double t = ti.nextDouble();
                double f = fi.nextDouble();
                result[i] = c == null ? -1.7976931348623157E308 : (c != false ? t : f);
                ++i;
            }
        }
        return result;
    }

    public static double[] ifelse(Boolean[] condition, double[] trueCase, double[] falseCase) {
        if (condition == null || trueCase == null || falseCase == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), (DoubleVector)new DoubleVectorDirect(trueCase), (DoubleVector)new DoubleVectorDirect(falseCase));
    }

    public static double[] ifelse(ObjectVector<Boolean> condition, double trueCase, double falseCase) {
        if (condition == null) {
            return null;
        }
        int n_c = condition.intSize("condition");
        double[] result = new double[n_c];
        int i = 0;
        try (CloseableIterator vi = condition.iterator();){
            while (vi.hasNext()) {
                Boolean c = (Boolean)vi.next();
                result[i] = c == null ? -1.7976931348623157E308 : (c != false ? trueCase : falseCase);
                ++i;
            }
        }
        return result;
    }

    public static double[] ifelse(Boolean[] condition, double trueCase, double falseCase) {
        if (condition == null) {
            return null;
        }
        return Basic.ifelse((ObjectVector<Boolean>)new ObjectVectorDirect((Object[])condition), trueCase, falseCase);
    }

    public static double[] forwardFill(double ... values) {
        if (values == null) {
            return null;
        }
        return Basic.forwardFill((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] forwardFill(DoubleVector values) {
        if (values == null) {
            return null;
        }
        int n = values.intSize("forwardFill");
        double[] result = new double[n];
        int ii = 0;
        double lastGood = -1.7976931348623157E308;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                if (!Basic.isNull(v)) {
                    lastGood = v;
                }
                result[ii] = lastGood;
                ++ii;
            }
        }
        return result;
    }
}

