/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.Basic;
import io.deephaven.function.BinSearchAlgo;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.CharVectorDirect;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorDirect;

public class BinSearch {
    public static <T extends Comparable<? super T>> int binSearchIndex(T[] values, T key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex(new ObjectVectorDirect((Object[])values), key, choiceWhenEquals);
    }

    public static <T extends Comparable<? super T>> int binSearchIndex(ObjectVector<T> values, T key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static <T extends Comparable<? super T>> int rawBinSearchIndex(T[] values, T key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex(new ObjectVectorDirect((Object[])values), key, choiceWhenEquals);
    }

    public static <T extends Comparable<? super T>> int rawBinSearchIndex(ObjectVector<T> values, T key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == null) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, LongSizedDataStructure.intSize((String)"rawBinSearchIndex", (long)values.size()), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, LongSizedDataStructure.intSize((String)"rawBinSearchIndex", (long)values.size()), key);
    }

    private static <T extends Comparable<? super T>> int binarySearch0(ObjectVector<T> array, int fromIndex, int toIndex, T key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable midVal = (Comparable)array.get((long)mid);
            if (midVal == null) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            int cmp = key.compareTo((Comparable)midVal);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static <T extends Comparable<? super T>> int binarySearch0Modified(ObjectVector<T> array, int fromIndex, int toIndex, T key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        Comparable lowVal = (Comparable)array.get((long)low);
        Comparable highVal = (Comparable)array.get((long)high);
        boolean isNullLow = Basic.isNull(lowVal);
        boolean isNullHigh = Basic.isNull(highVal);
        if (highestOrLowest) {
            if (high >= low && !isNullHigh && key.compareTo((Comparable)highVal) == 0) {
                return high;
            }
        } else if (low <= high && !isNullLow && key.compareTo((Comparable)lowVal) == 0) {
            return low;
        }
        if (isNullLow) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (isNullHigh) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            Comparable midVal = (Comparable)array.get((long)mid);
            if (Basic.isNull(midVal)) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            int cmp = key.compareTo((Comparable)midVal);
            if (cmp > 0) {
                low = mid + 1;
                if (low > high || highestOrLowest || key.compareTo((Object)array.get((long)low)) != 0) continue;
                return low;
            }
            if (cmp < 0) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key.compareTo((Object)array.get((long)high)) != 0) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(char[] values, char key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((CharVector)new CharVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(CharVector values, char key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(char[] values, char key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((CharVector)new CharVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(CharVector values, char key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == '\uffff') {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(CharVector array, int fromIndex, int toIndex, char key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = array.get((long)mid);
            if (midVal == '\uffff') {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(CharVector array, int fromIndex, int toIndex, char key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        char lowVal = array.get((long)low);
        char highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != '\uffff') {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != '\uffff') {
            return low;
        }
        if (lowVal == '\uffff') {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == '\uffff') {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            char midVal = array.get((long)mid);
            if (midVal == '\uffff') {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(byte[] values, byte key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((ByteVector)new ByteVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(ByteVector values, byte key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(byte[] values, byte key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((ByteVector)new ByteVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(ByteVector values, byte key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == -128) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(ByteVector array, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = array.get((long)mid);
            if (midVal == -128) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(ByteVector array, int fromIndex, int toIndex, byte key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        byte lowVal = array.get((long)low);
        byte highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != -128) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != -128) {
            return low;
        }
        if (lowVal == -128) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == -128) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            byte midVal = array.get((long)mid);
            if (midVal == -128) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(short[] values, short key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((ShortVector)new ShortVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(ShortVector values, short key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(short[] values, short key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((ShortVector)new ShortVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(ShortVector values, short key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == Short.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(ShortVector array, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = array.get((long)mid);
            if (midVal == Short.MIN_VALUE) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(ShortVector array, int fromIndex, int toIndex, short key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        short lowVal = array.get((long)low);
        short highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != Short.MIN_VALUE) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != Short.MIN_VALUE) {
            return low;
        }
        if (lowVal == Short.MIN_VALUE) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == Short.MIN_VALUE) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            short midVal = array.get((long)mid);
            if (midVal == Short.MIN_VALUE) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(int[] values, int key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((IntVector)new IntVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(IntVector values, int key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(int[] values, int key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((IntVector)new IntVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(IntVector values, int key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(IntVector array, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = array.get((long)mid);
            if (midVal == Integer.MIN_VALUE) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(IntVector array, int fromIndex, int toIndex, int key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        int lowVal = array.get((long)low);
        int highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != Integer.MIN_VALUE) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != Integer.MIN_VALUE) {
            return low;
        }
        if (lowVal == Integer.MIN_VALUE) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == Integer.MIN_VALUE) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            int midVal = array.get((long)mid);
            if (midVal == Integer.MIN_VALUE) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(long[] values, long key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((LongVector)new LongVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(LongVector values, long key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(long[] values, long key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((LongVector)new LongVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(LongVector values, long key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == Long.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(LongVector array, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array.get((long)mid);
            if (midVal == Long.MIN_VALUE) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(LongVector array, int fromIndex, int toIndex, long key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        long lowVal = array.get((long)low);
        long highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != Long.MIN_VALUE) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != Long.MIN_VALUE) {
            return low;
        }
        if (lowVal == Long.MIN_VALUE) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == Long.MIN_VALUE) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            long midVal = array.get((long)mid);
            if (midVal == Long.MIN_VALUE) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(float[] values, float key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((FloatVector)new FloatVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(FloatVector values, float key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(float[] values, float key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((FloatVector)new FloatVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(FloatVector values, float key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == -3.4028235E38f) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(FloatVector array, int fromIndex, int toIndex, float key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midVal = array.get((long)mid);
            if (midVal == -3.4028235E38f) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(FloatVector array, int fromIndex, int toIndex, float key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        float lowVal = array.get((long)low);
        float highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != -3.4028235E38f) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != -3.4028235E38f) {
            return low;
        }
        if (lowVal == -3.4028235E38f) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == -3.4028235E38f) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            float midVal = array.get((long)mid);
            if (midVal == -3.4028235E38f) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }

    public static int binSearchIndex(double[] values, double key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.binSearchIndex((DoubleVector)new DoubleVectorDirect(values), key, choiceWhenEquals);
    }

    public static int binSearchIndex(DoubleVector values, double key, BinSearchAlgo choiceWhenEquals) {
        int index = BinSearch.rawBinSearchIndex(values, key, choiceWhenEquals);
        if (index == Integer.MIN_VALUE) {
            return index;
        }
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    public static int rawBinSearchIndex(double[] values, double key, BinSearchAlgo choiceWhenEquals) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return BinSearch.rawBinSearchIndex((DoubleVector)new DoubleVectorDirect(values), key, choiceWhenEquals);
    }

    public static int rawBinSearchIndex(DoubleVector values, double key, BinSearchAlgo choiceWhenEquals) {
        if (values == null || key == -1.7976931348623157E308) {
            return Integer.MIN_VALUE;
        }
        if (choiceWhenEquals != BinSearchAlgo.BS_ANY) {
            return BinSearch.binarySearch0Modified(values, 0, values.intSize("rawBinSearchIndex"), key, choiceWhenEquals == BinSearchAlgo.BS_HIGHEST);
        }
        return BinSearch.binarySearch0(values, 0, values.intSize("rawBinSearchIndex"), key);
    }

    private static int binarySearch0(DoubleVector array, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVal = array.get((long)mid);
            if (midVal == -1.7976931348623157E308) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0Modified(DoubleVector array, int fromIndex, int toIndex, double key, boolean highestOrLowest) {
        if (array.isEmpty()) {
            return -1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        double lowVal = array.get((long)low);
        double highVal = array.get((long)high);
        if (highestOrLowest) {
            if (high >= low && key == highVal && highVal != -1.7976931348623157E308) {
                return high;
            }
        } else if (low <= high && key == lowVal && lowVal != -1.7976931348623157E308) {
            return low;
        }
        if (lowVal == -1.7976931348623157E308) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        if (highVal == -1.7976931348623157E308) {
            throw new RuntimeException("Can't have a null in the array!");
        }
        while (low <= high) {
            int mid = highestOrLowest ? low + high + 1 >>> 1 : low + high >>> 1;
            double midVal = array.get((long)mid);
            if (midVal == -1.7976931348623157E308) {
                throw new RuntimeException("Can't have a null in the array!");
            }
            if (key > midVal) {
                low = mid + 1;
                if (low > high || highestOrLowest || key != array.get((long)low)) continue;
                return low;
            }
            if (key < midVal) {
                high = mid - 1;
                if (high < low || !highestOrLowest || key != array.get((long)high)) continue;
                return high;
            }
            if (highestOrLowest) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return -(low + 1);
    }
}

