/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorDirect;

public class Cast {
    private static boolean isLosingPrecisionDouble(long v) {
        return v > 0x20000000000000L || v < -9007199254740992L;
    }

    public static int castInt(byte value, boolean checkFidelity) {
        return value == -128 ? Integer.MIN_VALUE : (int)value;
    }

    public static int castInt(short value, boolean checkFidelity) {
        return value == Short.MIN_VALUE ? Integer.MIN_VALUE : (int)value;
    }

    public static int castInt(int value, boolean checkFidelity) {
        return value;
    }

    public static int castInt(long value, boolean checkFidelity) {
        if (value == Long.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (checkFidelity && value == Integer.MIN_VALUE) {
            throw new CastDoesNotPreserveValue("Casting is not supported because the value, " + value + ", represents the null integer sentinel and therefore cannot be cast to int.");
        }
        if (checkFidelity && (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE)) {
            throw new CastDoesNotPreserveValue("Casting is not supported because the value, " + value + ", overflows while being cast to int.");
        }
        return (int)value;
    }

    public static long castLong(byte value, boolean checkFidelity) {
        return value == -128 ? Long.MIN_VALUE : (long)value;
    }

    public static long castLong(short value, boolean checkFidelity) {
        return value == Short.MIN_VALUE ? Long.MIN_VALUE : (long)value;
    }

    public static long castLong(int value, boolean checkFidelity) {
        return value == Integer.MIN_VALUE ? Long.MIN_VALUE : (long)value;
    }

    public static long castLong(long value, boolean checkFidelity) {
        return value;
    }

    public static double castDouble(byte value, boolean checkFidelity) {
        return value == -128 ? -1.7976931348623157E308 : (double)value;
    }

    public static double castDouble(short value, boolean checkFidelity) {
        return value == Short.MIN_VALUE ? -1.7976931348623157E308 : (double)value;
    }

    public static double castDouble(int value, boolean checkFidelity) {
        return value == Integer.MIN_VALUE ? -1.7976931348623157E308 : (double)value;
    }

    public static double castDouble(long value, boolean checkFidelity) {
        if (value == Long.MIN_VALUE) {
            return -1.7976931348623157E308;
        }
        if (checkFidelity && Cast.isLosingPrecisionDouble(value)) {
            throw new CastDoesNotPreserveValue("Casting is not supported because the value, " + value + ", overflows while being cast to double.");
        }
        return value;
    }

    public static double castDouble(float value, boolean checkFidelity) {
        return value == -3.4028235E38f ? -1.7976931348623157E308 : (double)value;
    }

    public static double castDouble(double value, boolean checkFidelity) {
        return value;
    }

    public static int castInt(byte value) {
        return Cast.castInt(value, true);
    }

    public static int[] castInt(byte ... values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(byte[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castInt((ByteVector)new ByteVectorDirect(values), checkFidelity);
    }

    public static int[] castInt(ByteVector values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(ByteVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Cast.castInt(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static long castLong(byte value) {
        return Cast.castLong(value, true);
    }

    public static long[] castLong(byte ... values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(byte[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castLong((ByteVector)new ByteVectorDirect(values), checkFidelity);
    }

    public static long[] castLong(ByteVector values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(ByteVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Cast.castLong(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static double castDouble(byte value) {
        return Cast.castDouble(value, true);
    }

    public static double[] castDouble(byte ... values) {
        return values == null ? null : Cast.castDouble((ByteVector)new ByteVectorDirect(values));
    }

    public static double[] castDouble(byte[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castDouble((ByteVector)new ByteVectorDirect(values), checkFidelity);
    }

    public static double[] castDouble(ByteVector values) {
        return Cast.castDouble(values, true);
    }

    public static double[] castDouble(ByteVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Cast.castDouble(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static int castInt(short value) {
        return Cast.castInt(value, true);
    }

    public static int[] castInt(short ... values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(short[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castInt((ShortVector)new ShortVectorDirect(values), checkFidelity);
    }

    public static int[] castInt(ShortVector values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(ShortVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Cast.castInt(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static long castLong(short value) {
        return Cast.castLong(value, true);
    }

    public static long[] castLong(short ... values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(short[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castLong((ShortVector)new ShortVectorDirect(values), checkFidelity);
    }

    public static long[] castLong(ShortVector values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(ShortVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Cast.castLong(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static double castDouble(short value) {
        return Cast.castDouble(value, true);
    }

    public static double[] castDouble(short ... values) {
        return values == null ? null : Cast.castDouble((ShortVector)new ShortVectorDirect(values));
    }

    public static double[] castDouble(short[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castDouble((ShortVector)new ShortVectorDirect(values), checkFidelity);
    }

    public static double[] castDouble(ShortVector values) {
        return Cast.castDouble(values, true);
    }

    public static double[] castDouble(ShortVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Cast.castDouble(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static int castInt(int value) {
        return Cast.castInt(value, true);
    }

    public static int[] castInt(int ... values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(int[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castInt((IntVector)new IntVectorDirect(values), checkFidelity);
    }

    public static int[] castInt(IntVector values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(IntVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Cast.castInt(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static long castLong(int value) {
        return Cast.castLong(value, true);
    }

    public static long[] castLong(int ... values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(int[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castLong((IntVector)new IntVectorDirect(values), checkFidelity);
    }

    public static long[] castLong(IntVector values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(IntVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Cast.castLong(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static double castDouble(int value) {
        return Cast.castDouble(value, true);
    }

    public static double[] castDouble(int ... values) {
        return values == null ? null : Cast.castDouble((IntVector)new IntVectorDirect(values));
    }

    public static double[] castDouble(int[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castDouble((IntVector)new IntVectorDirect(values), checkFidelity);
    }

    public static double[] castDouble(IntVector values) {
        return Cast.castDouble(values, true);
    }

    public static double[] castDouble(IntVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Cast.castDouble(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static int castInt(long value) {
        return Cast.castInt(value, true);
    }

    public static int[] castInt(long ... values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(long[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castInt((LongVector)new LongVectorDirect(values), checkFidelity);
    }

    public static int[] castInt(LongVector values) {
        return Cast.castInt(values, true);
    }

    public static int[] castInt(LongVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castInt");
        int[] result = new int[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Cast.castInt(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static long castLong(long value) {
        return Cast.castLong(value, true);
    }

    public static long[] castLong(long ... values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(long[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castLong((LongVector)new LongVectorDirect(values), checkFidelity);
    }

    public static long[] castLong(LongVector values) {
        return Cast.castLong(values, true);
    }

    public static long[] castLong(LongVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castLong");
        long[] result = new long[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Cast.castLong(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static double castDouble(long value) {
        return Cast.castDouble(value, true);
    }

    public static double[] castDouble(long ... values) {
        return values == null ? null : Cast.castDouble((LongVector)new LongVectorDirect(values));
    }

    public static double[] castDouble(long[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castDouble((LongVector)new LongVectorDirect(values), checkFidelity);
    }

    public static double[] castDouble(LongVector values) {
        return Cast.castDouble(values, true);
    }

    public static double[] castDouble(LongVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Cast.castDouble(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static double castDouble(float value) {
        return Cast.castDouble(value, true);
    }

    public static double[] castDouble(float ... values) {
        return values == null ? null : Cast.castDouble((FloatVector)new FloatVectorDirect(values));
    }

    public static double[] castDouble(float[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castDouble((FloatVector)new FloatVectorDirect(values), checkFidelity);
    }

    public static double[] castDouble(FloatVector values) {
        return Cast.castDouble(values, true);
    }

    public static double[] castDouble(FloatVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Cast.castDouble(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static double castDouble(double value) {
        return Cast.castDouble(value, true);
    }

    public static double[] castDouble(double ... values) {
        return values == null ? null : Cast.castDouble((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] castDouble(double[] values, boolean checkFidelity) {
        return values == null ? null : Cast.castDouble((DoubleVector)new DoubleVectorDirect(values), checkFidelity);
    }

    public static double[] castDouble(DoubleVector values) {
        return Cast.castDouble(values, true);
    }

    public static double[] castDouble(DoubleVector values, boolean checkFidelity) {
        if (values == null) {
            return null;
        }
        int s = values.intSize("castDouble");
        double[] result = new double[s];
        int i = 0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Cast.castDouble(v, checkFidelity);
                ++i;
            }
        }
        return result;
    }

    public static class CastDoesNotPreserveValue
    extends UnsupportedOperationException {
        private static final long serialVersionUID = 5998276378465685974L;

        public CastDoesNotPreserveValue(String message) {
            super(message);
        }
    }
}

