/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.vector.ObjectVector;

public class Logic {
    public static Boolean and(Boolean ... values) {
        for (Boolean b : values) {
            if (b.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(boolean ... values) {
        for (boolean b : values) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(ObjectVector<Boolean> values) {
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Boolean b = (Boolean)vi.next();
                if (b.booleanValue()) continue;
                Boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static Boolean and(Boolean[] values, Boolean nullValue) {
        for (Boolean b : values) {
            Boolean bl = b = b == null ? nullValue : b;
            if (b.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(ObjectVector<Boolean> values, Boolean nullValue) {
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Boolean b2;
                Boolean b = (Boolean)vi.next();
                Boolean bl = b2 = b == null ? nullValue : b;
                if (b2.booleanValue()) continue;
                Boolean bl2 = false;
                return bl2;
            }
        }
        return true;
    }

    public static Boolean or(Boolean ... values) {
        for (Boolean b : values) {
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(boolean ... values) {
        for (boolean b : values) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean[] values, Boolean nullValue) {
        for (Boolean b : values) {
            Boolean bl = b = b == null ? nullValue : b;
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Boolean[] not(Boolean ... values) {
        if (values == null) {
            return null;
        }
        Boolean[] result = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : Boolean.valueOf(values[i] == false);
        }
        return result;
    }

    public static Boolean[] not(boolean ... values) {
        if (values == null) {
            return null;
        }
        Boolean[] result = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = !values[i];
        }
        return result;
    }
}

