/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfLong;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfShort;
import io.deephaven.function.Basic;
import io.deephaven.function.Cast;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorDirect;
import java.util.Arrays;

public class Numeric {
    public static <T extends Comparable<T>> T maxObj(ObjectVector<T> values) {
        long idx = Numeric.indexOfMaxObj(values);
        return (T)(idx == Long.MIN_VALUE ? null : (Comparable)values.get(idx));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T maxObj(T ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return Numeric.maxObj(new ObjectVectorDirect((Object[])values));
    }

    public static <T extends Comparable<T>> T minObj(ObjectVector<T> values) {
        long idx = Numeric.indexOfMinObj(values);
        return (T)(idx == Long.MIN_VALUE ? null : (Comparable)values.get(idx));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T minObj(T ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return Numeric.minObj(new ObjectVectorDirect((Object[])values));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> long indexOfMaxObj(T ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMaxObj(new ObjectVectorDirect((Object[])values));
    }

    public static <T extends Comparable<T>> long indexOfMaxObj(ObjectVector<T> values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        Comparable val = null;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Comparable c = (Comparable)vi.next();
                if (!(Basic.isNull(c) || val != null && c.compareTo(val) <= 0)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> long indexOfMinObj(T ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMinObj(new ObjectVectorDirect((Object[])values));
    }

    public static <T extends Comparable<T>> long indexOfMinObj(ObjectVector<T> values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        Comparable val = null;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseableIterator vi = values.iterator();){
            while (vi.hasNext()) {
                Comparable c = (Comparable)vi.next();
                if (!(Basic.isNull(c) || val != null && c.compareTo(val) >= 0)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long countPos(Byte[] values) {
        return Numeric.countPos(Basic.unbox(values));
    }

    public static long countPos(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countPos((ByteVector)new ByteVectorDirect(values));
    }

    public static long countPos(ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Basic.isNull(c) || c <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countNeg(Byte[] values) {
        return Numeric.countNeg(Basic.unbox(values));
    }

    public static long countNeg(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countNeg((ByteVector)new ByteVectorDirect(values));
    }

    public static long countNeg(ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        long n = values.size();
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Basic.isNull(c) || c >= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countZero(Byte[] values) {
        return Numeric.countZero(Basic.unbox(values));
    }

    public static long countZero(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countZero((ByteVector)new ByteVectorDirect(values));
    }

    public static long countZero(ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Basic.isNull(c) || c != 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static double avg(Byte[] values) {
        return Numeric.avg(Basic.unbox(values));
    }

    public static double avg(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.avg((ByteVector)new ByteVectorDirect(values));
    }

    public static double avg(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double absAvg(Byte[] values) {
        return Numeric.absAvg(Basic.unbox(values));
    }

    public static double absAvg(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.absAvg((ByteVector)new ByteVectorDirect(values));
    }

    public static double absAvg(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isInf(c)) {
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)Math.abs(c);
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double var(Byte[] values) {
        return Numeric.var(Basic.unbox(values));
    }

    public static double var(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.var((ByteVector)new ByteVectorDirect(values));
    }

    public static double var(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long count = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                sum2 += (double)c * (double)c;
                ++count;
            }
        }
        if (count <= 1L || Double.isInfinite(sum) || Double.isInfinite(sum2)) {
            return Double.NaN;
        }
        double vs2bar = sum * (sum / (double)count);
        double delta = sum2 - vs2bar;
        double eps = Math.ulp(sum2);
        double rel_eps = delta / eps;
        return Math.abs(rel_eps) > 1.0 ? delta / ((double)count - 1.0) : 0.0;
    }

    public static double wvar(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wvar(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wvar(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ByteVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wvar(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wvar(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ByteVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                short w = wi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wvar(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wvar(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ByteVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                int w = wi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wvar(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wvar(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ByteVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                long w = wi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (long)c);
                sum2 += (double)(w * (long)c * (long)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wvar(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wvar(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ByteVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (float)c);
                sum2 += (double)(w * (float)c * (float)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wvar(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wvar(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ByteVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += w * (double)c;
                sum2 += w * (double)c * (double)c;
                count += w;
                count2 += w * w;
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double std(Byte[] values) {
        return Numeric.std(Basic.unbox(values));
    }

    public static double std(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.std((ByteVector)new ByteVectorDirect(values));
    }

    public static double std(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.var(values);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wstd(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wstd(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wstd(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wstd(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wstd(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wstd(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double ste(Byte[] values) {
        return Numeric.ste(Basic.unbox(values));
    }

    public static double ste(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.ste((ByteVector)new ByteVectorDirect(values));
    }

    public static double ste(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double s = Numeric.std(values);
        long c = Basic.count(values);
        return s == -1.7976931348623157E308 || c == Long.MIN_VALUE ? -1.7976931348623157E308 : s / Math.sqrt(c);
    }

    public static double wste(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wste(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                byte w = wi.nextByte();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wste(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                short w = wi.nextShort();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wste(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                int w = wi.nextInt();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wste(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                long w = wi.nextLong();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wste(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                float w = wi.nextFloat();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wste(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                double w = wi.nextDouble();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += w;
                sumw2 += w * w;
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double tstat(Byte[] values) {
        return Numeric.tstat(Basic.unbox(values));
    }

    public static double tstat(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.tstat((ByteVector)new ByteVectorDirect(values));
    }

    public static double tstat(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.avg(values);
        double s = Numeric.ste(values);
        return a == -1.7976931348623157E308 || s == -1.7976931348623157E308 ? -1.7976931348623157E308 : Numeric.avg(values) / Numeric.ste(values);
    }

    public static double wtstat(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wtstat(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(ByteVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wtstat(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(ByteVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wtstat(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(ByteVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wtstat(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(ByteVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wtstat(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(ByteVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wtstat(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(ByteVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static byte max(ByteVector values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? (byte)-128 : values.get(idx);
    }

    public static byte max(byte ... values) {
        if (values == null) {
            return -128;
        }
        return Numeric.max((ByteVector)new ByteVectorDirect(values));
    }

    public static byte max(Byte[] values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? (byte)-128 : values[LongSizedDataStructure.intSize((String)"max", (long)idx)];
    }

    public static byte min(ByteVector values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? (byte)-128 : values.get(idx);
    }

    public static byte min(byte ... values) {
        if (values == null) {
            return -128;
        }
        return Numeric.min((ByteVector)new ByteVectorDirect(values));
    }

    public static byte min(Byte[] values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? (byte)-128 : values[LongSizedDataStructure.intSize((String)"min", (long)idx)];
    }

    public static long indexOfMax(Byte[] values) {
        return Numeric.indexOfMax(Basic.unbox(values));
    }

    public static long indexOfMax(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMax((ByteVector)new ByteVectorDirect(values));
    }

    public static long indexOfMax(ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        byte val = -127;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (!Basic.isNull(c) && (c > val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long indexOfMin(Byte[] values) {
        return Numeric.indexOfMin(Basic.unbox(values));
    }

    public static long indexOfMin(byte ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMin((ByteVector)new ByteVectorDirect(values));
    }

    public static long indexOfMin(ByteVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        byte val = 127;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (!Basic.isNull(c) && (c < val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static double median(Byte[] values) {
        return Numeric.median(Basic.unbox(values));
    }

    public static double median(byte ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.median((ByteVector)new ByteVectorDirect(values));
    }

    public static double median(ByteVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        int n = values.intSize("median");
        if (n == 0) {
            return Double.NaN;
        }
        byte[] copy = values.copyToArray();
        Arrays.sort(copy);
        if (n % 2 == 0) {
            return 0.5 * (double)(copy[n / 2 - 1] + copy[n / 2]);
        }
        return copy[n / 2];
    }

    public static double percentile(double percentile, byte ... values) {
        if (values == null || values.length == 0) {
            return -1.7976931348623157E308;
        }
        return Numeric.percentile(percentile, (ByteVector)new ByteVectorDirect(values));
    }

    public static double percentile(double percentile, ByteVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }
        int n = values.intSize("percentile");
        byte[] copy = values.copyToArray();
        Arrays.sort(copy);
        int idx = (int)Math.round(percentile * (double)(n - 1));
        return copy[idx];
    }

    public static double cov(byte[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cov(byte[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cov(ByteVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ByteVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(byte[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cor(byte[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cor(ByteVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ByteVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(byte[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cov(byte[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cov(ByteVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ByteVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(byte[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cor(byte[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cor(ByteVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ByteVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(byte[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cov(byte[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cov(ByteVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ByteVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(byte[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cor(byte[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cor(ByteVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ByteVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(byte[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cov(byte[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cov(ByteVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ByteVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((long)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(byte[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cor(byte[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cor(ByteVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ByteVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((long)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(byte[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cov(byte[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cov(ByteVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ByteVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(byte[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cor(byte[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cor(ByteVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ByteVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(byte[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cov(byte[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cov(ByteVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ByteVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(byte[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cor(byte[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ByteVector)new ByteVectorDirect(values0), values1);
    }

    public static double cor(ByteVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ByteVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfByte v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                byte v0 = v0i.nextByte();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += v1;
                sum1Sq += v1 * v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static byte sum(ByteVector values) {
        if (values == null) {
            return -128;
        }
        double sum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (Basic.isNull(c)) continue;
                sum += (double)c;
            }
        }
        return (byte)sum;
    }

    public static byte sum(byte ... values) {
        if (values == null) {
            return -128;
        }
        return Numeric.sum((ByteVector)new ByteVectorDirect(values));
    }

    public static byte product(ByteVector values) {
        if (values == null) {
            return -128;
        }
        byte prod = 1;
        int count = 0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                if (c == 0) {
                    byte by = 0;
                    return by;
                }
                if (Basic.isNull(c)) continue;
                ++count;
                prod = (byte)(prod * c);
            }
        }
        if (count == 0) {
            return -128;
        }
        return prod;
    }

    public static byte product(byte ... values) {
        if (values == null) {
            return -128;
        }
        return Numeric.product((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] cummin(Byte[] values) {
        return Numeric.cummin(Basic.unbox(values));
    }

    public static byte[] cummin(byte ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummin((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] cummin(ByteVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new byte[0];
        }
        int n = values.intSize("cummin");
        byte[] result = new byte[n];
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            result[0] = vi.nextByte();
            int i = 1;
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (byte)Math.min(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static byte[] cummax(Byte[] values) {
        return Numeric.cummax(Basic.unbox(values));
    }

    public static byte[] cummax(byte ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummax((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] cummax(ByteVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new byte[0];
        }
        int n = values.intSize("cummax");
        byte[] result = new byte[n];
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            result[0] = vi.nextByte();
            int i = 1;
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (byte)Math.max(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static byte[] cumsum(Byte[] values) {
        return Numeric.cumsum(Basic.unbox(values));
    }

    public static byte[] cumsum(byte ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumsum((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] cumsum(ByteVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new byte[0];
        }
        int n = values.intSize("cumsum");
        byte[] result = new byte[n];
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            result[0] = vi.nextByte();
            int i = 1;
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (byte)(result[i - 1] + v));
                ++i;
            }
        }
        return result;
    }

    public static byte[] cumprod(Byte[] values) {
        return Numeric.cumprod(Basic.unbox(values));
    }

    public static byte[] cumprod(byte ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumprod((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] cumprod(ByteVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new byte[0];
        }
        int n = values.intSize("cumprod");
        byte[] result = new byte[n];
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();){
            result[0] = vi.nextByte();
            int i = 1;
            while (vi.hasNext()) {
                byte v = vi.nextByte();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (byte)(result[i - 1] * v));
                ++i;
            }
        }
        return result;
    }

    public static byte abs(byte value) {
        if (Basic.isNull(value)) {
            return -128;
        }
        return (byte)Math.abs(value);
    }

    public static double acos(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.acos(value);
    }

    public static double asin(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.asin(value);
    }

    public static double atan(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.atan(value);
    }

    public static double ceil(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.ceil(value);
    }

    public static double cos(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.cos(value);
    }

    public static double exp(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.exp(value);
    }

    public static double floor(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.floor(value);
    }

    public static double log(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.log(value);
    }

    public static double pow(byte a, byte b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(byte a, short b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(byte a, int b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(byte a, long b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(byte a, float b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(byte a, double b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double rint(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.rint(value);
    }

    public static long round(byte value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.round(value);
    }

    public static int signum(byte value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.signum(value);
    }

    public static double sin(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sin(value);
    }

    public static double sqrt(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt(value);
    }

    public static double tan(byte value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.tan(value);
    }

    public static byte lowerBin(byte value, byte interval) {
        if (value == -128 || interval == -128) {
            return -128;
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long d = (long)value / (long)interval;
        long m = (long)value % (long)interval;
        long r = m != 0L && value < 0 ? d - 1L : d;
        return (byte)((long)interval * r);
    }

    public static byte lowerBin(byte value, byte interval, byte offset) {
        if (value == -128 || interval == -128) {
            return -128;
        }
        return (byte)(Numeric.lowerBin((byte)(value - offset), interval) + offset);
    }

    public static byte upperBin(byte value, byte interval) {
        if (value == -128 || interval == -128) {
            return -128;
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long r = (long)value / (long)interval + (long)(value % interval > 0 ? 1 : 0);
        return (byte)((long)interval * r);
    }

    public static byte upperBin(byte value, byte interval, byte offset) {
        if (value == -128 || interval == -128) {
            return -128;
        }
        return (byte)(Numeric.upperBin((byte)(value - offset), interval) + offset);
    }

    public static byte clamp(byte value, byte min, byte max) {
        Require.leq((byte)min, (String)"min", (byte)max, (String)"max");
        if (Basic.isNull(value)) {
            return -128;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double wsum(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wsum(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wsum(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ByteVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(byte[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wavg(byte[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wavg(ByteVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ByteVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wsum(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wsum(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ByteVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(byte[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wavg(byte[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wavg(ByteVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ByteVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wsum(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wsum(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ByteVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(byte[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wavg(byte[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wavg(ByteVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ByteVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wsum(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wsum(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ByteVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((long)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(byte[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wavg(byte[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wavg(ByteVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ByteVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((long)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wsum(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wsum(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ByteVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(byte[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wavg(byte[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wavg(ByteVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ByteVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wsum(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wsum(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ByteVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
            }
            return vsum;
        }
    }

    public static double wavg(byte[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wavg(byte[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ByteVector)new ByteVectorDirect(values), weights);
    }

    public static double wavg(ByteVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ByteVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfByte vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                byte c = vi.nextByte();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
                wsum += w;
            }
            return vsum / wsum;
        }
    }

    public static byte[] sequence(byte start, byte end, byte step) {
        if (step == 0) {
            return new byte[0];
        }
        int n = (end - start) / step;
        if (n < 0) {
            return new byte[0];
        }
        byte[] result = new byte[n + 1];
        for (int i = 0; i <= n; ++i) {
            result[i] = (byte)(start + i * step);
        }
        return result;
    }

    public static boolean isNaN(Byte value) {
        return false;
    }

    public static boolean isNaN(byte value) {
        return false;
    }

    public static boolean isInf(Byte value) {
        return false;
    }

    public static boolean isInf(byte value) {
        return false;
    }

    public static boolean isFinite(Byte value) {
        return !Basic.isNull(value);
    }

    public static boolean isFinite(byte value) {
        return !Basic.isNull(value);
    }

    public static boolean containsNonFinite(Byte[] values) {
        for (Byte v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonFinite(byte ... values) {
        for (byte v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static long countPos(Short[] values) {
        return Numeric.countPos(Basic.unbox(values));
    }

    public static long countPos(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countPos((ShortVector)new ShortVectorDirect(values));
    }

    public static long countPos(ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Basic.isNull(c) || c <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countNeg(Short[] values) {
        return Numeric.countNeg(Basic.unbox(values));
    }

    public static long countNeg(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countNeg((ShortVector)new ShortVectorDirect(values));
    }

    public static long countNeg(ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        long n = values.size();
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Basic.isNull(c) || c >= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countZero(Short[] values) {
        return Numeric.countZero(Basic.unbox(values));
    }

    public static long countZero(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countZero((ShortVector)new ShortVectorDirect(values));
    }

    public static long countZero(ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Basic.isNull(c) || c != 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static double avg(Short[] values) {
        return Numeric.avg(Basic.unbox(values));
    }

    public static double avg(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.avg((ShortVector)new ShortVectorDirect(values));
    }

    public static double avg(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double absAvg(Short[] values) {
        return Numeric.absAvg(Basic.unbox(values));
    }

    public static double absAvg(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.absAvg((ShortVector)new ShortVectorDirect(values));
    }

    public static double absAvg(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isInf(c)) {
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)Math.abs(c);
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double var(Short[] values) {
        return Numeric.var(Basic.unbox(values));
    }

    public static double var(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.var((ShortVector)new ShortVectorDirect(values));
    }

    public static double var(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long count = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                sum2 += (double)c * (double)c;
                ++count;
            }
        }
        if (count <= 1L || Double.isInfinite(sum) || Double.isInfinite(sum2)) {
            return Double.NaN;
        }
        double vs2bar = sum * (sum / (double)count);
        double delta = sum2 - vs2bar;
        double eps = Math.ulp(sum2);
        double rel_eps = delta / eps;
        return Math.abs(rel_eps) > 1.0 ? delta / ((double)count - 1.0) : 0.0;
    }

    public static double wvar(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wvar(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wvar(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ShortVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wvar(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wvar(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ShortVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                short w = wi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wvar(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wvar(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ShortVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                int w = wi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wvar(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wvar(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ShortVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                long w = wi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (long)c);
                sum2 += (double)(w * (long)c * (long)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wvar(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wvar(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ShortVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (float)c);
                sum2 += (double)(w * (float)c * (float)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wvar(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wvar(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(ShortVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += w * (double)c;
                sum2 += w * (double)c * (double)c;
                count += w;
                count2 += w * w;
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double std(Short[] values) {
        return Numeric.std(Basic.unbox(values));
    }

    public static double std(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.std((ShortVector)new ShortVectorDirect(values));
    }

    public static double std(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.var(values);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wstd(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wstd(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wstd(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wstd(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wstd(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wstd(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double ste(Short[] values) {
        return Numeric.ste(Basic.unbox(values));
    }

    public static double ste(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.ste((ShortVector)new ShortVectorDirect(values));
    }

    public static double ste(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double s = Numeric.std(values);
        long c = Basic.count(values);
        return s == -1.7976931348623157E308 || c == Long.MIN_VALUE ? -1.7976931348623157E308 : s / Math.sqrt(c);
    }

    public static double wste(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wste(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                byte w = wi.nextByte();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wste(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                short w = wi.nextShort();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wste(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                int w = wi.nextInt();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wste(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                long w = wi.nextLong();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wste(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                float w = wi.nextFloat();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wste(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                short v = vi.nextShort();
                double w = wi.nextDouble();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += w;
                sumw2 += w * w;
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double tstat(Short[] values) {
        return Numeric.tstat(Basic.unbox(values));
    }

    public static double tstat(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.tstat((ShortVector)new ShortVectorDirect(values));
    }

    public static double tstat(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.avg(values);
        double s = Numeric.ste(values);
        return a == -1.7976931348623157E308 || s == -1.7976931348623157E308 ? -1.7976931348623157E308 : Numeric.avg(values) / Numeric.ste(values);
    }

    public static double wtstat(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wtstat(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(ShortVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wtstat(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(ShortVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wtstat(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(ShortVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wtstat(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(ShortVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wtstat(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(ShortVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wtstat(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(ShortVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static short max(ShortVector values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? (short)Short.MIN_VALUE : values.get(idx);
    }

    public static short max(short ... values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        return Numeric.max((ShortVector)new ShortVectorDirect(values));
    }

    public static short max(Short[] values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? (short)Short.MIN_VALUE : values[LongSizedDataStructure.intSize((String)"max", (long)idx)];
    }

    public static short min(ShortVector values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? (short)Short.MIN_VALUE : values.get(idx);
    }

    public static short min(short ... values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        return Numeric.min((ShortVector)new ShortVectorDirect(values));
    }

    public static short min(Short[] values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? (short)Short.MIN_VALUE : values[LongSizedDataStructure.intSize((String)"min", (long)idx)];
    }

    public static long indexOfMax(Short[] values) {
        return Numeric.indexOfMax(Basic.unbox(values));
    }

    public static long indexOfMax(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMax((ShortVector)new ShortVectorDirect(values));
    }

    public static long indexOfMax(ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        short val = -32767;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (!Basic.isNull(c) && (c > val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long indexOfMin(Short[] values) {
        return Numeric.indexOfMin(Basic.unbox(values));
    }

    public static long indexOfMin(short ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMin((ShortVector)new ShortVectorDirect(values));
    }

    public static long indexOfMin(ShortVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        short val = Short.MAX_VALUE;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (!Basic.isNull(c) && (c < val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static double median(Short[] values) {
        return Numeric.median(Basic.unbox(values));
    }

    public static double median(short ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.median((ShortVector)new ShortVectorDirect(values));
    }

    public static double median(ShortVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        int n = values.intSize("median");
        if (n == 0) {
            return Double.NaN;
        }
        short[] copy = values.copyToArray();
        Arrays.sort(copy);
        if (n % 2 == 0) {
            return 0.5 * (double)(copy[n / 2 - 1] + copy[n / 2]);
        }
        return copy[n / 2];
    }

    public static double percentile(double percentile, short ... values) {
        if (values == null || values.length == 0) {
            return -1.7976931348623157E308;
        }
        return Numeric.percentile(percentile, (ShortVector)new ShortVectorDirect(values));
    }

    public static double percentile(double percentile, ShortVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }
        int n = values.intSize("percentile");
        short[] copy = values.copyToArray();
        Arrays.sort(copy);
        int idx = (int)Math.round(percentile * (double)(n - 1));
        return copy[idx];
    }

    public static double cov(short[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cov(short[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cov(ShortVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ShortVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(short[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cor(short[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cor(ShortVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ShortVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(short[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cov(short[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cov(ShortVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ShortVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(short[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cor(short[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cor(ShortVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ShortVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(short[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cov(short[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cov(ShortVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ShortVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(short[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cor(short[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cor(ShortVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ShortVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(short[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cov(short[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cov(ShortVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ShortVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((long)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(short[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cor(short[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cor(ShortVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ShortVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((long)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(short[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cov(short[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cov(ShortVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ShortVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(short[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cor(short[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cor(ShortVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ShortVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(short[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cov(short[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cov(ShortVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(ShortVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(short[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cor(short[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((ShortVector)new ShortVectorDirect(values0), values1);
    }

    public static double cor(ShortVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(ShortVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfShort v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                short v0 = v0i.nextShort();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += v1;
                sum1Sq += v1 * v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static short sum(ShortVector values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        double sum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (Basic.isNull(c)) continue;
                sum += (double)c;
            }
        }
        return (short)sum;
    }

    public static short sum(short ... values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        return Numeric.sum((ShortVector)new ShortVectorDirect(values));
    }

    public static short product(ShortVector values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        short prod = 1;
        int count = 0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                if (c == 0) {
                    short s = 0;
                    return s;
                }
                if (Basic.isNull(c)) continue;
                ++count;
                prod = (short)(prod * c);
            }
        }
        if (count == 0) {
            return Short.MIN_VALUE;
        }
        return prod;
    }

    public static short product(short ... values) {
        if (values == null) {
            return Short.MIN_VALUE;
        }
        return Numeric.product((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] cummin(Short[] values) {
        return Numeric.cummin(Basic.unbox(values));
    }

    public static short[] cummin(short ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummin((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] cummin(ShortVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new short[0];
        }
        int n = values.intSize("cummin");
        short[] result = new short[n];
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            result[0] = vi.nextShort();
            int i = 1;
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (short)Math.min(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static short[] cummax(Short[] values) {
        return Numeric.cummax(Basic.unbox(values));
    }

    public static short[] cummax(short ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummax((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] cummax(ShortVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new short[0];
        }
        int n = values.intSize("cummax");
        short[] result = new short[n];
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            result[0] = vi.nextShort();
            int i = 1;
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (short)Math.max(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static short[] cumsum(Short[] values) {
        return Numeric.cumsum(Basic.unbox(values));
    }

    public static short[] cumsum(short ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumsum((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] cumsum(ShortVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new short[0];
        }
        int n = values.intSize("cumsum");
        short[] result = new short[n];
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            result[0] = vi.nextShort();
            int i = 1;
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (short)(result[i - 1] + v));
                ++i;
            }
        }
        return result;
    }

    public static short[] cumprod(Short[] values) {
        return Numeric.cumprod(Basic.unbox(values));
    }

    public static short[] cumprod(short ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumprod((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] cumprod(ShortVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new short[0];
        }
        int n = values.intSize("cumprod");
        short[] result = new short[n];
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();){
            result[0] = vi.nextShort();
            int i = 1;
            while (vi.hasNext()) {
                short v = vi.nextShort();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : (short)(result[i - 1] * v));
                ++i;
            }
        }
        return result;
    }

    public static short abs(short value) {
        if (Basic.isNull(value)) {
            return Short.MIN_VALUE;
        }
        return (short)Math.abs(value);
    }

    public static double acos(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.acos(value);
    }

    public static double asin(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.asin(value);
    }

    public static double atan(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.atan(value);
    }

    public static double ceil(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.ceil(value);
    }

    public static double cos(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.cos(value);
    }

    public static double exp(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.exp(value);
    }

    public static double floor(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.floor(value);
    }

    public static double log(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.log(value);
    }

    public static double pow(short a, byte b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(short a, short b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(short a, int b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(short a, long b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(short a, float b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(short a, double b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double rint(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.rint(value);
    }

    public static long round(short value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.round(value);
    }

    public static int signum(short value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.signum(value);
    }

    public static double sin(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sin(value);
    }

    public static double sqrt(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt(value);
    }

    public static double tan(short value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.tan(value);
    }

    public static short lowerBin(short value, short interval) {
        if (value == Short.MIN_VALUE || interval == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long d = (long)value / (long)interval;
        long m = (long)value % (long)interval;
        long r = m != 0L && value < 0 ? d - 1L : d;
        return (short)((long)interval * r);
    }

    public static short lowerBin(short value, short interval, short offset) {
        if (value == Short.MIN_VALUE || interval == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)(Numeric.lowerBin((short)(value - offset), interval) + offset);
    }

    public static short upperBin(short value, short interval) {
        if (value == Short.MIN_VALUE || interval == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long r = (long)value / (long)interval + (long)(value % interval > 0 ? 1 : 0);
        return (short)((long)interval * r);
    }

    public static short upperBin(short value, short interval, short offset) {
        if (value == Short.MIN_VALUE || interval == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)(Numeric.upperBin((short)(value - offset), interval) + offset);
    }

    public static short clamp(short value, short min, short max) {
        Require.leq((short)min, (String)"min", (short)max, (String)"max");
        if (Basic.isNull(value)) {
            return Short.MIN_VALUE;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double wsum(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wsum(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wsum(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ShortVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(short[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wavg(short[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wavg(ShortVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ShortVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wsum(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wsum(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ShortVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(short[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wavg(short[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wavg(ShortVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ShortVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wsum(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wsum(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ShortVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(short[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wavg(short[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wavg(ShortVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ShortVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wsum(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wsum(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ShortVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((long)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(short[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wavg(short[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wavg(ShortVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ShortVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((long)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wsum(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wsum(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ShortVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(short[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wavg(short[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wavg(ShortVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ShortVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wsum(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wsum(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(ShortVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
            }
            return vsum;
        }
    }

    public static double wavg(short[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wavg(short[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((ShortVector)new ShortVectorDirect(values), weights);
    }

    public static double wavg(ShortVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(ShortVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfShort vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                short c = vi.nextShort();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
                wsum += w;
            }
            return vsum / wsum;
        }
    }

    public static short[] sequence(short start, short end, short step) {
        if (step == 0) {
            return new short[0];
        }
        int n = (end - start) / step;
        if (n < 0) {
            return new short[0];
        }
        short[] result = new short[n + 1];
        for (int i = 0; i <= n; ++i) {
            result[i] = (short)(start + i * step);
        }
        return result;
    }

    public static boolean isNaN(Short value) {
        return false;
    }

    public static boolean isNaN(short value) {
        return false;
    }

    public static boolean isInf(Short value) {
        return false;
    }

    public static boolean isInf(short value) {
        return false;
    }

    public static boolean isFinite(Short value) {
        return !Basic.isNull(value);
    }

    public static boolean isFinite(short value) {
        return !Basic.isNull(value);
    }

    public static boolean containsNonFinite(Short[] values) {
        for (Short v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonFinite(short ... values) {
        for (short v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static long countPos(Integer[] values) {
        return Numeric.countPos(Basic.unbox(values));
    }

    public static long countPos(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countPos((IntVector)new IntVectorDirect(values));
    }

    public static long countPos(IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Basic.isNull(c) || c <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countNeg(Integer[] values) {
        return Numeric.countNeg(Basic.unbox(values));
    }

    public static long countNeg(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countNeg((IntVector)new IntVectorDirect(values));
    }

    public static long countNeg(IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        long n = values.size();
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Basic.isNull(c) || c >= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countZero(Integer[] values) {
        return Numeric.countZero(Basic.unbox(values));
    }

    public static long countZero(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countZero((IntVector)new IntVectorDirect(values));
    }

    public static long countZero(IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Basic.isNull(c) || c != 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static double avg(Integer[] values) {
        return Numeric.avg(Basic.unbox(values));
    }

    public static double avg(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.avg((IntVector)new IntVectorDirect(values));
    }

    public static double avg(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double absAvg(Integer[] values) {
        return Numeric.absAvg(Basic.unbox(values));
    }

    public static double absAvg(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.absAvg((IntVector)new IntVectorDirect(values));
    }

    public static double absAvg(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isInf(c)) {
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)Math.abs(c);
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double var(Integer[] values) {
        return Numeric.var(Basic.unbox(values));
    }

    public static double var(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.var((IntVector)new IntVectorDirect(values));
    }

    public static double var(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long count = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                sum2 += (double)c * (double)c;
                ++count;
            }
        }
        if (count <= 1L || Double.isInfinite(sum) || Double.isInfinite(sum2)) {
            return Double.NaN;
        }
        double vs2bar = sum * (sum / (double)count);
        double delta = sum2 - vs2bar;
        double eps = Math.ulp(sum2);
        double rel_eps = delta / eps;
        return Math.abs(rel_eps) > 1.0 ? delta / ((double)count - 1.0) : 0.0;
    }

    public static double wvar(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wvar(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wvar(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(IntVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wvar(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wvar(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(IntVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                short w = wi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wvar(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wvar(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(IntVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                int w = wi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wvar(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wvar(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(IntVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                long w = wi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (long)c);
                sum2 += (double)(w * (long)c * (long)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wvar(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wvar(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(IntVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (float)c);
                sum2 += (double)(w * (float)c * (float)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wvar(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wvar(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(IntVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += w * (double)c;
                sum2 += w * (double)c * (double)c;
                count += w;
                count2 += w * w;
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double std(Integer[] values) {
        return Numeric.std(Basic.unbox(values));
    }

    public static double std(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.std((IntVector)new IntVectorDirect(values));
    }

    public static double std(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.var(values);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wstd(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wstd(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wstd(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wstd(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wstd(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wstd(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double ste(Integer[] values) {
        return Numeric.ste(Basic.unbox(values));
    }

    public static double ste(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.ste((IntVector)new IntVectorDirect(values));
    }

    public static double ste(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double s = Numeric.std(values);
        long c = Basic.count(values);
        return s == -1.7976931348623157E308 || c == Long.MIN_VALUE ? -1.7976931348623157E308 : s / Math.sqrt(c);
    }

    public static double wste(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wste(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                byte w = wi.nextByte();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wste(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                short w = wi.nextShort();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wste(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                int w = wi.nextInt();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wste(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                long w = wi.nextLong();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wste(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                float w = wi.nextFloat();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wste(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                int v = vi.nextInt();
                double w = wi.nextDouble();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += w;
                sumw2 += w * w;
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double tstat(Integer[] values) {
        return Numeric.tstat(Basic.unbox(values));
    }

    public static double tstat(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.tstat((IntVector)new IntVectorDirect(values));
    }

    public static double tstat(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.avg(values);
        double s = Numeric.ste(values);
        return a == -1.7976931348623157E308 || s == -1.7976931348623157E308 ? -1.7976931348623157E308 : Numeric.avg(values) / Numeric.ste(values);
    }

    public static double wtstat(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wtstat(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(IntVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wtstat(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(IntVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wtstat(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(IntVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wtstat(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(IntVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wtstat(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(IntVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wtstat(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(IntVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static int max(IntVector values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? Integer.MIN_VALUE : values.get(idx);
    }

    public static int max(int ... values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return Numeric.max((IntVector)new IntVectorDirect(values));
    }

    public static int max(Integer[] values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? Integer.MIN_VALUE : values[LongSizedDataStructure.intSize((String)"max", (long)idx)];
    }

    public static int min(IntVector values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? Integer.MIN_VALUE : values.get(idx);
    }

    public static int min(int ... values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return Numeric.min((IntVector)new IntVectorDirect(values));
    }

    public static int min(Integer[] values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? Integer.MIN_VALUE : values[LongSizedDataStructure.intSize((String)"min", (long)idx)];
    }

    public static long indexOfMax(Integer[] values) {
        return Numeric.indexOfMax(Basic.unbox(values));
    }

    public static long indexOfMax(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMax((IntVector)new IntVectorDirect(values));
    }

    public static long indexOfMax(IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        int val = -2147483647;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (!Basic.isNull(c) && (c > val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long indexOfMin(Integer[] values) {
        return Numeric.indexOfMin(Basic.unbox(values));
    }

    public static long indexOfMin(int ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMin((IntVector)new IntVectorDirect(values));
    }

    public static long indexOfMin(IntVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        int val = Integer.MAX_VALUE;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (!Basic.isNull(c) && (c < val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static double median(Integer[] values) {
        return Numeric.median(Basic.unbox(values));
    }

    public static double median(int ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.median((IntVector)new IntVectorDirect(values));
    }

    public static double median(IntVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        int n = values.intSize("median");
        if (n == 0) {
            return Double.NaN;
        }
        int[] copy = values.copyToArray();
        Arrays.sort(copy);
        if (n % 2 == 0) {
            return 0.5 * (double)(copy[n / 2 - 1] + copy[n / 2]);
        }
        return copy[n / 2];
    }

    public static double percentile(double percentile, int ... values) {
        if (values == null || values.length == 0) {
            return -1.7976931348623157E308;
        }
        return Numeric.percentile(percentile, (IntVector)new IntVectorDirect(values));
    }

    public static double percentile(double percentile, IntVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }
        int n = values.intSize("percentile");
        int[] copy = values.copyToArray();
        Arrays.sort(copy);
        int idx = (int)Math.round(percentile * (double)(n - 1));
        return copy[idx];
    }

    public static double cov(int[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cov(int[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cov(IntVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(IntVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(int[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cor(int[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cor(IntVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(IntVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(int[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cov(int[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cov(IntVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(IntVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(int[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cor(int[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cor(IntVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(IntVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(int[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cov(int[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cov(IntVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(IntVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(int[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cor(int[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cor(IntVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(IntVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(int[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cov(int[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cov(IntVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(IntVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((long)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(int[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cor(int[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cor(IntVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(IntVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((long)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(int[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cov(int[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cov(IntVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(IntVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(int[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cor(int[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cor(IntVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(IntVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(int[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cov(int[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cov(IntVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(IntVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(int[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cor(int[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((IntVector)new IntVectorDirect(values0), values1);
    }

    public static double cor(IntVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(IntVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfInt v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                int v0 = v0i.nextInt();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += v1;
                sum1Sq += v1 * v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static int sum(IntVector values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        double sum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (Basic.isNull(c)) continue;
                sum += (double)c;
            }
        }
        return (int)sum;
    }

    public static int sum(int ... values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return Numeric.sum((IntVector)new IntVectorDirect(values));
    }

    public static int product(IntVector values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        int prod = 1;
        int count = 0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                if (c == 0) {
                    int n = 0;
                    return n;
                }
                if (Basic.isNull(c)) continue;
                ++count;
                prod *= c;
            }
        }
        if (count == 0) {
            return Integer.MIN_VALUE;
        }
        return prod;
    }

    public static int product(int ... values) {
        if (values == null) {
            return Integer.MIN_VALUE;
        }
        return Numeric.product((IntVector)new IntVectorDirect(values));
    }

    public static int[] cummin(Integer[] values) {
        return Numeric.cummin(Basic.unbox(values));
    }

    public static int[] cummin(int ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummin((IntVector)new IntVectorDirect(values));
    }

    public static int[] cummin(IntVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new int[0];
        }
        int n = values.intSize("cummin");
        int[] result = new int[n];
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            result[0] = vi.nextInt();
            int i = 1;
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.min(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static int[] cummax(Integer[] values) {
        return Numeric.cummax(Basic.unbox(values));
    }

    public static int[] cummax(int ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummax((IntVector)new IntVectorDirect(values));
    }

    public static int[] cummax(IntVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new int[0];
        }
        int n = values.intSize("cummax");
        int[] result = new int[n];
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            result[0] = vi.nextInt();
            int i = 1;
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.max(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static int[] cumsum(Integer[] values) {
        return Numeric.cumsum(Basic.unbox(values));
    }

    public static int[] cumsum(int ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumsum((IntVector)new IntVectorDirect(values));
    }

    public static int[] cumsum(IntVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new int[0];
        }
        int n = values.intSize("cumsum");
        int[] result = new int[n];
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            result[0] = vi.nextInt();
            int i = 1;
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] + v);
                ++i;
            }
        }
        return result;
    }

    public static int[] cumprod(Integer[] values) {
        return Numeric.cumprod(Basic.unbox(values));
    }

    public static int[] cumprod(int ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumprod((IntVector)new IntVectorDirect(values));
    }

    public static int[] cumprod(IntVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new int[0];
        }
        int n = values.intSize("cumprod");
        int[] result = new int[n];
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();){
            result[0] = vi.nextInt();
            int i = 1;
            while (vi.hasNext()) {
                int v = vi.nextInt();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] * v);
                ++i;
            }
        }
        return result;
    }

    public static int abs(int value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Math.abs(value);
    }

    public static double acos(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.acos(value);
    }

    public static double asin(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.asin(value);
    }

    public static double atan(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.atan(value);
    }

    public static double ceil(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.ceil(value);
    }

    public static double cos(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.cos(value);
    }

    public static double exp(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.exp(value);
    }

    public static double floor(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.floor(value);
    }

    public static double log(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.log(value);
    }

    public static double pow(int a, byte b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(int a, short b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(int a, int b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(int a, long b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(int a, float b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(int a, double b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double rint(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.rint(value);
    }

    public static long round(int value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.round(value);
    }

    public static int signum(int value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.signum(value);
    }

    public static double sin(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sin(value);
    }

    public static double sqrt(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt(value);
    }

    public static double tan(int value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.tan(value);
    }

    public static int lowerBin(int value, int interval) {
        if (value == Integer.MIN_VALUE || interval == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long d = (long)value / (long)interval;
        long m = (long)value % (long)interval;
        long r = m != 0L && value < 0 ? d - 1L : d;
        return (int)((long)interval * r);
    }

    public static int lowerBin(int value, int interval, int offset) {
        if (value == Integer.MIN_VALUE || interval == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return Numeric.lowerBin(value - offset, interval) + offset;
    }

    public static int upperBin(int value, int interval) {
        if (value == Integer.MIN_VALUE || interval == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long r = (long)value / (long)interval + (long)(value % interval > 0 ? 1 : 0);
        return (int)((long)interval * r);
    }

    public static int upperBin(int value, int interval, int offset) {
        if (value == Integer.MIN_VALUE || interval == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return Numeric.upperBin(value - offset, interval) + offset;
    }

    public static int clamp(int value, int min, int max) {
        Require.leq((int)min, (String)"min", (int)max, (String)"max");
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double wsum(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wsum(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wsum(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(IntVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(int[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wavg(int[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wavg(IntVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(IntVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wsum(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wsum(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(IntVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(int[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wavg(int[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wavg(IntVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(IntVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wsum(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wsum(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(IntVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(int[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wavg(int[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wavg(IntVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(IntVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wsum(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wsum(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(IntVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((long)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(int[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wavg(int[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wavg(IntVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(IntVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((long)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wsum(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wsum(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(IntVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(int[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wavg(int[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wavg(IntVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(IntVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wsum(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wsum(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(IntVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
            }
            return vsum;
        }
    }

    public static double wavg(int[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wavg(int[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((IntVector)new IntVectorDirect(values), weights);
    }

    public static double wavg(IntVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(IntVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfInt vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                int c = vi.nextInt();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
                wsum += w;
            }
            return vsum / wsum;
        }
    }

    public static int[] sequence(int start, int end, int step) {
        if (step == 0) {
            return new int[0];
        }
        int n = (end - start) / step;
        if (n < 0) {
            return new int[0];
        }
        int[] result = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            result[i] = start + i * step;
        }
        return result;
    }

    public static boolean isNaN(Integer value) {
        return false;
    }

    public static boolean isNaN(int value) {
        return false;
    }

    public static boolean isInf(Integer value) {
        return false;
    }

    public static boolean isInf(int value) {
        return false;
    }

    public static boolean isFinite(Integer value) {
        return !Basic.isNull(value);
    }

    public static boolean isFinite(int value) {
        return !Basic.isNull(value);
    }

    public static boolean containsNonFinite(Integer[] values) {
        for (Integer v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonFinite(int ... values) {
        for (int v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static long countPos(Long[] values) {
        return Numeric.countPos(Basic.unbox(values));
    }

    public static long countPos(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countPos((LongVector)new LongVectorDirect(values));
    }

    public static long countPos(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Basic.isNull(c) || c <= 0L) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countNeg(Long[] values) {
        return Numeric.countNeg(Basic.unbox(values));
    }

    public static long countNeg(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countNeg((LongVector)new LongVectorDirect(values));
    }

    public static long countNeg(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        long n = values.size();
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Basic.isNull(c) || c >= 0L) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countZero(Long[] values) {
        return Numeric.countZero(Basic.unbox(values));
    }

    public static long countZero(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countZero((LongVector)new LongVectorDirect(values));
    }

    public static long countZero(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Basic.isNull(c) || c != 0L) continue;
                ++count;
            }
        }
        return count;
    }

    public static double avg(Long[] values) {
        return Numeric.avg(Basic.unbox(values));
    }

    public static double avg(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.avg((LongVector)new LongVectorDirect(values));
    }

    public static double avg(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double absAvg(Long[] values) {
        return Numeric.absAvg(Basic.unbox(values));
    }

    public static double absAvg(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.absAvg((LongVector)new LongVectorDirect(values));
    }

    public static double absAvg(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isInf(c)) {
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)Math.abs(c);
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double var(Long[] values) {
        return Numeric.var(Basic.unbox(values));
    }

    public static double var(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.var((LongVector)new LongVectorDirect(values));
    }

    public static double var(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long count = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                sum2 += (double)c * (double)c;
                ++count;
            }
        }
        if (count <= 1L || Double.isInfinite(sum) || Double.isInfinite(sum2)) {
            return Double.NaN;
        }
        double vs2bar = sum * (sum / (double)count);
        double delta = sum2 - vs2bar;
        double eps = Math.ulp(sum2);
        double rel_eps = delta / eps;
        return Math.abs(rel_eps) > 1.0 ? delta / ((double)count - 1.0) : 0.0;
    }

    public static double wvar(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wvar(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wvar(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(LongVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((long)w * c);
                sum2 += (double)((long)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wvar(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wvar(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(LongVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                short w = wi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((long)w * c);
                sum2 += (double)((long)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wvar(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wvar(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(LongVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                int w = wi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((long)w * c);
                sum2 += (double)((long)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wvar(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wvar(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(LongVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                long w = wi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wvar(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wvar(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(LongVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * (float)c);
                sum2 += (double)(w * (float)c * (float)c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wvar(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wvar(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(LongVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += w * (double)c;
                sum2 += w * (double)c * (double)c;
                count += w;
                count2 += w * w;
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double std(Long[] values) {
        return Numeric.std(Basic.unbox(values));
    }

    public static double std(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.std((LongVector)new LongVectorDirect(values));
    }

    public static double std(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.var(values);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wstd(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wstd(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wstd(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wstd(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wstd(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wstd(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double ste(Long[] values) {
        return Numeric.ste(Basic.unbox(values));
    }

    public static double ste(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.ste((LongVector)new LongVectorDirect(values));
    }

    public static double ste(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double s = Numeric.std(values);
        long c = Basic.count(values);
        return s == -1.7976931348623157E308 || c == Long.MIN_VALUE ? -1.7976931348623157E308 : s / Math.sqrt(c);
    }

    public static double wste(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wste(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                byte w = wi.nextByte();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wste(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                short w = wi.nextShort();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wste(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                int w = wi.nextInt();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wste(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                long w = wi.nextLong();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wste(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                float w = wi.nextFloat();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wste(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                long v = vi.nextLong();
                double w = wi.nextDouble();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += w;
                sumw2 += w * w;
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double tstat(Long[] values) {
        return Numeric.tstat(Basic.unbox(values));
    }

    public static double tstat(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.tstat((LongVector)new LongVectorDirect(values));
    }

    public static double tstat(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.avg(values);
        double s = Numeric.ste(values);
        return a == -1.7976931348623157E308 || s == -1.7976931348623157E308 ? -1.7976931348623157E308 : Numeric.avg(values) / Numeric.ste(values);
    }

    public static double wtstat(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wtstat(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(LongVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wtstat(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(LongVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wtstat(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(LongVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wtstat(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(LongVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wtstat(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(LongVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wtstat(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(LongVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static long max(LongVector values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? Long.MIN_VALUE : values.get(idx);
    }

    public static long max(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.max((LongVector)new LongVectorDirect(values));
    }

    public static long max(Long[] values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? Long.MIN_VALUE : values[LongSizedDataStructure.intSize((String)"max", (long)idx)];
    }

    public static long min(LongVector values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? Long.MIN_VALUE : values.get(idx);
    }

    public static long min(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.min((LongVector)new LongVectorDirect(values));
    }

    public static long min(Long[] values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? Long.MIN_VALUE : values[LongSizedDataStructure.intSize((String)"min", (long)idx)];
    }

    public static long indexOfMax(Long[] values) {
        return Numeric.indexOfMax(Basic.unbox(values));
    }

    public static long indexOfMax(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMax((LongVector)new LongVectorDirect(values));
    }

    public static long indexOfMax(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long val = -9223372036854775807L;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (!Basic.isNull(c) && (c > val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long indexOfMin(Long[] values) {
        return Numeric.indexOfMin(Basic.unbox(values));
    }

    public static long indexOfMin(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMin((LongVector)new LongVectorDirect(values));
    }

    public static long indexOfMin(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long val = Long.MAX_VALUE;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (!Basic.isNull(c) && (c < val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static double median(Long[] values) {
        return Numeric.median(Basic.unbox(values));
    }

    public static double median(long ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.median((LongVector)new LongVectorDirect(values));
    }

    public static double median(LongVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        int n = values.intSize("median");
        if (n == 0) {
            return Double.NaN;
        }
        long[] copy = values.copyToArray();
        Arrays.sort(copy);
        if (n % 2 == 0) {
            return 0.5 * (double)(copy[n / 2 - 1] + copy[n / 2]);
        }
        return copy[n / 2];
    }

    public static double percentile(double percentile, long ... values) {
        if (values == null || values.length == 0) {
            return -1.7976931348623157E308;
        }
        return Numeric.percentile(percentile, (LongVector)new LongVectorDirect(values));
    }

    public static double percentile(double percentile, LongVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }
        int n = values.intSize("percentile");
        long[] copy = values.copyToArray();
        Arrays.sort(copy);
        int idx = (int)Math.round(percentile * (double)(n - 1));
        return copy[idx];
    }

    public static double cov(long[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cov(long[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cov(LongVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(LongVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (long)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(long[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cor(long[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cor(LongVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(LongVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (long)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(long[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cov(long[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cov(LongVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(LongVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (long)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(long[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cor(long[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cor(LongVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(LongVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (long)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(long[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cov(long[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cov(LongVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(LongVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (long)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(long[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cor(long[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cor(LongVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(LongVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (long)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(long[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cov(long[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cov(LongVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(LongVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(long[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cor(long[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cor(LongVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(LongVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(long[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cov(long[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cov(LongVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(LongVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(long[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cor(long[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cor(LongVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(LongVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)((float)v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(long[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cov(long[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cov(LongVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(LongVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(long[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cor(long[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((LongVector)new LongVectorDirect(values0), values1);
    }

    public static double cor(LongVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(LongVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfLong v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                long v0 = v0i.nextLong();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += v1;
                sum1Sq += v1 * v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static long sum(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        double sum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (Basic.isNull(c)) continue;
                sum += (double)c;
            }
        }
        return (long)sum;
    }

    public static long sum(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.sum((LongVector)new LongVectorDirect(values));
    }

    public static long product(LongVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long prod = 1L;
        int count = 0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                if (c == 0L) {
                    long l = 0L;
                    return l;
                }
                if (Basic.isNull(c)) continue;
                ++count;
                prod *= c;
            }
        }
        if (count == 0) {
            return Long.MIN_VALUE;
        }
        return prod;
    }

    public static long product(long ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.product((LongVector)new LongVectorDirect(values));
    }

    public static long[] cummin(Long[] values) {
        return Numeric.cummin(Basic.unbox(values));
    }

    public static long[] cummin(long ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummin((LongVector)new LongVectorDirect(values));
    }

    public static long[] cummin(LongVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new long[0];
        }
        int n = values.intSize("cummin");
        long[] result = new long[n];
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            result[0] = vi.nextLong();
            int i = 1;
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.min(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static long[] cummax(Long[] values) {
        return Numeric.cummax(Basic.unbox(values));
    }

    public static long[] cummax(long ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummax((LongVector)new LongVectorDirect(values));
    }

    public static long[] cummax(LongVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new long[0];
        }
        int n = values.intSize("cummax");
        long[] result = new long[n];
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            result[0] = vi.nextLong();
            int i = 1;
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.max(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static long[] cumsum(Long[] values) {
        return Numeric.cumsum(Basic.unbox(values));
    }

    public static long[] cumsum(long ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumsum((LongVector)new LongVectorDirect(values));
    }

    public static long[] cumsum(LongVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new long[0];
        }
        int n = values.intSize("cumsum");
        long[] result = new long[n];
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            result[0] = vi.nextLong();
            int i = 1;
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] + v);
                ++i;
            }
        }
        return result;
    }

    public static long[] cumprod(Long[] values) {
        return Numeric.cumprod(Basic.unbox(values));
    }

    public static long[] cumprod(long ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumprod((LongVector)new LongVectorDirect(values));
    }

    public static long[] cumprod(LongVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new long[0];
        }
        int n = values.intSize("cumprod");
        long[] result = new long[n];
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();){
            result[0] = vi.nextLong();
            int i = 1;
            while (vi.hasNext()) {
                long v = vi.nextLong();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] * v);
                ++i;
            }
        }
        return result;
    }

    public static long abs(long value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.abs(value);
    }

    public static double acos(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.acos(value);
    }

    public static double asin(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.asin(value);
    }

    public static double atan(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.atan(value);
    }

    public static double ceil(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.ceil(value);
    }

    public static double cos(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.cos(value);
    }

    public static double exp(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.exp(value);
    }

    public static double floor(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.floor(value);
    }

    public static double log(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.log(value);
    }

    public static double pow(long a, byte b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(long a, short b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(long a, int b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(long a, long b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(long a, float b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(long a, double b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double rint(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.rint(value);
    }

    public static long round(long value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.round(value);
    }

    public static int signum(long value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.signum((int)value);
    }

    public static double sin(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sin(value);
    }

    public static double sqrt(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt(value);
    }

    public static double tan(long value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.tan(value);
    }

    public static long lowerBin(long value, long interval) {
        if (value == Long.MIN_VALUE || interval == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long d = value / interval;
        long m = value % interval;
        long r = m != 0L && value < 0L ? d - 1L : d;
        return interval * r;
    }

    public static long lowerBin(long value, long interval, long offset) {
        if (value == Long.MIN_VALUE || interval == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return Numeric.lowerBin(value - offset, interval) + offset;
    }

    public static long upperBin(long value, long interval) {
        if (value == Long.MIN_VALUE || interval == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        long r = value / interval + (long)(value % interval > 0L ? 1 : 0);
        return interval * r;
    }

    public static long upperBin(long value, long interval, long offset) {
        if (value == Long.MIN_VALUE || interval == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return Numeric.upperBin(value - offset, interval) + offset;
    }

    public static long clamp(long value, long min, long max) {
        Require.leq((long)min, (String)"min", (long)max, (String)"max");
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double wsum(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wsum(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wsum(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(LongVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (long)w);
            }
            return vsum;
        }
    }

    public static double wavg(long[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wavg(long[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wavg(LongVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(LongVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (long)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wsum(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wsum(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(LongVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (long)w);
            }
            return vsum;
        }
    }

    public static double wavg(long[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wavg(long[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wavg(LongVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(LongVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (long)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wsum(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wsum(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(LongVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (long)w);
            }
            return vsum;
        }
    }

    public static double wavg(long[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wavg(long[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wavg(LongVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(LongVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (long)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wsum(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wsum(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(LongVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(long[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wavg(long[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wavg(LongVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(LongVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wsum(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wsum(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(LongVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
            }
            return vsum;
        }
    }

    public static double wavg(long[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wavg(long[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wavg(LongVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(LongVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)((float)c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wsum(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wsum(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(LongVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
            }
            return vsum;
        }
    }

    public static double wavg(long[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wavg(long[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((LongVector)new LongVectorDirect(values), weights);
    }

    public static double wavg(LongVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(LongVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfLong vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                long c = vi.nextLong();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
                wsum += w;
            }
            return vsum / wsum;
        }
    }

    public static long[] sequence(long start, long end, long step) {
        if (step == 0L) {
            return new long[0];
        }
        int n = (int)((end - start) / step);
        if (n < 0) {
            return new long[0];
        }
        long[] result = new long[n + 1];
        for (int i = 0; i <= n; ++i) {
            result[i] = start + (long)i * step;
        }
        return result;
    }

    public static boolean isNaN(Long value) {
        return false;
    }

    public static boolean isNaN(long value) {
        return false;
    }

    public static boolean isInf(Long value) {
        return false;
    }

    public static boolean isInf(long value) {
        return false;
    }

    public static boolean isFinite(Long value) {
        return !Basic.isNull(value);
    }

    public static boolean isFinite(long value) {
        return !Basic.isNull(value);
    }

    public static boolean containsNonFinite(Long[] values) {
        for (Long v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonFinite(long ... values) {
        for (long v1 : values) {
            if (!Basic.isNull(v1)) continue;
            return true;
        }
        return false;
    }

    public static long countPos(Float[] values) {
        return Numeric.countPos(Basic.unbox(values));
    }

    public static long countPos(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countPos((FloatVector)new FloatVectorDirect(values));
    }

    public static long countPos(FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Basic.isNull(c) || !(c > 0.0f)) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countNeg(Float[] values) {
        return Numeric.countNeg(Basic.unbox(values));
    }

    public static long countNeg(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countNeg((FloatVector)new FloatVectorDirect(values));
    }

    public static long countNeg(FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        long n = values.size();
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Basic.isNull(c) || !(c < 0.0f)) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countZero(Float[] values) {
        return Numeric.countZero(Basic.unbox(values));
    }

    public static long countZero(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countZero((FloatVector)new FloatVectorDirect(values));
    }

    public static long countZero(FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Basic.isNull(c) || c != 0.0f) continue;
                ++count;
            }
        }
        return count;
    }

    public static double avg(Float[] values) {
        return Numeric.avg(Basic.unbox(values));
    }

    public static double avg(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.avg((FloatVector)new FloatVectorDirect(values));
    }

    public static double avg(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double absAvg(Float[] values) {
        return Numeric.absAvg(Basic.unbox(values));
    }

    public static double absAvg(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.absAvg((FloatVector)new FloatVectorDirect(values));
    }

    public static double absAvg(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isInf(c)) {
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)Math.abs(c);
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double var(Float[] values) {
        return Numeric.var(Basic.unbox(values));
    }

    public static double var(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.var((FloatVector)new FloatVectorDirect(values));
    }

    public static double var(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long count = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
                sum2 += (double)c * (double)c;
                ++count;
            }
        }
        if (count <= 1L || Double.isInfinite(sum) || Double.isInfinite(sum2)) {
            return Double.NaN;
        }
        double vs2bar = sum * (sum / (double)count);
        double delta = sum2 - vs2bar;
        double eps = Math.ulp(sum2);
        double rel_eps = delta / eps;
        return Math.abs(rel_eps) > 1.0 ? delta / ((double)count - 1.0) : 0.0;
    }

    public static double wvar(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wvar(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wvar(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(FloatVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((float)w * c);
                sum2 += (double)((float)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wvar(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wvar(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(FloatVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                short w = wi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((float)w * c);
                sum2 += (double)((float)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wvar(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wvar(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(FloatVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                int w = wi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((float)w * c);
                sum2 += (double)((float)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wvar(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wvar(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(FloatVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                long w = wi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)((float)w * c);
                sum2 += (double)((float)w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wvar(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wvar(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(FloatVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)(w * c);
                sum2 += (double)(w * c * c);
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wvar(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wvar(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(FloatVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += w * (double)c;
                sum2 += w * (double)c * (double)c;
                count += w;
                count2 += w * w;
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double std(Float[] values) {
        return Numeric.std(Basic.unbox(values));
    }

    public static double std(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.std((FloatVector)new FloatVectorDirect(values));
    }

    public static double std(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.var(values);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wstd(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wstd(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wstd(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wstd(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wstd(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wstd(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double ste(Float[] values) {
        return Numeric.ste(Basic.unbox(values));
    }

    public static double ste(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.ste((FloatVector)new FloatVectorDirect(values));
    }

    public static double ste(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double s = Numeric.std(values);
        long c = Basic.count(values);
        return s == -1.7976931348623157E308 || c == Long.MIN_VALUE ? -1.7976931348623157E308 : s / Math.sqrt(c);
    }

    public static double wste(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wste(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                byte w = wi.nextByte();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wste(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                short w = wi.nextShort();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wste(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                int w = wi.nextInt();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wste(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                long w = wi.nextLong();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wste(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                float w = wi.nextFloat();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wste(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                double w = wi.nextDouble();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += w;
                sumw2 += w * w;
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double tstat(Float[] values) {
        return Numeric.tstat(Basic.unbox(values));
    }

    public static double tstat(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.tstat((FloatVector)new FloatVectorDirect(values));
    }

    public static double tstat(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.avg(values);
        double s = Numeric.ste(values);
        return a == -1.7976931348623157E308 || s == -1.7976931348623157E308 ? -1.7976931348623157E308 : Numeric.avg(values) / Numeric.ste(values);
    }

    public static double wtstat(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wtstat(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(FloatVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wtstat(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(FloatVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wtstat(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(FloatVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wtstat(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(FloatVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wtstat(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(FloatVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wtstat(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(FloatVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static float max(FloatVector values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? -3.4028235E38f : values.get(idx);
    }

    public static float max(float ... values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        return Numeric.max((FloatVector)new FloatVectorDirect(values));
    }

    public static float max(Float[] values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? -3.4028235E38f : values[LongSizedDataStructure.intSize((String)"max", (long)idx)].floatValue();
    }

    public static float min(FloatVector values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? -3.4028235E38f : values.get(idx);
    }

    public static float min(float ... values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        return Numeric.min((FloatVector)new FloatVectorDirect(values));
    }

    public static float min(Float[] values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? -3.4028235E38f : values[LongSizedDataStructure.intSize((String)"min", (long)idx)].floatValue();
    }

    public static long indexOfMax(Float[] values) {
        return Numeric.indexOfMax(Basic.unbox(values));
    }

    public static long indexOfMax(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMax((FloatVector)new FloatVectorDirect(values));
    }

    public static long indexOfMax(FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        float val = Float.NEGATIVE_INFINITY;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (!Basic.isNull(c) && (c > val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long indexOfMin(Float[] values) {
        return Numeric.indexOfMin(Basic.unbox(values));
    }

    public static long indexOfMin(float ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMin((FloatVector)new FloatVectorDirect(values));
    }

    public static long indexOfMin(FloatVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        float val = Float.POSITIVE_INFINITY;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (!Basic.isNull(c) && (c < val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static double median(Float[] values) {
        return Numeric.median(Basic.unbox(values));
    }

    public static double median(float ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.median((FloatVector)new FloatVectorDirect(values));
    }

    public static double median(FloatVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        int n = values.intSize("median");
        if (n == 0) {
            return Double.NaN;
        }
        float[] copy = values.copyToArray();
        Arrays.sort(copy);
        if (n % 2 == 0) {
            return 0.5 * (double)(copy[n / 2 - 1] + copy[n / 2]);
        }
        return copy[n / 2];
    }

    public static double percentile(double percentile, float ... values) {
        if (values == null || values.length == 0) {
            return -1.7976931348623157E308;
        }
        return Numeric.percentile(percentile, (FloatVector)new FloatVectorDirect(values));
    }

    public static double percentile(double percentile, FloatVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }
        int n = values.intSize("percentile");
        float[] copy = values.copyToArray();
        Arrays.sort(copy);
        int idx = (int)Math.round(percentile * (double)(n - 1));
        return copy[idx];
    }

    public static double cov(float[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cov(float[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cov(FloatVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(FloatVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(float[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cor(float[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cor(FloatVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(FloatVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(float[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cov(float[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cov(FloatVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(FloatVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(float[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cor(float[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cor(FloatVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(FloatVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(float[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cov(float[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cov(FloatVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(FloatVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(float[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cor(float[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cor(FloatVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(FloatVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(float[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cov(float[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cov(FloatVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(FloatVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(float[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cor(float[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cor(FloatVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(FloatVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * (float)v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(float[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cov(float[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cov(FloatVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(FloatVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += (double)v1;
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(float[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cor(float[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cor(FloatVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(FloatVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += (double)(v0 * v1);
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(float[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cov(float[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cov(FloatVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(FloatVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum1 += v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(float[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cor(float[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((FloatVector)new FloatVectorDirect(values0), values1);
    }

    public static double cor(FloatVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(FloatVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfFloat v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                float v0 = v0i.nextFloat();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += (double)v0;
                sum0Sq += (double)(v0 * v0);
                sum1 += v1;
                sum1Sq += v1 * v1;
                sum01 += (double)v0 * v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static float sum(FloatVector values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        double sum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Numeric.isNaN(c)) {
                    float f = Float.NaN;
                    return f;
                }
                if (Basic.isNull(c)) continue;
                sum += (double)c;
            }
        }
        return (float)sum;
    }

    public static float sum(float ... values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        return Numeric.sum((FloatVector)new FloatVectorDirect(values));
    }

    public static float product(FloatVector values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        float prod = 1.0f;
        int count = 0;
        long zeroCount = 0L;
        long infCount = 0L;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                if (Numeric.isNaN(c)) {
                    float f = Float.NaN;
                    return f;
                }
                if (Double.isInfinite(c)) {
                    if (zeroCount > 0L) {
                        float f = Float.NaN;
                        return f;
                    }
                    ++infCount;
                } else if (c == 0.0f) {
                    if (infCount > 0L) {
                        float f = Float.NaN;
                        return f;
                    }
                    ++zeroCount;
                }
                if (Basic.isNull(c)) continue;
                ++count;
                prod *= c;
            }
        }
        if (count == 0) {
            return -3.4028235E38f;
        }
        return zeroCount > 0L ? 0.0f : prod;
    }

    public static float product(float ... values) {
        if (values == null) {
            return -3.4028235E38f;
        }
        return Numeric.product((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] cummin(Float[] values) {
        return Numeric.cummin(Basic.unbox(values));
    }

    public static float[] cummin(float ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummin((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] cummin(FloatVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new float[0];
        }
        int n = values.intSize("cummin");
        float[] result = new float[n];
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            result[0] = vi.nextFloat();
            int i = 1;
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.min(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static float[] cummax(Float[] values) {
        return Numeric.cummax(Basic.unbox(values));
    }

    public static float[] cummax(float ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummax((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] cummax(FloatVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new float[0];
        }
        int n = values.intSize("cummax");
        float[] result = new float[n];
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            result[0] = vi.nextFloat();
            int i = 1;
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.max(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static float[] cumsum(Float[] values) {
        return Numeric.cumsum(Basic.unbox(values));
    }

    public static float[] cumsum(float ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumsum((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] cumsum(FloatVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new float[0];
        }
        int n = values.intSize("cumsum");
        float[] result = new float[n];
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            result[0] = vi.nextFloat();
            int i = 1;
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] + v);
                ++i;
            }
        }
        return result;
    }

    public static float[] cumprod(Float[] values) {
        return Numeric.cumprod(Basic.unbox(values));
    }

    public static float[] cumprod(float ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumprod((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] cumprod(FloatVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new float[0];
        }
        int n = values.intSize("cumprod");
        float[] result = new float[n];
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            result[0] = vi.nextFloat();
            int i = 1;
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] * v);
                ++i;
            }
        }
        return result;
    }

    public static float abs(float value) {
        if (Basic.isNull(value)) {
            return -3.4028235E38f;
        }
        return Math.abs(value);
    }

    public static double acos(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.acos(value);
    }

    public static double asin(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.asin(value);
    }

    public static double atan(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.atan(value);
    }

    public static double ceil(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.ceil(value);
    }

    public static double cos(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.cos(value);
    }

    public static double exp(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.exp(value);
    }

    public static double floor(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.floor(value);
    }

    public static double log(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.log(value);
    }

    public static double pow(float a, byte b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(float a, short b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(float a, int b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(float a, long b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(float a, float b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(float a, double b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double rint(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.rint(value);
    }

    public static long round(float value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.round(value);
    }

    public static int signum(float value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.signum((int)value);
    }

    public static double sin(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sin(value);
    }

    public static double sqrt(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt(value);
    }

    public static double tan(float value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.tan(value);
    }

    public static float lowerBin(float value, float interval) {
        if (value == -3.4028235E38f || interval == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        if (interval <= 0.0f) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        return (float)((double)interval * Math.floor(value / interval));
    }

    public static float lowerBin(float value, float interval, float offset) {
        if (value == -3.4028235E38f || interval == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        return Numeric.lowerBin(value - offset, interval) + offset;
    }

    public static float upperBin(float value, float interval) {
        if (value == -3.4028235E38f || interval == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        if (interval <= 0.0f) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        return (float)((double)interval * Math.ceil(value / interval));
    }

    public static float upperBin(float value, float interval, float offset) {
        if (value == -3.4028235E38f || interval == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        return Numeric.upperBin(value - offset, interval) + offset;
    }

    public static float clamp(float value, float min, float max) {
        Require.leq((float)min, (String)"min", (float)max, (String)"max");
        if (Basic.isNull(value)) {
            return -3.4028235E38f;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double wsum(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wsum(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wsum(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(FloatVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
            }
            return vsum;
        }
    }

    public static double wavg(float[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wavg(float[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wavg(FloatVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(FloatVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wsum(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wsum(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(FloatVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
            }
            return vsum;
        }
    }

    public static double wavg(float[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wavg(float[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wavg(FloatVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(FloatVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wsum(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wsum(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(FloatVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
            }
            return vsum;
        }
    }

    public static double wavg(float[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wavg(float[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wavg(FloatVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(FloatVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wsum(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wsum(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(FloatVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
            }
            return vsum;
        }
    }

    public static double wavg(float[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wavg(float[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wavg(FloatVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(FloatVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * (float)w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wsum(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wsum(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(FloatVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
            }
            return vsum;
        }
    }

    public static double wavg(float[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wavg(float[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wavg(FloatVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(FloatVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)(c * w);
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wsum(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wsum(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(FloatVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
            }
            return vsum;
        }
    }

    public static double wavg(float[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wavg(float[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((FloatVector)new FloatVectorDirect(values), weights);
    }

    public static double wavg(FloatVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(FloatVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                float c = vi.nextFloat();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += (double)c * w;
                wsum += w;
            }
            return vsum / wsum;
        }
    }

    public static float[] sequence(float start, float end, float step) {
        if (step == 0.0f) {
            return new float[0];
        }
        int n = (int)((end - start) / step);
        if (n < 0) {
            return new float[0];
        }
        float[] result = new float[n + 1];
        for (int i = 0; i <= n; ++i) {
            result[i] = start + (float)i * step;
        }
        return result;
    }

    public static boolean isNaN(Float value) {
        return value != null && Float.isNaN(value.floatValue());
    }

    public static boolean isNaN(float value) {
        return Float.isNaN(value);
    }

    public static boolean isInf(Float value) {
        return value != null && Float.isInfinite(value.floatValue());
    }

    public static boolean isInf(float value) {
        return Float.isInfinite(value);
    }

    public static boolean isFinite(Float value) {
        return Numeric.isFinite(Cast.castDouble(value.floatValue()));
    }

    public static boolean isFinite(float value) {
        return Float.isFinite(value) && !Basic.isNull(value);
    }

    public static boolean containsNonFinite(Float[] values) {
        return Numeric.containsNonFinite(Basic.unbox(values));
    }

    public static boolean containsNonFinite(float ... values) {
        for (float v1 : values) {
            if (Numeric.isFinite(v1)) continue;
            return true;
        }
        return false;
    }

    public static float replaceIfNaN(float value, float replacement) {
        if (Numeric.isNaN(value)) {
            return replacement;
        }
        return value;
    }

    public static float[] replaceIfNaN(float[] values, float replacement) {
        return Numeric.replaceIfNaN((FloatVector)new FloatVectorDirect(values), replacement);
    }

    public static float[] replaceIfNaN(FloatVector values, float replacement) {
        int n = values.intSize("replaceIfNaN");
        float[] result = new float[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Numeric.replaceIfNaN(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static float replaceIfNullNaN(float value, float replacement) {
        if (Numeric.isNaN(value) || Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static float[] replaceIfNullNaN(float[] values, float replacement) {
        return Numeric.replaceIfNullNaN((FloatVector)new FloatVectorDirect(values), replacement);
    }

    public static float[] replaceIfNullNaN(FloatVector values, float replacement) {
        int n = values.intSize("replaceIfNullNaN");
        float[] result = new float[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Numeric.replaceIfNullNaN(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static float replaceIfNonFinite(float value, float replacement) {
        return Numeric.isFinite(value) ? value : replacement;
    }

    public static float[] replaceIfNonFinite(float[] values, float replacement) {
        return Numeric.replaceIfNonFinite((FloatVector)new FloatVectorDirect(values), replacement);
    }

    public static float[] replaceIfNonFinite(FloatVector values, float replacement) {
        int n = values.intSize("replaceIfNonFinite");
        float[] result = new float[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfFloat vi = values.iterator();){
            while (vi.hasNext()) {
                float v = vi.nextFloat();
                result[i] = Numeric.replaceIfNonFinite(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static long countPos(Double[] values) {
        return Numeric.countPos(Basic.unbox(values));
    }

    public static long countPos(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countPos((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long countPos(DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Basic.isNull(c) || !(c > 0.0)) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countNeg(Double[] values) {
        return Numeric.countNeg(Basic.unbox(values));
    }

    public static long countNeg(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countNeg((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long countNeg(DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        long n = values.size();
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Basic.isNull(c) || !(c < 0.0)) continue;
                ++count;
            }
        }
        return count;
    }

    public static long countZero(Double[] values) {
        return Numeric.countZero(Basic.unbox(values));
    }

    public static long countZero(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.countZero((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long countZero(DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        long count = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Basic.isNull(c) || c != 0.0) continue;
                ++count;
            }
        }
        return count;
    }

    public static double avg(Double[] values) {
        return Numeric.avg(Basic.unbox(values));
    }

    public static double avg(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.avg((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double avg(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += c;
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double absAvg(Double[] values) {
        return Numeric.absAvg(Basic.unbox(values));
    }

    public static double absAvg(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.absAvg((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double absAvg(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isInf(c)) {
                    double d = Double.POSITIVE_INFINITY;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += Math.abs(c);
                count += 1.0;
            }
        }
        return sum / count;
    }

    public static double var(Double[] values) {
        return Numeric.var(Basic.unbox(values));
    }

    public static double var(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.var((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double var(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        long count = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += c;
                sum2 += c * c;
                ++count;
            }
        }
        if (count <= 1L || Double.isInfinite(sum) || Double.isInfinite(sum2)) {
            return Double.NaN;
        }
        double vs2bar = sum * (sum / (double)count);
        double delta = sum2 - vs2bar;
        double eps = Math.ulp(sum2);
        double rel_eps = delta / eps;
        return Math.abs(rel_eps) > 1.0 ? delta / ((double)count - 1.0) : 0.0;
    }

    public static double wvar(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wvar(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wvar(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(DoubleVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)w * c;
                sum2 += (double)w * c * c;
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wvar(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wvar(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(DoubleVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                short w = wi.nextShort();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)w * c;
                sum2 += (double)w * c * c;
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wvar(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wvar(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(DoubleVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                int w = wi.nextInt();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)w * c;
                sum2 += (double)w * c * c;
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wvar(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wvar(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(DoubleVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                long w = wi.nextLong();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)w * c;
                sum2 += (double)w * c * c;
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wvar(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wvar(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(DoubleVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += (double)w * c;
                sum2 += (double)w * c * c;
                count += (double)w;
                count2 += (double)(w * w);
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double wvar(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wvar(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wvar(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wvar(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wvar(DoubleVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double count = 0.0;
        double count2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c) || Numeric.isInf(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w) || Numeric.isInf(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                sum += w * c;
                sum2 += w * c * c;
                count += w;
                count2 += w * w;
            }
        }
        if (count <= 1.0) return Double.NaN;
        if (Double.isInfinite(sum)) return Double.NaN;
        if (!Double.isInfinite(sum2)) return (count * sum2 - sum * sum) / (count * count - count2);
        return Double.NaN;
    }

    public static double std(Double[] values) {
        return Numeric.std(Basic.unbox(values));
    }

    public static double std(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.std((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double std(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.var(values);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wstd(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wstd(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wstd(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wstd(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wstd(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wstd(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wstd(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wstd(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wstd(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wstd(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double wstd(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wstd(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wstd(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wstd(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double v = Numeric.wvar(values, weights);
        return v == -1.7976931348623157E308 ? -1.7976931348623157E308 : Math.sqrt(v);
    }

    public static double ste(Double[] values) {
        return Numeric.ste(Basic.unbox(values));
    }

    public static double ste(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.ste((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double ste(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double s = Numeric.std(values);
        long c = Basic.count(values);
        return s == -1.7976931348623157E308 || c == Long.MIN_VALUE ? -1.7976931348623157E308 : s / Math.sqrt(c);
    }

    public static double wste(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wste(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wste(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                byte w = wi.nextByte();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wste(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wste(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                short w = wi.nextShort();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wste(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wste(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                int w = wi.nextInt();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wste(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wste(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                long w = wi.nextLong();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wste(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wste(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                float w = wi.nextFloat();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += (double)w;
                sumw2 += (double)(w * w);
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double wste(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wste(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wste(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wste(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        if (values.size() != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double sumw = 0.0;
        double sumw2 = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                double w = wi.nextDouble();
                if (Basic.isNull(v) || Basic.isNull(w)) continue;
                sumw += w;
                sumw2 += w * w;
            }
        }
        double s = Numeric.wstd(values, weights);
        return s == -1.7976931348623157E308 ? -1.7976931348623157E308 : s * Math.sqrt(sumw2 / sumw / sumw);
    }

    public static double tstat(Double[] values) {
        return Numeric.tstat(Basic.unbox(values));
    }

    public static double tstat(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.tstat((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double tstat(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.avg(values);
        double s = Numeric.ste(values);
        return a == -1.7976931348623157E308 || s == -1.7976931348623157E308 ? -1.7976931348623157E308 : Numeric.avg(values) / Numeric.ste(values);
    }

    public static double wtstat(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wtstat(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wtstat(DoubleVector values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wtstat(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wtstat(DoubleVector values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wtstat(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (IntVector)new IntVectorDirect(weights));
    }

    public static double wtstat(DoubleVector values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wtstat(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (LongVector)new LongVectorDirect(weights));
    }

    public static double wtstat(DoubleVector values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wtstat(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wtstat(DoubleVector values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double wtstat(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wtstat(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wtstat(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wtstat(DoubleVector values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        double a = Numeric.wavg(values, weights);
        double s = Numeric.wste(values, weights);
        return a / s;
    }

    public static double max(DoubleVector values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? -1.7976931348623157E308 : values.get(idx);
    }

    public static double max(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.max((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double max(Double[] values) {
        long idx = Numeric.indexOfMax(values);
        return idx == Long.MIN_VALUE ? -1.7976931348623157E308 : values[LongSizedDataStructure.intSize((String)"max", (long)idx)];
    }

    public static double min(DoubleVector values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? -1.7976931348623157E308 : values.get(idx);
    }

    public static double min(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.min((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double min(Double[] values) {
        long idx = Numeric.indexOfMin(values);
        return idx == Long.MIN_VALUE ? -1.7976931348623157E308 : values[LongSizedDataStructure.intSize((String)"min", (long)idx)];
    }

    public static long indexOfMax(Double[] values) {
        return Numeric.indexOfMax(Basic.unbox(values));
    }

    public static long indexOfMax(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMax((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long indexOfMax(DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        double val = Double.NEGATIVE_INFINITY;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (!Basic.isNull(c) && (c > val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static long indexOfMin(Double[] values) {
        return Numeric.indexOfMin(Basic.unbox(values));
    }

    public static long indexOfMin(double ... values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        return Numeric.indexOfMin((DoubleVector)new DoubleVectorDirect(values));
    }

    public static long indexOfMin(DoubleVector values) {
        if (values == null) {
            return Long.MIN_VALUE;
        }
        double val = Double.POSITIVE_INFINITY;
        long index = Long.MIN_VALUE;
        long count = 0L;
        long i = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (!Basic.isNull(c) && (c < val || c == val && count == 0L)) {
                    val = c;
                    index = i;
                    ++count;
                }
                ++i;
            }
        }
        return count == 0L ? Long.MIN_VALUE : index;
    }

    public static double median(Double[] values) {
        return Numeric.median(Basic.unbox(values));
    }

    public static double median(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.median((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double median(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        int n = values.intSize("median");
        if (n == 0) {
            return Double.NaN;
        }
        double[] copy = values.copyToArray();
        Arrays.sort(copy);
        if (n % 2 == 0) {
            return 0.5 * (copy[n / 2 - 1] + copy[n / 2]);
        }
        return copy[n / 2];
    }

    public static double percentile(double percentile, double ... values) {
        if (values == null || values.length == 0) {
            return -1.7976931348623157E308;
        }
        return Numeric.percentile(percentile, (DoubleVector)new DoubleVectorDirect(values));
    }

    public static double percentile(double percentile, DoubleVector values) {
        if (values == null || values.isEmpty()) {
            return -1.7976931348623157E308;
        }
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile = " + percentile);
        }
        int n = values.intSize("percentile");
        double[] copy = values.copyToArray();
        Arrays.sort(copy);
        int idx = (int)Math.round(percentile * (double)(n - 1));
        return copy[idx];
    }

    public static double cov(double[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cov(double[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cov(DoubleVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(DoubleVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum1 += (double)v1;
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(double[] values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), (ByteVector)new ByteVectorDirect(values1));
    }

    public static double cor(double[] values0, ByteVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cor(DoubleVector values0, byte[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ByteVector)new ByteVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(DoubleVector values0, ByteVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfByte v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                byte v1 = v1i.nextByte();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum0Sq += v0 * v0;
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(double[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cov(double[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cov(DoubleVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(DoubleVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum1 += (double)v1;
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(double[] values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), (ShortVector)new ShortVectorDirect(values1));
    }

    public static double cor(double[] values0, ShortVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cor(DoubleVector values0, short[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (ShortVector)new ShortVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(DoubleVector values0, ShortVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfShort v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                short v1 = v1i.nextShort();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum0Sq += v0 * v0;
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(double[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cov(double[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cov(DoubleVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(DoubleVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum1 += (double)v1;
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(double[] values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), (IntVector)new IntVectorDirect(values1));
    }

    public static double cor(double[] values0, IntVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cor(DoubleVector values0, int[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (IntVector)new IntVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(DoubleVector values0, IntVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfInt v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                int v1 = v1i.nextInt();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum0Sq += v0 * v0;
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(double[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cov(double[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cov(DoubleVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(DoubleVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum1 += (double)v1;
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(double[] values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), (LongVector)new LongVectorDirect(values1));
    }

    public static double cor(double[] values0, LongVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cor(DoubleVector values0, long[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (LongVector)new LongVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(DoubleVector values0, LongVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfLong v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                long v1 = v1i.nextLong();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum0Sq += v0 * v0;
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(double[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cov(double[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cov(DoubleVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(DoubleVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum1 += (double)v1;
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(double[] values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), (FloatVector)new FloatVectorDirect(values1));
    }

    public static double cor(double[] values0, FloatVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cor(DoubleVector values0, float[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (FloatVector)new FloatVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(DoubleVector values0, FloatVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfFloat v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                float v1 = v1i.nextFloat();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum0Sq += v0 * v0;
                sum1 += (double)v1;
                sum1Sq += (double)(v1 * v1);
                sum01 += v0 * (double)v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double cov(double[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cov(double[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cov(DoubleVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cov(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cov(DoubleVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum1 = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum1 += v1;
                sum01 += v0 * v1;
                count += 1.0;
            }
            return sum01 / count - sum0 * sum1 / count / count;
        }
    }

    public static double cor(double[] values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), (DoubleVector)new DoubleVectorDirect(values1));
    }

    public static double cor(double[] values0, DoubleVector values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor((DoubleVector)new DoubleVectorDirect(values0), values1);
    }

    public static double cor(DoubleVector values0, double[] values1) {
        if (values0 == null || values1 == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.cor(values0, (DoubleVector)new DoubleVectorDirect(values1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double cor(DoubleVector values0, DoubleVector values1) {
        if (values0 == null) return -1.7976931348623157E308;
        if (values1 == null) {
            return -1.7976931348623157E308;
        }
        if (values0.size() != values1.size()) {
            throw new IllegalArgumentException("Input arrays are different lengths!");
        }
        double sum0 = 0.0;
        double sum0Sq = 0.0;
        double sum1 = 0.0;
        double sum1Sq = 0.0;
        double sum01 = 0.0;
        double count = 0.0;
        try (CloseablePrimitiveIteratorOfDouble v0i = values0.iterator();
             CloseablePrimitiveIteratorOfDouble v1i = values1.iterator();){
            while (v0i.hasNext()) {
                double v0 = v0i.nextDouble();
                double v1 = v1i.nextDouble();
                if (Numeric.isNaN(v0) || Numeric.isInf(v0)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(v1) || Numeric.isInf(v1)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(v0) || Basic.isNull(v1)) continue;
                sum0 += v0;
                sum0Sq += v0 * v0;
                sum1 += v1;
                sum1Sq += v1 * v1;
                sum01 += v0 * v1;
                count += 1.0;
            }
        }
        double cov = sum01 / count - sum0 * sum1 / count / count;
        double var0 = sum0Sq / count - sum0 * sum0 / count / count;
        double var1 = sum1Sq / count - sum1 * sum1 / count / count;
        return cov / Math.sqrt(var0 * var1);
    }

    public static double sum(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double sum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c)) continue;
                sum += c;
            }
        }
        return sum;
    }

    public static double sum(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.sum((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double product(DoubleVector values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        double prod = 1.0;
        int count = 0;
        long zeroCount = 0L;
        long infCount = 0L;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Double.isInfinite(c)) {
                    if (zeroCount > 0L) {
                        double d = Double.NaN;
                        return d;
                    }
                    ++infCount;
                } else if (c == 0.0) {
                    if (infCount > 0L) {
                        double d = Double.NaN;
                        return d;
                    }
                    ++zeroCount;
                }
                if (Basic.isNull(c)) continue;
                ++count;
                prod *= c;
            }
        }
        if (count == 0) {
            return -1.7976931348623157E308;
        }
        return zeroCount > 0L ? 0.0 : prod;
    }

    public static double product(double ... values) {
        if (values == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.product((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] cummin(Double[] values) {
        return Numeric.cummin(Basic.unbox(values));
    }

    public static double[] cummin(double ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummin((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] cummin(DoubleVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new double[0];
        }
        int n = values.intSize("cummin");
        double[] result = new double[n];
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            result[0] = vi.nextDouble();
            int i = 1;
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.min(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static double[] cummax(Double[] values) {
        return Numeric.cummax(Basic.unbox(values));
    }

    public static double[] cummax(double ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cummax((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] cummax(DoubleVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new double[0];
        }
        int n = values.intSize("cummax");
        double[] result = new double[n];
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            result[0] = vi.nextDouble();
            int i = 1;
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : Math.max(result[i - 1], v));
                ++i;
            }
        }
        return result;
    }

    public static double[] cumsum(Double[] values) {
        return Numeric.cumsum(Basic.unbox(values));
    }

    public static double[] cumsum(double ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumsum((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] cumsum(DoubleVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new double[0];
        }
        int n = values.intSize("cumsum");
        double[] result = new double[n];
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            result[0] = vi.nextDouble();
            int i = 1;
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] + v);
                ++i;
            }
        }
        return result;
    }

    public static double[] cumprod(Double[] values) {
        return Numeric.cumprod(Basic.unbox(values));
    }

    public static double[] cumprod(double ... values) {
        if (values == null) {
            return null;
        }
        return Numeric.cumprod((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] cumprod(DoubleVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new double[0];
        }
        int n = values.intSize("cumprod");
        double[] result = new double[n];
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            result[0] = vi.nextDouble();
            int i = 1;
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Basic.isNull(result[i - 1]) ? v : (Basic.isNull(v) ? result[i - 1] : result[i - 1] * v);
                ++i;
            }
        }
        return result;
    }

    public static double abs(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.abs(value);
    }

    public static double acos(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.acos(value);
    }

    public static double asin(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.asin(value);
    }

    public static double atan(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.atan(value);
    }

    public static double ceil(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.ceil(value);
    }

    public static double cos(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.cos(value);
    }

    public static double exp(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.exp(value);
    }

    public static double floor(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.floor(value);
    }

    public static double log(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.log(value);
    }

    public static double pow(double a, byte b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(double a, short b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(double a, int b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(double a, long b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(double a, float b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double pow(double a, double b) {
        if (Basic.isNull(a) || Basic.isNull(b)) {
            return -1.7976931348623157E308;
        }
        return Math.pow(a, b);
    }

    public static double rint(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.rint(value);
    }

    public static long round(double value) {
        if (Basic.isNull(value)) {
            return Long.MIN_VALUE;
        }
        return Math.round(value);
    }

    public static int signum(double value) {
        if (Basic.isNull(value)) {
            return Integer.MIN_VALUE;
        }
        return Integer.signum((int)value);
    }

    public static double sin(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sin(value);
    }

    public static double sqrt(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt(value);
    }

    public static double tan(double value) {
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        return Math.tan(value);
    }

    public static double lowerBin(double value, double interval) {
        if (value == -1.7976931348623157E308 || interval == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        return interval * Math.floor(value / interval);
    }

    public static double lowerBin(double value, double interval, double offset) {
        if (value == -1.7976931348623157E308 || interval == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        return Numeric.lowerBin(value - offset, interval) + offset;
    }

    public static double upperBin(double value, double interval) {
        if (value == -1.7976931348623157E308 || interval == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval is not positive: " + interval);
        }
        return interval * Math.ceil(value / interval);
    }

    public static double upperBin(double value, double interval, double offset) {
        if (value == -1.7976931348623157E308 || interval == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        return Numeric.upperBin(value - offset, interval) + offset;
    }

    public static double clamp(double value, double min, double max) {
        Require.leq((double)min, (String)"min", (double)max, (String)"max");
        if (Basic.isNull(value)) {
            return -1.7976931348623157E308;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double wsum(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wsum(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wsum(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(DoubleVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
            }
            return vsum;
        }
    }

    public static double wavg(double[] values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), (ByteVector)new ByteVectorDirect(weights));
    }

    public static double wavg(double[] values, ByteVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wavg(DoubleVector values, byte[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ByteVector)new ByteVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(DoubleVector values, ByteVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfByte wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                byte w = wi.nextByte();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wsum(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wsum(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(DoubleVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
            }
            return vsum;
        }
    }

    public static double wavg(double[] values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), (ShortVector)new ShortVectorDirect(weights));
    }

    public static double wavg(double[] values, ShortVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wavg(DoubleVector values, short[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (ShortVector)new ShortVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(DoubleVector values, ShortVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfShort wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                short w = wi.nextShort();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wsum(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wsum(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(DoubleVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
            }
            return vsum;
        }
    }

    public static double wavg(double[] values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), (IntVector)new IntVectorDirect(weights));
    }

    public static double wavg(double[] values, IntVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wavg(DoubleVector values, int[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (IntVector)new IntVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(DoubleVector values, IntVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfInt wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                int w = wi.nextInt();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wsum(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wsum(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(DoubleVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
            }
            return vsum;
        }
    }

    public static double wavg(double[] values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), (LongVector)new LongVectorDirect(weights));
    }

    public static double wavg(double[] values, LongVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wavg(DoubleVector values, long[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (LongVector)new LongVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(DoubleVector values, LongVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfLong wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                long w = wi.nextLong();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wsum(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wsum(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(DoubleVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
            }
            return vsum;
        }
    }

    public static double wavg(double[] values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), (FloatVector)new FloatVectorDirect(weights));
    }

    public static double wavg(double[] values, FloatVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wavg(DoubleVector values, float[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (FloatVector)new FloatVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(DoubleVector values, FloatVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfFloat wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                float w = wi.nextFloat();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * (double)w;
                wsum += (double)w;
            }
            return vsum / wsum;
        }
    }

    public static double wsum(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wsum(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wsum(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wsum(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wsum(DoubleVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * w;
            }
            return vsum;
        }
    }

    public static double wavg(double[] values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), (DoubleVector)new DoubleVectorDirect(weights));
    }

    public static double wavg(double[] values, DoubleVector weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg((DoubleVector)new DoubleVectorDirect(values), weights);
    }

    public static double wavg(DoubleVector values, double[] weights) {
        if (values == null || weights == null) {
            return -1.7976931348623157E308;
        }
        return Numeric.wavg(values, (DoubleVector)new DoubleVectorDirect(weights));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double wavg(DoubleVector values, DoubleVector weights) {
        if (values == null) return -1.7976931348623157E308;
        if (weights == null) {
            return -1.7976931348623157E308;
        }
        long n = values.size();
        if (n != weights.size()) {
            throw new IllegalArgumentException("Incompatible input sizes: " + values.size() + ", " + weights.size());
        }
        double vsum = 0.0;
        double wsum = 0.0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();
             CloseablePrimitiveIteratorOfDouble wi = weights.iterator();){
            while (vi.hasNext()) {
                double c = vi.nextDouble();
                double w = wi.nextDouble();
                if (Numeric.isNaN(c)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Numeric.isNaN(w)) {
                    double d = Double.NaN;
                    return d;
                }
                if (Basic.isNull(c) || Basic.isNull(w)) continue;
                vsum += c * w;
                wsum += w;
            }
            return vsum / wsum;
        }
    }

    public static double[] sequence(double start, double end, double step) {
        if (step == 0.0) {
            return new double[0];
        }
        int n = (int)((end - start) / step);
        if (n < 0) {
            return new double[0];
        }
        double[] result = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            result[i] = start + (double)i * step;
        }
        return result;
    }

    public static boolean isNaN(Double value) {
        return value != null && Double.isNaN(value);
    }

    public static boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    public static boolean isInf(Double value) {
        return value != null && Double.isInfinite(value);
    }

    public static boolean isInf(double value) {
        return Double.isInfinite(value);
    }

    public static boolean isFinite(Double value) {
        return Numeric.isFinite(Cast.castDouble((double)value));
    }

    public static boolean isFinite(double value) {
        return Double.isFinite(value) && !Basic.isNull(value);
    }

    public static boolean containsNonFinite(Double[] values) {
        return Numeric.containsNonFinite(Basic.unbox(values));
    }

    public static boolean containsNonFinite(double ... values) {
        for (double v1 : values) {
            if (Numeric.isFinite(v1)) continue;
            return true;
        }
        return false;
    }

    public static double replaceIfNaN(double value, double replacement) {
        if (Numeric.isNaN(value)) {
            return replacement;
        }
        return value;
    }

    public static double[] replaceIfNaN(double[] values, double replacement) {
        return Numeric.replaceIfNaN((DoubleVector)new DoubleVectorDirect(values), replacement);
    }

    public static double[] replaceIfNaN(DoubleVector values, double replacement) {
        int n = values.intSize("replaceIfNaN");
        double[] result = new double[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Numeric.replaceIfNaN(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static double replaceIfNullNaN(double value, double replacement) {
        if (Numeric.isNaN(value) || Basic.isNull(value)) {
            return replacement;
        }
        return value;
    }

    public static double[] replaceIfNullNaN(double[] values, double replacement) {
        return Numeric.replaceIfNullNaN((DoubleVector)new DoubleVectorDirect(values), replacement);
    }

    public static double[] replaceIfNullNaN(DoubleVector values, double replacement) {
        int n = values.intSize("replaceIfNullNaN");
        double[] result = new double[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Numeric.replaceIfNullNaN(v, replacement);
                ++i;
            }
        }
        return result;
    }

    public static double replaceIfNonFinite(double value, double replacement) {
        return Numeric.isFinite(value) ? value : replacement;
    }

    public static double[] replaceIfNonFinite(double[] values, double replacement) {
        return Numeric.replaceIfNonFinite((DoubleVector)new DoubleVectorDirect(values), replacement);
    }

    public static double[] replaceIfNonFinite(DoubleVector values, double replacement) {
        int n = values.intSize("replaceIfNonFinite");
        double[] result = new double[n];
        int i = 0;
        try (CloseablePrimitiveIteratorOfDouble vi = values.iterator();){
            while (vi.hasNext()) {
                double v = vi.nextDouble();
                result[i] = Numeric.replaceIfNonFinite(v, replacement);
                ++i;
            }
        }
        return result;
    }
}

