/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.Basic;
import io.deephaven.util.QueryConstants;

public class Parse {
    public static byte parseByte(String s) {
        if (s == null) {
            return -128;
        }
        return Byte.parseByte(s);
    }

    public static byte parseByte(String s, int radix) {
        if (s == null || Basic.isNull(radix)) {
            return -128;
        }
        return Byte.parseByte(s, radix);
    }

    public static short parseShort(String s) {
        if (s == null) {
            return Short.MIN_VALUE;
        }
        return Short.parseShort(s);
    }

    public static short parseShort(String s, int radix) {
        if (s == null || Basic.isNull(radix)) {
            return Short.MIN_VALUE;
        }
        return Short.parseShort(s, radix);
    }

    public static int parseInt(String s) {
        if (s == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(s);
    }

    public static int parseInt(String s, int radix) {
        if (s == null || Basic.isNull(radix)) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(s, radix);
    }

    public static int parseUnsignedInt(String s) {
        if (s == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseUnsignedInt(s);
    }

    public static int parseUnsignedInt(String s, int radix) {
        if (s == null || Basic.isNull(radix)) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseUnsignedInt(s, radix);
    }

    public static long parseLong(String s) {
        if (s == null) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(s);
    }

    public static long parseLong(String s, int radix) {
        if (s == null || Basic.isNull(radix)) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(s, radix);
    }

    public static long parseUnsignedLong(String s) {
        if (s == null) {
            return Long.MIN_VALUE;
        }
        return Long.parseUnsignedLong(s);
    }

    public static long parseUnsignedLong(String s, int radix) {
        if (s == null || Basic.isNull(radix)) {
            return Long.MIN_VALUE;
        }
        return Long.parseUnsignedLong(s, radix);
    }

    public static double parseDouble(String s) {
        if (s == null) {
            return -1.7976931348623157E308;
        }
        return Double.parseDouble(s);
    }

    public static float parseFloat(String s) {
        if (s == null) {
            return -3.4028235E38f;
        }
        return Float.parseFloat(s);
    }

    public static Boolean parseBoolean(String s) {
        if (s == null) {
            return QueryConstants.NULL_BOOLEAN;
        }
        return s.equalsIgnoreCase("true");
    }
}

