/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import java.util.concurrent.ThreadLocalRandom;

public class Random {
    public static double random() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static boolean randomBool() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static boolean[] randomBool(int size) {
        boolean[] result = new boolean[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Random.randomBool();
        }
        return result;
    }

    public static int randomInt(int min, int max) {
        return min + ThreadLocalRandom.current().nextInt(max - min);
    }

    public static int[] randomInt(int min, int max, int size) {
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Random.randomInt(min, max);
        }
        return result;
    }

    public static long randomLong(long min, long max) {
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    public static long[] randomLong(long min, long max, int size) {
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Random.randomLong(min, max);
        }
        return result;
    }

    public static float randomFloat(float min, float max) {
        return (float)ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static float[] randomFloat(float min, float max, int size) {
        float[] result = new float[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Random.randomFloat(min, max);
        }
        return result;
    }

    public static double randomDouble(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static double[] randomDouble(double min, double max, int size) {
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Random.randomDouble(min, max);
        }
        return result;
    }

    public static double randomGaussian(double mean, double std) {
        return mean + std * ThreadLocalRandom.current().nextGaussian();
    }

    public static double[] randomGaussian(double mean, double std, int size) {
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Random.randomGaussian(mean, std);
        }
        return result;
    }
}

