/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.Basic;
import io.deephaven.function.comparators.NullNaNAwareComparator;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.ByteVectorDirect;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.DoubleVectorDirect;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.FloatVectorDirect;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.IntVectorDirect;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.LongVectorDirect;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import io.deephaven.vector.ShortVector;
import io.deephaven.vector.ShortVectorDirect;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.ArrayUtils;

public class Sort {
    public static <T extends Comparable<? super T>> T[] sortObj(ObjectVector<T> values, Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return (Comparable[])values.toArray();
        }
        Comparable[] vs = (Comparable[])values.copyToArray();
        Arrays.sort(vs, comparator);
        return vs;
    }

    public static <T extends Comparable<? super T>> T[] sortObj(ObjectVector<T> values) {
        return Sort.sortObj(values, new NullNaNAwareComparator());
    }

    public static <T extends Comparable<? super T>> T[] sortObj(T[] values, Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        Comparable[] copy = (Comparable[])Arrays.copyOf(values, values.length);
        if (copy.length == 0) {
            return copy;
        }
        Arrays.sort(copy, comparator);
        return copy;
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T[] sortObj(T ... values) {
        return Sort.sortObj(values, new NullNaNAwareComparator());
    }

    public static <T extends Comparable<? super T>> T[] sortDescendingObj(ObjectVector<T> values, Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return (Comparable[])values.toArray();
        }
        Comparable[] vs = (Comparable[])values.copyToArray();
        Arrays.sort(vs, comparator.reversed());
        return vs;
    }

    public static <T extends Comparable<? super T>> T[] sortDescendingObj(ObjectVector<T> values) {
        return Sort.sortDescendingObj(values, new NullNaNAwareComparator());
    }

    public static <T extends Comparable<? super T>> T[] sortDescendingObj(T[] values, Comparator<T> comparator) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescendingObj((ObjectVector)new ObjectVectorDirect((Object[])values), comparator);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T[] sortDescendingObj(T ... values) {
        return Sort.sortDescendingObj(values, new NullNaNAwareComparator());
    }

    public static byte[] sort(ByteVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        byte[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    public static byte[] sort(byte ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sort((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] sort(Byte[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new byte[0];
        }
        byte[] vs = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            vs[i] = Basic.isNull(values[i]) ? -128 : (int)values[i].byteValue();
        }
        Arrays.sort(vs);
        return vs;
    }

    public static byte[] sortDescending(ByteVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        byte[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse((byte[])vs);
        return vs;
    }

    public static byte[] sortDescending(byte ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescending((ByteVector)new ByteVectorDirect(values));
    }

    public static byte[] sortDescending(Byte[] values) {
        if (values == null) {
            return null;
        }
        byte[] result = Sort.sort(values);
        ArrayUtils.reverse((byte[])result);
        return result;
    }

    public static short[] sort(ShortVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        short[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    public static short[] sort(short ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sort((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] sort(Short[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new short[0];
        }
        short[] vs = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            vs[i] = Basic.isNull(values[i]) ? Short.MIN_VALUE : (int)values[i].shortValue();
        }
        Arrays.sort(vs);
        return vs;
    }

    public static short[] sortDescending(ShortVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        short[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse((short[])vs);
        return vs;
    }

    public static short[] sortDescending(short ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescending((ShortVector)new ShortVectorDirect(values));
    }

    public static short[] sortDescending(Short[] values) {
        if (values == null) {
            return null;
        }
        short[] result = Sort.sort(values);
        ArrayUtils.reverse((short[])result);
        return result;
    }

    public static int[] sort(IntVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        int[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    public static int[] sort(int ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sort((IntVector)new IntVectorDirect(values));
    }

    public static int[] sort(Integer[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new int[0];
        }
        int[] vs = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            vs[i] = Basic.isNull(values[i]) ? Integer.MIN_VALUE : values[i];
        }
        Arrays.sort(vs);
        return vs;
    }

    public static int[] sortDescending(IntVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        int[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse((int[])vs);
        return vs;
    }

    public static int[] sortDescending(int ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescending((IntVector)new IntVectorDirect(values));
    }

    public static int[] sortDescending(Integer[] values) {
        if (values == null) {
            return null;
        }
        int[] result = Sort.sort(values);
        ArrayUtils.reverse((int[])result);
        return result;
    }

    public static long[] sort(LongVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        long[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    public static long[] sort(long ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sort((LongVector)new LongVectorDirect(values));
    }

    public static long[] sort(Long[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new long[0];
        }
        long[] vs = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            vs[i] = Basic.isNull(values[i]) ? Long.MIN_VALUE : values[i];
        }
        Arrays.sort(vs);
        return vs;
    }

    public static long[] sortDescending(LongVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        long[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse((long[])vs);
        return vs;
    }

    public static long[] sortDescending(long ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescending((LongVector)new LongVectorDirect(values));
    }

    public static long[] sortDescending(Long[] values) {
        if (values == null) {
            return null;
        }
        long[] result = Sort.sort(values);
        ArrayUtils.reverse((long[])result);
        return result;
    }

    public static float[] sort(FloatVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        float[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    public static float[] sort(float ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sort((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] sort(Float[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new float[0];
        }
        float[] vs = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            vs[i] = Basic.isNull(values[i]) ? -3.4028235E38f : values[i].floatValue();
        }
        Arrays.sort(vs);
        return vs;
    }

    public static float[] sortDescending(FloatVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        float[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse((float[])vs);
        return vs;
    }

    public static float[] sortDescending(float ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescending((FloatVector)new FloatVectorDirect(values));
    }

    public static float[] sortDescending(Float[] values) {
        if (values == null) {
            return null;
        }
        float[] result = Sort.sort(values);
        ArrayUtils.reverse((float[])result);
        return result;
    }

    public static double[] sort(DoubleVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        double[] vs = values.copyToArray();
        Arrays.sort(vs);
        return vs;
    }

    public static double[] sort(double ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sort((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] sort(Double[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return new double[0];
        }
        double[] vs = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            vs[i] = Basic.isNull(values[i]) ? -1.7976931348623157E308 : values[i];
        }
        Arrays.sort(vs);
        return vs;
    }

    public static double[] sortDescending(DoubleVector values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return values.toArray();
        }
        double[] vs = values.copyToArray();
        Arrays.sort(vs);
        ArrayUtils.reverse((double[])vs);
        return vs;
    }

    public static double[] sortDescending(double ... values) {
        if (values == null) {
            return null;
        }
        return Sort.sortDescending((DoubleVector)new DoubleVectorDirect(values));
    }

    public static double[] sortDescending(Double[] values) {
        if (values == null) {
            return null;
        }
        double[] result = Sort.sort(values);
        ArrayUtils.reverse((double[])result);
        return result;
    }
}

