/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function.comparators;

import io.deephaven.function.Basic;
import java.util.Comparator;

public class NullNaNAwareComparator<T extends Comparable<? super T>>
implements Comparator<T> {
    private static <T> boolean isNanVal(T v) {
        if (v instanceof Float) {
            return Float.isNaN(((Float)v).floatValue());
        }
        if (v instanceof Double) {
            return Double.isNaN((Double)v);
        }
        return false;
    }

    @Override
    public int compare(T o1, T o2) {
        boolean isNull1 = Basic.isNull(o1);
        boolean isNull2 = Basic.isNull(o2);
        if (isNull1 && isNull2) {
            return 0;
        }
        if (isNull1) {
            return -1;
        }
        if (isNull2) {
            return 1;
        }
        boolean isNaN1 = NullNaNAwareComparator.isNanVal(o1);
        boolean isNaN2 = NullNaNAwareComparator.isNanVal(o2);
        if (isNaN1 && isNaN2) {
            return 0;
        }
        if (isNaN1) {
            return 1;
        }
        if (isNaN2) {
            return -1;
        }
        return o1.compareTo(o2);
    }
}

