/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.engine.primitive.function.ByteConsumer;
import io.deephaven.engine.primitive.function.ByteToIntFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.SafeCloseableArray;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CloseablePrimitiveIteratorOfByte
extends CloseablePrimitiveIterator<Byte, ByteConsumer> {
    public static final CloseablePrimitiveIteratorOfByte EMPTY = new CloseablePrimitiveIteratorOfByte(){

        @Override
        public byte nextByte() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public byte nextByte();

    @Override
    default public void forEachRemaining(@NotNull ByteConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextByte());
        }
    }

    @Override
    default public Byte next() {
        return this.nextByte();
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Byte> action) {
        if (action instanceof ByteConsumer) {
            this.forEachRemaining((ByteConsumer)((Object)action));
        } else {
            Objects.requireNonNull(action);
            this.forEachRemaining(action::accept);
        }
    }

    default public CloseablePrimitiveIteratorOfInt adaptToOfInt(final @NotNull ByteToIntFunction adapter) {
        return new CloseablePrimitiveIteratorOfInt(){

            @Override
            public boolean hasNext() {
                return CloseablePrimitiveIteratorOfByte.this.hasNext();
            }

            @Override
            public int nextInt() {
                return adapter.applyAsInt(CloseablePrimitiveIteratorOfByte.this.next());
            }

            @Override
            public void close() {
                CloseablePrimitiveIteratorOfByte.this.close();
            }
        };
    }

    default public IntStream streamAsInt(@NotNull ByteToIntFunction adapter) {
        return this.adaptToOfInt(adapter).intStream();
    }

    default public IntStream streamAsInt() {
        return this.streamAsInt(value -> value);
    }

    public static CloseablePrimitiveIteratorOfByte empty() {
        return EMPTY;
    }

    public static CloseablePrimitiveIteratorOfByte of(final byte ... values) {
        Objects.requireNonNull(values);
        return new CloseablePrimitiveIteratorOfByte(){
            private int valueIndex;

            @Override
            public byte nextByte() {
                if (this.valueIndex < values.length) {
                    return values[this.valueIndex++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfByte repeat(final byte value, final long repeatCount) {
        return new CloseablePrimitiveIteratorOfByte(){
            private long repeatIndex;

            @Override
            public byte nextByte() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfByte concat(final CloseablePrimitiveIteratorOfByte ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseablePrimitiveIteratorOfByte.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseablePrimitiveIteratorOfByte(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public byte nextByte() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].nextByte();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((SafeCloseable[])subIterators);
            }
        };
    }

    public static CloseablePrimitiveIteratorOfByte maybeConcat(@Nullable CloseablePrimitiveIteratorOfByte first, @Nullable CloseablePrimitiveIteratorOfByte second, @Nullable CloseablePrimitiveIteratorOfByte third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseablePrimitiveIteratorOfByte.concat(first, second, third);
                }
                return CloseablePrimitiveIteratorOfByte.concat(first, second);
            }
            if (third != null) {
                return CloseablePrimitiveIteratorOfByte.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseablePrimitiveIteratorOfByte.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseablePrimitiveIteratorOfByte.empty();
    }
}

