/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIterator;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.SafeCloseableArray;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public interface CloseablePrimitiveIteratorOfDouble
extends PrimitiveIterator.OfDouble,
CloseablePrimitiveIterator<Double, DoubleConsumer> {
    public static final CloseablePrimitiveIteratorOfDouble EMPTY = new CloseablePrimitiveIteratorOfDouble(){

        @Override
        public double nextDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    default public DoubleStream doubleStream() {
        return (DoubleStream)StreamSupport.doubleStream(Spliterators.spliteratorUnknownSize(this, 1040), false).onClose(this::close);
    }

    public static CloseablePrimitiveIteratorOfDouble empty() {
        return EMPTY;
    }

    public static CloseablePrimitiveIteratorOfDouble of(final double ... values) {
        Objects.requireNonNull(values);
        return new CloseablePrimitiveIteratorOfDouble(){
            private int valueIndex;

            @Override
            public double nextDouble() {
                return values[this.valueIndex++];
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfDouble repeat(final double value, final long repeatCount) {
        return new CloseablePrimitiveIteratorOfDouble(){
            private long repeatIndex;

            @Override
            public double nextDouble() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfDouble concat(final CloseablePrimitiveIteratorOfDouble ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseablePrimitiveIteratorOfDouble.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseablePrimitiveIteratorOfDouble(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public double nextDouble() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].nextDouble();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((SafeCloseable[])subIterators);
            }
        };
    }

    public static CloseablePrimitiveIteratorOfDouble maybeConcat(@Nullable CloseablePrimitiveIteratorOfDouble first, @Nullable CloseablePrimitiveIteratorOfDouble second, @Nullable CloseablePrimitiveIteratorOfDouble third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseablePrimitiveIteratorOfDouble.concat(first, second, third);
                }
                return CloseablePrimitiveIteratorOfDouble.concat(first, second);
            }
            if (third != null) {
                return CloseablePrimitiveIteratorOfDouble.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseablePrimitiveIteratorOfDouble.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseablePrimitiveIteratorOfDouble.empty();
    }
}

