/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIterator;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.SafeCloseableArray;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public interface CloseablePrimitiveIteratorOfInt
extends PrimitiveIterator.OfInt,
CloseablePrimitiveIterator<Integer, IntConsumer> {
    public static final CloseablePrimitiveIteratorOfInt EMPTY = new CloseablePrimitiveIteratorOfInt(){

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    default public IntStream intStream() {
        return (IntStream)StreamSupport.intStream(Spliterators.spliteratorUnknownSize(this, 1040), false).onClose(this::close);
    }

    public static CloseablePrimitiveIteratorOfInt empty() {
        return EMPTY;
    }

    public static CloseablePrimitiveIteratorOfInt of(final int ... values) {
        Objects.requireNonNull(values);
        return new CloseablePrimitiveIteratorOfInt(){
            private int valueIndex;

            @Override
            public int nextInt() {
                return values[this.valueIndex++];
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfInt repeat(final int value, final long repeatCount) {
        return new CloseablePrimitiveIteratorOfInt(){
            private long repeatIndex;

            @Override
            public int nextInt() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfInt concat(final CloseablePrimitiveIteratorOfInt ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseablePrimitiveIteratorOfInt.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseablePrimitiveIteratorOfInt(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public int nextInt() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].nextInt();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((SafeCloseable[])subIterators);
            }
        };
    }

    public static CloseablePrimitiveIteratorOfInt maybeConcat(@Nullable CloseablePrimitiveIteratorOfInt first, @Nullable CloseablePrimitiveIteratorOfInt second, @Nullable CloseablePrimitiveIteratorOfInt third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseablePrimitiveIteratorOfInt.concat(first, second, third);
                }
                return CloseablePrimitiveIteratorOfInt.concat(first, second);
            }
            if (third != null) {
                return CloseablePrimitiveIteratorOfInt.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseablePrimitiveIteratorOfInt.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseablePrimitiveIteratorOfInt.empty();
    }
}

