/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.util.SafeCloseableArray;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public interface CloseableIterator<TYPE>
extends Iterator<TYPE>,
AutoCloseable {
    public static final CloseableIterator<?> EMPTY = new CloseableIterator<Object>(){

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    default public Stream<TYPE> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 1040), false).onClose(this::close);
    }

    @Override
    default public void close() {
    }

    public static <TYPE> CloseableIterator<TYPE> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <TYPE> CloseableIterator<TYPE> of(final TYPE ... values) {
        Objects.requireNonNull(values);
        return new CloseableIterator<TYPE>(){
            private int valueIndex;

            @Override
            public TYPE next() {
                return values[this.valueIndex++];
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static <TYPE> CloseableIterator<TYPE> repeat(final TYPE value, final long repeatCount) {
        return new CloseableIterator<TYPE>(){
            private long repeatIndex;

            @Override
            public TYPE next() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    @SafeVarargs
    public static <TYPE> CloseableIterator<TYPE> concat(final CloseableIterator<TYPE> ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseableIterator.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseableIterator<TYPE>(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public TYPE next() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((AutoCloseable[])subIterators);
            }
        };
    }

    public static <TYPE> CloseableIterator<TYPE> maybeConcat(@Nullable CloseableIterator<TYPE> first, @Nullable CloseableIterator<TYPE> second, @Nullable CloseableIterator<TYPE> third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseableIterator.concat(first, second, third);
                }
                return CloseableIterator.concat(first, second);
            }
            if (third != null) {
                return CloseableIterator.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseableIterator.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseableIterator.empty();
    }
}

