/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.engine.primitive.function.CharConsumer;
import io.deephaven.engine.primitive.function.CharToIntFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.util.SafeCloseableArray;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CloseablePrimitiveIteratorOfChar
extends CloseablePrimitiveIterator<Character, CharConsumer> {
    public static final CloseablePrimitiveIteratorOfChar EMPTY = new CloseablePrimitiveIteratorOfChar(){

        @Override
        public char nextChar() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public char nextChar();

    @Override
    default public void forEachRemaining(@NotNull CharConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextChar());
        }
    }

    @Override
    default public Character next() {
        return Character.valueOf(this.nextChar());
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Character> action) {
        if (action instanceof CharConsumer) {
            this.forEachRemaining((CharConsumer)((Object)action));
        } else {
            Objects.requireNonNull(action);
            this.forEachRemaining(action::accept);
        }
    }

    default public CloseablePrimitiveIteratorOfInt adaptToOfInt(final @NotNull CharToIntFunction adapter) {
        return new CloseablePrimitiveIteratorOfInt(){

            @Override
            public boolean hasNext() {
                return CloseablePrimitiveIteratorOfChar.this.hasNext();
            }

            @Override
            public int nextInt() {
                return adapter.applyAsInt(CloseablePrimitiveIteratorOfChar.this.next().charValue());
            }

            @Override
            public void close() {
                CloseablePrimitiveIteratorOfChar.this.close();
            }
        };
    }

    default public IntStream streamAsInt(@NotNull CharToIntFunction adapter) {
        return this.adaptToOfInt(adapter).intStream();
    }

    default public IntStream streamAsInt() {
        return this.streamAsInt(value -> value);
    }

    public static CloseablePrimitiveIteratorOfChar empty() {
        return EMPTY;
    }

    public static CloseablePrimitiveIteratorOfChar of(final char ... values) {
        Objects.requireNonNull(values);
        return new CloseablePrimitiveIteratorOfChar(){
            private int valueIndex;

            @Override
            public char nextChar() {
                if (this.valueIndex < values.length) {
                    return values[this.valueIndex++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfChar repeat(final char value, final long repeatCount) {
        return new CloseablePrimitiveIteratorOfChar(){
            private long repeatIndex;

            @Override
            public char nextChar() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfChar concat(final CloseablePrimitiveIteratorOfChar ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseablePrimitiveIteratorOfChar.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseablePrimitiveIteratorOfChar(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public char nextChar() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].nextChar();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((AutoCloseable[])subIterators);
            }
        };
    }

    public static CloseablePrimitiveIteratorOfChar maybeConcat(@Nullable CloseablePrimitiveIteratorOfChar first, @Nullable CloseablePrimitiveIteratorOfChar second, @Nullable CloseablePrimitiveIteratorOfChar third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseablePrimitiveIteratorOfChar.concat(first, second, third);
                }
                return CloseablePrimitiveIteratorOfChar.concat(first, second);
            }
            if (third != null) {
                return CloseablePrimitiveIteratorOfChar.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseablePrimitiveIteratorOfChar.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseablePrimitiveIteratorOfChar.empty();
    }
}

