/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.engine.primitive.function.FloatConsumer;
import io.deephaven.engine.primitive.function.FloatToDoubleFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.util.SafeCloseableArray;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.DoubleStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CloseablePrimitiveIteratorOfFloat
extends CloseablePrimitiveIterator<Float, FloatConsumer> {
    public static final CloseablePrimitiveIteratorOfFloat EMPTY = new CloseablePrimitiveIteratorOfFloat(){

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public float nextFloat();

    @Override
    default public void forEachRemaining(@NotNull FloatConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextFloat());
        }
    }

    @Override
    default public Float next() {
        return Float.valueOf(this.nextFloat());
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Float> action) {
        if (action instanceof FloatConsumer) {
            this.forEachRemaining((FloatConsumer)((Object)action));
        } else {
            Objects.requireNonNull(action);
            this.forEachRemaining(action::accept);
        }
    }

    default public CloseablePrimitiveIteratorOfDouble adaptToOfDouble(final @NotNull FloatToDoubleFunction adapter) {
        return new CloseablePrimitiveIteratorOfDouble(){

            @Override
            public boolean hasNext() {
                return CloseablePrimitiveIteratorOfFloat.this.hasNext();
            }

            @Override
            public double nextDouble() {
                return adapter.applyAsDouble(CloseablePrimitiveIteratorOfFloat.this.next().floatValue());
            }

            @Override
            public void close() {
                CloseablePrimitiveIteratorOfFloat.this.close();
            }
        };
    }

    default public DoubleStream streamAsDouble(@NotNull FloatToDoubleFunction adapter) {
        return this.adaptToOfDouble(adapter).doubleStream();
    }

    default public DoubleStream streamAsDouble() {
        return this.streamAsDouble(value -> value);
    }

    public static CloseablePrimitiveIteratorOfFloat empty() {
        return EMPTY;
    }

    public static CloseablePrimitiveIteratorOfFloat of(final float ... values) {
        Objects.requireNonNull(values);
        return new CloseablePrimitiveIteratorOfFloat(){
            private int valueIndex;

            @Override
            public float nextFloat() {
                if (this.valueIndex < values.length) {
                    return values[this.valueIndex++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfFloat repeat(final float value, final long repeatCount) {
        return new CloseablePrimitiveIteratorOfFloat(){
            private long repeatIndex;

            @Override
            public float nextFloat() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfFloat concat(final CloseablePrimitiveIteratorOfFloat ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseablePrimitiveIteratorOfFloat.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseablePrimitiveIteratorOfFloat(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public float nextFloat() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].nextFloat();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((AutoCloseable[])subIterators);
            }
        };
    }

    public static CloseablePrimitiveIteratorOfFloat maybeConcat(@Nullable CloseablePrimitiveIteratorOfFloat first, @Nullable CloseablePrimitiveIteratorOfFloat second, @Nullable CloseablePrimitiveIteratorOfFloat third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseablePrimitiveIteratorOfFloat.concat(first, second, third);
                }
                return CloseablePrimitiveIteratorOfFloat.concat(first, second);
            }
            if (third != null) {
                return CloseablePrimitiveIteratorOfFloat.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseablePrimitiveIteratorOfFloat.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseablePrimitiveIteratorOfFloat.empty();
    }
}

